/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="Vepay", urlPatterns={"/vepay/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block28: {
            try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
                String callbackKey;
                int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                StringBuilder params = new StringBuilder();
                for (Map.Entry entry : request.getParameterMap().entrySet()) {
                    params.append((String)entry.getKey()).append("=");
                    for (String value : (String[])entry.getValue()) {
                        params.append(params.charAt(params.length() - 1) == '=' ? "" : "; ").append(value);
                    }
                    params.append("\n");
                }
                String id = request.getParameter("id");
                String key = request.getParameter("key");
                String sum = request.getParameter("sum");
                String extId = request.getParameter("extid");
                String status = request.getParameter("status");
                if (logger.isDebugEnabled()) {
                    logger.debug(params.toString());
                }
                if (key.equals(Utils.getDigest((String)(id + sum + status + (callbackKey = moduleSetup.get("vepay.callback.key", ""))), (String)"UTF-8").toLowerCase())) {
                    this.sendError(response, 1, "Key error...");
                    return;
                }
                if (extId != null) {
                    try (PaymentDao paymentDao = new PaymentDao(con);
                         TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                        Transaction transaction = transactionManager.getTransactionByTransactionId(id);
                        if (transaction == null) {
                            String message = "Not found transaction for ID = " + extId;
                            logger.error(message);
                            this.sendError(response, 2, message);
                            return;
                        }
                        this.sendError(response, 0, "");
                        transactionManager.doCheckRequest(transaction);
                        break block28;
                    }
                }
                String message = "extId == null";
                logger.error("extId == null");
                this.sendError(response, 3, "extId == null");
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                this.sendError(response, 4, ex.getMessage());
            }
        }
    }

    private void sendError(HttpServletResponse response, int status, String message) {
        try {
            JSONObject msg = new JSONObject();
            msg.put("status", status);
            msg.put("message", (Object)message);
            response.sendError(200, msg.toString());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

