/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class AttributeTypeDao
extends AbstractIdDao<AttributeType> {
    public AttributeTypeDao(Connection con, int mid) {
        super(con, mid, "bill_attribute_type");
    }

    public List<AttributeType> getAttributeTypeList() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    public AttributeType getAttributeTypeByName(String name) throws BGException {
        return (AttributeType)this.get("name=?", new Object[]{name});
    }

    public Map<String, AttributeType> getAttributeTypeMap() throws BGException {
        HashMap<String, AttributeType> attributeTypeMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType : this.getAttributeTypeList()) {
            attributeTypeMap.put(attributeType.getName(), attributeType);
        }
        return attributeTypeMap;
    }

    protected void updateImpl(AttributeType attributeType) throws BGException, SQLException {
        if (attributeType != null) {
            String fields = this.tableName + " SET name=?, title=?, `check`=?";
            String query = attributeType.getId() < 1 ? "INSERT INTO " + fields : "UPDATE " + fields + " WHERE id=" + attributeType.getId();
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setString(1, attributeType.getName());
                ps.setString(2, attributeType.getTitle());
                ps.setString(3, attributeType.getCheck());
                ps.executeUpdate();
                if (attributeType.getId() < 0) {
                    attributeType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
            }
            catch (SQLIntegrityConstraintViolationException e) {
                throw new BGMessageException("\u0422\u0438\u043f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 \u0441 \u0442\u0430\u043a\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
        }
    }

    public void deleteAttributeTypeByName(String name) throws BGException {
        this.delete("name=?", new Object[]{name});
    }

    protected AttributeType getFromRS(ResultSet rs) throws SQLException, BGException {
        return AttributeType.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setName(rs.getString("name")).setCheck(rs.getString("check")).build();
    }
}

