/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client;

import java.awt.AWTEvent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.AWTEventListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.cerbercrypt.client.PacketEditor;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.PacketService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.function.Async;

public class ServiceConfigPackets
extends BGUTabPanel {
    private BGUList<Packet> packetList = new BGUList();
    private PacketEditor packetEditor = new PacketEditor();
    private JPanel rightPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();

    public ServiceConfigPackets() {
        this.packetEditor.setPacketsPanel(this);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JScrollPane((Component)this.packetList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel emptyPanel = new JPanel();
        emptyPanel.setLayout(new GridBagLayout());
        emptyPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043a\u0435\u0442"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)((Object)this.packetEditor), "editor");
        this.rightPanel.add((Component)emptyPanel, "empty");
        this.cardLayout.show(this.rightPanel, "empty");
        ClientUtils.addOpenAction(this.packetList, (AWTEventListener)new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                ServiceConfigPackets.this.performAction("edit");
            }
        });
        ClientUtils.addShowCodeListener(this.packetList);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)this.rightPanel, 400L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.packetList.setCellRenderer((ListCellRenderer)new TwolineListCellRenderer());
    }

    protected void jbInit() throws Exception {
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.packetList.setData(((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).packetList(null))));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            Packet ch = new Packet();
            ch.setId(0);
            ch.setTitle("\u041d\u043e\u0432\u044b\u0439 \u043f\u0430\u043a\u0435\u0442");
            int newid = ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).updatePacket(ch);
            this.startEdit(newid);
            this.performAction("refresh");
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Packet li = (Packet)this.packetList.getSelectedValue();
            if (li != null) {
                this.startEdit(li.getId());
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Packet li = (Packet)this.packetList.getSelectedValue();
            if (li != null && ClientUtils.confirmDelete((Object)"\u043f\u0430\u043a\u0435\u0442")) {
                ((PacketService)((ClientContext)this.getContext()).getPort(PacketService.class)).deletePacket(li.getId());
                this.hideEditor();
            }
        });
    }

    private void startEdit(int packetId) {
        this.packetEditor.setPacketId(packetId);
        this.cardLayout.show(this.rightPanel, "editor");
        this.packetEditor.performAction("refresh");
    }

    public void hideEditor() {
        this.cardLayout.show(this.rightPanel, "empty");
        this.performAction("refresh");
    }

    class TwolineListCellRenderer
    implements ListCellRenderer<Packet> {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        TwolineListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Packet item, int index, boolean isSelected, boolean cellHasFocus) {
            Object comment;
            int MAX_LENGTH_COMMENT = 32;
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, item, index, isSelected, cellHasFocus);
            Object object = comment = item.getComment() != null ? item.getComment() : "";
            if (((String)comment).length() > 32) {
                comment = ((String)comment).substring(0, 32) + "\u2026";
            }
            renderer.setText("<html>" + item.getTitle() + (String)(Utils.notBlankString((String)comment) ? "<br>&nbsp;&nbsp;&nbsp;<font size='-2' color='#999999'>" + (String)comment + "</font>" : "") + "</html>");
            return renderer;
        }
    }
}

