/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgentStatus;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.common.service.DrwebService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.IdTitle;

public class AgentEditPanel
extends BGUPanel {
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    BGUComboBox<Status> statusCb = new BGUComboBox();
    BGUComboBox<DrwebTariff> tariffCb = new BGUComboBox();
    private BGUTable table;
    private BGTableModel<DrwebAgentStatus> model;
    private BGButton okButton = new BGButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c");
    private BGButtonPanel controlPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.GLUE, BGButtonPanel.CLOSE});
    private DrwebAgent agent = null;

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0421\u0442\u0430\u0442\u0443\u0441\u044b \u0430\u0433\u0435\u043d\u0442\u0430"));
        this.model = new BGTableModel<DrwebAgentStatus>("statusList"){

            protected void initColumns() {
                this.addColumn("", 0, 0, 0, "id", false);
                this.addColumn("\u0414\u0430\u0442\u0430", Column.DateTime.class, -1, 150, -1, "statusDate", true);
                this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", "statusString", true);
                this.addColumn("\u0422\u0430\u0440\u0438\u0444", "tariffTitle", true);
            }
        };
        this.table = new BGUTable(this.model);
        this.table.setSelectionMode(0);
        this.controlPanel.setSelected(BGButtonPanel.CLOSE);
        this.controlPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if ("close".equals(actionCommand)) {
                    AgentEditPanel.this.setVisible(false);
                }
            }
        });
        JPanel statusControlPanel = new JPanel();
        statusControlPanel.setLayout(new GridBagLayout());
        statusControlPanel.add((Component)new JLabel("\u0421 \u0434\u0430\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        statusControlPanel.add((Component)this.date, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        statusControlPanel.add((Component)this.statusCb, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        statusControlPanel.add((Component)this.tariffCb, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        statusControlPanel.add((Component)this.okButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        ArrayList<Status> statusList = new ArrayList<Status>();
        statusList.add(new Status(1, "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c"));
        statusList.add(new Status(3, "\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c"));
        this.statusCb.setData(statusList);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgentEditPanel.this.changeStatus();
            }
        });
        this.add(statusControlPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.controlPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setAgent(DrwebAgent agent) {
        this.agent = agent;
        List statusList = null;
        try {
            DrwebService drwebService = (DrwebService)((ClientContext)this.getContext()).getPort(DrwebService.class);
            statusList = drwebService.agentStatusList(agent.getId());
            this.model.setData(statusList, true);
            this.tariffCb.setData(drwebService.allTariffList());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void changeStatus() {
        Date dateFrom = TimeUtils.convertCalendarToDate((Calendar)this.date.getDateCalendar());
        if (dateFrom == null) {
            BGToolTip.showErrorMessage((JComponent)this.date, (String)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
            return;
        }
        if (TimeUtils.dateBefore((Date)dateFrom, (Date)new Date())) {
            BGToolTip.showErrorMessage((JComponent)this.date, (String)"\u0414\u0430\u0442\u0430 \u0440\u0430\u043d\u0435\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0434\u043d\u044f");
        }
        Date now = new Date();
        boolean rewrite = true;
        if (TimeUtils.dateEqual((Date)dateFrom, (Date)now)) {
            dateFrom = now;
            rewrite = false;
        }
        try {
            DrwebAgentStatus status = new DrwebAgentStatus();
            status.setAgentId(this.agent.getId());
            status.setStatusDate(dateFrom);
            status.setDt(now);
            status.setStatus(((Status)this.statusCb.getSelectedItem()).getId());
            status.setTariffId(((DrwebTariff)this.tariffCb.getSelectedItem()).getId());
            ((DrwebService)((ClientContext)this.getContext()).getPort(DrwebService.class)).statusChange(status, rewrite);
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        this.setAgent(this.agent);
    }

    public class Status
    extends IdTitle {
        public Status() {
        }

        public Status(int id, String title) {
            super(id, title);
        }
    }
}

