/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.HostingServer;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class HostingServerManager {
    private Connection con;
    private String tableName;

    public HostingServerManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_hosting_server_" + mid;
    }

    public List<HostingServer> getServerList() {
        ArrayList<HostingServer> result = new ArrayList<HostingServer>();
        try {
            String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getServerFromRs(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public HostingServer getServer(int id) {
        HostingServer result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getServerFromRs(rs);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateServer(HostingServer server) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (server.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (title, addr, comment) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE " + this.tableName + " SET title=?, addr=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(4, server.getId());
            }
            ps.setString(1, server.getTitle());
            ps.setString(2, server.getAddr());
            ps.setString(3, server.getComment());
            ps.executeUpdate();
            if (server.getId() <= 0) {
                server.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteServer(int id) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HostingServer getServerFromRs(ResultSet rs) throws SQLException {
        HostingServer result = new HostingServer();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setAddr(rs.getString("addr"));
        result.setComment(rs.getString("comment"));
        return result;
    }
}

