/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNode;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeEntry;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeGroup;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeRoot;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.common.IRosterItem;
import ru.bitel.bgbilling.plugins.im.common.RosterEntryItem;
import ru.bitel.bgbilling.plugins.im.common.RosterRootItem;

public class RosterTree {
    private RosterTreeNodeRoot rootNode;
    private JTree viewableTree;
    private Map<String, RosterTreeNodeGroup> groupMap = new HashMap<String, RosterTreeNodeGroup>();
    private Map<String, RosterTreeNodeEntry> entryMap = new HashMap<String, RosterTreeNodeEntry>();
    private Map<String, RosterTreeNodeGroup> entry2groupMap = new HashMap<String, RosterTreeNodeGroup>();
    private Map<String, String> entry2nameMap = new HashMap<String, String>();

    public RosterTree() {
        this.rootNode = new RosterTreeNodeRoot(this);
        this.viewableTree = new JTree(this.rootNode);
        RosterTreeRenderer renderer = new RosterTreeRenderer();
        this.viewableTree.setCellRenderer(renderer);
        this.viewableTree.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.viewableTree.setRowHeight(20);
        this.viewableTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RosterTree.this.viewableTree.setSelectionPath(RosterTree.this.viewableTree.getPathForLocation(e.getX(), e.getY()));
                RosterTreeNode selectedNode = (RosterTreeNode)RosterTree.this.viewableTree.getLastSelectedPathComponent();
                if (selectedNode != null) {
                    JPopupMenu menuPopup;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && selectedNode instanceof RosterTreeNodeEntry) {
                        RosterTreeNodeEntry nodeEntry = (RosterTreeNodeEntry)selectedNode;
                        PluginClientListener.imManager.openChat(nodeEntry.getJid(), true);
                    }
                    if (SwingUtilities.isRightMouseButton(e) && (menuPopup = selectedNode.getPopupMenu()) != null) {
                        menuPopup.show(RosterTree.this.viewableTree, e.getX(), e.getY());
                    }
                }
            }
        });
        this.viewableTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TreePath tp = RosterTree.this.viewableTree.getPathForLocation(e.getX(), e.getY());
                if (tp != null) {
                    RosterTreeNode selectedNode = (RosterTreeNode)tp.getLastPathComponent();
                    RosterTree.this.viewableTree.setToolTipText(selectedNode.getToolTipText());
                }
            }
        });
    }

    public void loadTree(RosterRootItem roster) {
        List<String> save = this.rootNode.getExpandedGroupList();
        this.rootNode.removeAllChildren();
        this.groupMap.clear();
        this.entryMap.clear();
        this.entry2groupMap.clear();
        this.entry2nameMap.clear();
        this.rootNode.loadNode((IRosterItem)roster);
        this.viewableTree.expandPath(new TreePath(this.rootNode.getPath()));
        this.rootNode.setExpandedGroupList(save);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RosterTree.this.viewableTree.updateUI();
            }
        });
    }

    public JTree getViewableTree() {
        return this.viewableTree;
    }

    public Map<String, RosterTreeNodeGroup> getGroupMap() {
        return this.groupMap;
    }

    public Map<String, RosterTreeNodeEntry> getEntryMap() {
        return this.entryMap;
    }

    public Map<String, RosterTreeNodeGroup> getEntry2groupMap() {
        return this.entry2groupMap;
    }

    public Map<String, String> getEntry2nameMap() {
        return this.entry2nameMap;
    }

    public void deleteEntryUser(String jid) {
        if (jid != null) {
            RosterTreeNodeGroup groupNode = this.entry2groupMap.get(jid);
            if (groupNode != null) {
                groupNode.deleteEntryFromGroup(jid);
            } else {
                System.out.println("ERROR deleteEntryUser(" + jid + "): group not found");
            }
        }
    }

    public void changeEntryUser(RosterEntryItem el) {
        String jid = el.from;
        RosterTreeNodeGroup groupNode = this.entry2groupMap.get(IMUtils.getPureJID((String)jid));
        if (groupNode == null && (groupNode = this.groupMap.get("General")) == null) {
            groupNode = this.rootNode.insertGroupToRoot("General");
        }
        groupNode.changeEntryFromGroup(el);
    }

    public void setOfflinedTree() {
        for (RosterTreeNodeEntry node : this.entryMap.values()) {
            node.setStatus(IMConstants.STATUS.OFFLINE);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RosterTree.this.viewableTree.updateUI();
            }
        });
    }

    public void setRosterJson(String jsonString) {
        if (jsonString != null) {
            try {
                RosterRootItem doc = IMUtils.jsonToRoster((String)jsonString);
                this.loadTree(doc);
            }
            catch (Exception e) {
                System.out.println("ERROR parse user config (roster json): " + e);
                e.printStackTrace();
            }
        }
    }

    public String getRosterJson() {
        return this.rootNode.getJson();
    }

    private static class RosterTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final Color foregroundColor = Color.black;
        private static final Color selectionColor = Color.red;

        private RosterTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel comp = new JLabel("...");
            if (value instanceof RosterTreeNode) {
                RosterTreeNode node = (RosterTreeNode)value;
                comp = node.getView();
                ((Component)comp).setForeground(foregroundColor);
            }
            if (selected) {
                ((Component)comp).setForeground(selectionColor);
            }
            comp.repaint();
            return comp;
        }
    }
}

