/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.web;

import jakarta.annotation.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficRangeDetailValue;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.action.web.AbstractChartReport;
import ru.bitel.bgbilling.modules.inet.server.action.web.TimeSeriesEx;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.reports.Charts;

public class ActionTrafficRangeReport
extends AbstractChartReport {
    @Resource
    ModuleService moduleService;
    @Resource
    InetSessionService sessionService;
    @Resource
    InetServService servService;

    public void execute() throws BGException {
        int servId = this.req.getInt("inetServId", -1);
        int unit = this.req.getInt("unit", 0x100000);
        int tariffOptionId = this.req.getInt("tariffOptionId", -1);
        Period period = this.getPeriodByYearMonthDay();
        Set trafficTypeIds = Collections.emptySet();
        String[] trafficTypeIdsString = this.context.getRequest().getParameterValues("trafficTypeIds");
        if (trafficTypeIdsString != null) {
            trafficTypeIds = Utils.toIntegerSet((String)Utils.toString(Arrays.asList(trafficTypeIdsString)));
            trafficTypeIds.remove(0);
        }
        List inetServList = this.servService.inetServList(this.contractId, "dateTo, dateFrom");
        inetServList.stream().forEach(serv -> serv.setTitle(serv.getTitle() + " (" + TimeUtils.formatPeriod((Date)serv.getDateFrom(), (Date)serv.getDateTo()) + ")"));
        this.setResultParam("servs", inetServList);
        this.setResultParam("inetServId", servId);
        this.setResultParam("unit", unit);
        boolean byDay = !TimeUtils.dateEqual((Date)period.getDateFrom(), (Date)period.getDateTo());
        List result = this.sessionService.inetSessionTrafficRange(this.contractId, tariffOptionId, period.getDateFrom(), period.getDateTo(), (long)unit);
        if (this.context.isView()) {
            String chart = this.chart(period.getDateFrom(), result, unit);
            this.setResultParam("chart", chart);
        }
        if (byDay) {
            Calendar calendar = period.getDateFromCalendar();
            int last = calendar.getActualMaximum(5);
            ArrayList<Integer> days = new ArrayList<Integer>();
            for (int i = 1; i <= last; ++i) {
                days.add(i);
            }
            this.setResultParam("days", days);
        }
        this.setResult(result);
        this.setResultParam("result", result);
    }

    private void add(String title, List<TimeSeriesEx> timeSeriesList, Map<String, TimeSeriesEx> timeSeriesMap, long treeNodeId, long rangeKey, boolean group, RegularTimePeriod timePeriod, long amount, long unit, String suffix, RegularTimePeriod timeFromPeriod) {
        Object key = group ? String.valueOf(treeNodeId) : treeNodeId + ":" + rangeKey;
        TimeSeriesEx timeSeries = timeSeriesMap.get(key);
        if (timeSeries == null) {
            timeSeries = new TimeSeriesEx(title + suffix);
            timeSeriesMap.put((String)key, timeSeries);
            timeSeriesList.add(timeSeries);
        }
        timeSeries.addOrPlus(timePeriod, (double)amount / (double)unit);
    }

    private String chart(Date dateFrom, List<TrafficRangeDetailReport> trafficRangeList, long unit) throws BGException {
        String result = null;
        String unitTitle = this.getUnitTitle(unit);
        ArrayList<TimeSeriesEx> timeSeriesList = new ArrayList<TimeSeriesEx>();
        HashMap timeSeriesMapTraffic = new HashMap();
        HashMap<String, TimeSeriesEx> timeSeriesMapRange = new HashMap<String, TimeSeriesEx>();
        Day currentTimePeriod = null;
        GregorianCalendar utilCalendar = new GregorianCalendar();
        utilCalendar.setTime(dateFrom);
        for (TrafficRangeDetailReport trafficRangeDetailReport : trafficRangeList) {
            int n = trafficRangeDetailReport.getMode();
            boolean groupChart = switch (n) {
                case 1, 5 -> false;
                default -> true;
            };
            for (TrafficRangeDetailValue detailValue : trafficRangeDetailReport.getDetailValueList()) {
                long rangeKey = detailValue.getRangeKey();
                utilCalendar.setTime(dateFrom);
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                Day timeFromPeriod = switch (n) {
                    default -> new Day(utilCalendar.getTime());
                    case 4 -> new Hour(utilCalendar.getTime());
                };
                block16: for (TrafficRangeDetail detail : detailValue.getDetailList()) {
                    Day timePeriod;
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                    utilCalendar.set(5, detail.getDay());
                    Object suffix = "";
                    switch (n) {
                        case 1: {
                            timePeriod = new Day(utilCalendar.getTime());
                            suffix = " (" + unitTitle + "/\u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                            break;
                        }
                        case 2: {
                            timePeriod = new Day(utilCalendar.getTime());
                            suffix = " (" + unitTitle + "/\u0437\u0430 \u043c\u0435\u0441\u044f\u0446 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                            break;
                        }
                        case 3: {
                            timePeriod = new Day(utilCalendar.getTime());
                            suffix = " (" + unitTitle + "/\u0434\u0435\u043d\u044c)";
                            break;
                        }
                        case 5: {
                            timePeriod = new Day(utilCalendar.getTime());
                            suffix = " (" + unitTitle + "/\u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0439 \u043e\u043f\u0446\u0438\u0438 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                            break;
                        }
                        default: {
                            continue block16;
                        }
                    }
                    if (Utils.isBlankString((String)unitTitle)) {
                        suffix = "";
                    }
                    if (currentTimePeriod != null && !currentTimePeriod.next().equals(timePeriod)) {
                        RegularTimePeriod prev;
                        RegularTimePeriod next = currentTimePeriod.next();
                        if (next.equals(prev = timePeriod.previous())) {
                            for (TimeSeriesEx timeSeries : timeSeriesList) {
                                timeSeries.addOrPlus(next, 0.0);
                            }
                        } else {
                            for (TimeSeriesEx timeSeries : timeSeriesList) {
                                timeSeries.addOrPlus(next, 0.0);
                                timeSeries.addOrPlus(prev, 0.0);
                            }
                        }
                    }
                    currentTimePeriod = timePeriod;
                    this.add(trafficRangeDetailReport.getTitle(), timeSeriesList, timeSeriesMapRange, trafficRangeDetailReport.getTreeNodeId(), rangeKey, groupChart, (RegularTimePeriod)timePeriod, detail.getAmount(), unit, (String)suffix, (RegularTimePeriod)timeFromPeriod);
                }
            }
        }
        for (TimeSeriesEx timeSeriesEx : timeSeriesList) {
            timeSeriesEx.addOrPlus(currentTimePeriod.next(), 0.0);
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (TimeSeries timeSeries : timeSeriesList) {
            dataset.addSeries(timeSeries);
        }
        try {
            XYStepRenderer xYStepRenderer = new XYStepRenderer();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            ChartUtils.writeChartAsPNG((OutputStream)byteArrayOutputStream, (JFreeChart)Charts.createTimeSeriesChart((XYItemRenderer)xYStepRenderer, (XYDataset)dataset, (DrawingSupplier)Charts.getDrawingSupplier(null, null)), (int)800, (int)300, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
            result = this.addChart(byteArrayOutputStream);
            Object var14_22 = null;
        }
        catch (IOException iOException) {
            throw new BGException((Throwable)iOException);
        }
        for (TimeSeries timeSeries : timeSeriesList) {
            timeSeries.clear();
        }
        timeSeriesList.clear();
        timeSeriesMapTraffic.clear();
        timeSeriesMapRange.clear();
        return result;
    }
}

