/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class TrafficTypeDao
extends AbstractIdDao<TrafficType>
implements Directory<TrafficType> {
    public TrafficTypeDao(Connection con, int mid) {
        super(con, mid, "inet_traffic_type");
    }

    protected TrafficType getFromRS(ResultSet rs) throws SQLException, BGException {
        TrafficType result = new TrafficType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setUnit(rs.getInt("unit"));
        return result;
    }

    protected void updateImpl(TrafficType b) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString((String)b.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, unit) VALUES (?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, unit=? WHERE id=?");
            ps.setInt(3, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setInt(2, b.getUnit());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public TrafficType get(String title) throws BGException {
        return (TrafficType)this.get("title=?", new Object[]{title});
    }

    public List<TrafficType> list() throws BGException {
        List result = this.list(null, "id", new Object[0]);
        result.add(0, TrafficType.TIME);
        return result;
    }
}

