/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuleRuntime;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.Ranger;

public class TrafficTypeLinkRuntime
extends BGLogger {
    public final String title;
    public final TrafficTypeLinkRuleRuntime[] trafficTypeLinkRulesFlow;
    public final TrafficTypeLinkRuleRuntime[] trafficTypeLinkRulesCounter;
    public Set<Integer> counterTrafficTypes;
    public Integer[] trafficServiceIds;
    public Set<Integer> trafficServiceIdSet;
    private static final Ranger<TrafficTypeLinkRule, Date> ranger = new Ranger<TrafficTypeLinkRule, Date>(){

        public Date getMinValue(TrafficTypeLinkRule r) {
            return r.dateFrom;
        }

        public Date getMaxValue(TrafficTypeLinkRule r) {
            return r.dateTo;
        }
    };

    TrafficTypeLinkRuntime(TrafficTypeLink trafficTypeLink, Date dateFrom) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("trafficTypeLink: [{}]; dateFrom={}", (Object)trafficTypeLink, (Object)dateFrom);
        }
        this.title = trafficTypeLink.getTitle();
        List ruleList = RangeUtils.subListContains((Collection)trafficTypeLink.getTrafficTypeLinkRuleList(), ranger, (Comparable)dateFrom, (Comparable)dateFrom);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ruleList.size()={}", (Object)ruleList.size());
        }
        ArrayList<TrafficTypeLinkRuleRuntime> trafficTypeLinkRuleListCounter = new ArrayList<TrafficTypeLinkRuleRuntime>();
        ArrayList<TrafficTypeLinkRuleRuntime> trafficTypeLinkRuleListFlow = new ArrayList<TrafficTypeLinkRuleRuntime>();
        Set serviceIds = Collections.newSetFromMap(new LinkedHashMap());
        serviceIds.add(-TrafficType.TIME_ID.intValue() - 1);
        for (TrafficTypeLinkRule rule : ruleList) {
            if (rule.type == 1) {
                trafficTypeLinkRuleListCounter.add(TrafficTypeLinkRuleRuntime.newInstance(rule));
            } else {
                trafficTypeLinkRuleListFlow.add(TrafficTypeLinkRuleRuntime.newInstance(rule));
            }
            serviceIds.add(-rule.trafficTypeId.intValue() - 1);
        }
        this.trafficTypeLinkRulesCounter = trafficTypeLinkRuleListCounter.toArray(new TrafficTypeLinkRuleRuntime[trafficTypeLinkRuleListCounter.size()]);
        this.trafficTypeLinkRulesFlow = trafficTypeLinkRuleListFlow.toArray(new TrafficTypeLinkRuleRuntime[trafficTypeLinkRuleListFlow.size()]);
        this.trafficServiceIds = serviceIds.toArray(new Integer[serviceIds.size()]);
        this.trafficServiceIdSet = Collections.unmodifiableSet(serviceIds);
        this.counterTrafficTypes = new HashSet<Integer>();
        for (TrafficTypeLinkRuleRuntime rule : this.trafficTypeLinkRulesCounter) {
            this.counterTrafficTypes.add(rule.trafficTypeId);
        }
    }

    public TrafficTypeLinkRuleRuntime getRule(int sourceId, int direction, int iface, IpAddress address, int port, int diffServ, long millis, int inetServInterfaceId) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getRule( sourceId={}, direction={}, iface={}, address={}, port={}, diffServ={}, millis={}, inetServInterfaceId={} )", (Object)sourceId, (Object)direction, (Object)iface, (Object)address, (Object)port, (Object)diffServ, (Object)millis, (Object)inetServInterfaceId);
        }
        TrafficTypeLinkRuleRuntime[] rules = this.trafficTypeLinkRulesFlow;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("rules.length={}", (Object)rules.length);
        }
        for (int i = 0; i < rules.length; ++i) {
            TrafficTypeLinkRuleRuntime rule = rules[i];
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("rule={}", (Object)rule.toString());
            }
            if (rule.sourceId > 0 && rule.sourceId != sourceId) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("rule.sourceId [{}] > 0 && rule.sourceId [{}] != sourceId [{}]", (Object)rule.sourceId, (Object)rule.sourceId, (Object)sourceId);
                continue;
            }
            if (rule.direction != direction && rule.direction != 0) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("rule.direction [{}] != direction [{}] && rule.direction [{}] != 0", (Object)rule.direction, (Object)direction, (Object)rule.direction);
                continue;
            }
            if (rule.interfaceId >= 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("rule.interfaceId [{}] >= 0", (Object)rule.interfaceId);
                }
                if (rule.interfaceId != iface) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("rule.interfaceId [{}] != iface [{}]", (Object)rule.interfaceId, (Object)iface);
                    continue;
                }
            } else if (rule.interfaceId == -2) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("rule.interfaceId [{}] == -2", (Object)rule.interfaceId);
                }
                if (inetServInterfaceId != iface) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("inetServInterfaceId [{}] != iface [{}]", (Object)inetServInterfaceId, (Object)iface);
                    continue;
                }
            }
            if (rule.diffServ != -1 && (diffServ & rule.diffServMask) != rule.diffServ) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("rule.diffServ [{}] != -1 && ((diffServ [{}] & rule.diffServMask [{}]) != rule.diffServ [{}])", (Object)rule.diffServ, (Object)diffServ, (Object)rule.diffServMask, (Object)rule.diffServ);
                continue;
            }
            if (rule.timeFrom != 0L && rule.timeFrom > millis || rule.timeTo != 0L && rule.timeTo < millis) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("(rule.timeFrom [{}] != 0L && rule.timeFrom > millis [{}]) || (rule.timeTo [{}] != 0L && rule.timeTo < millis [{}])", (Object)rule.timeFrom, (Object)millis, (Object)rule.timeTo, (Object)millis);
                continue;
            }
            if (rule.addressFrom != null && rule.addressFrom.compareTo(address) > 0 || rule.addressTo != null && rule.addressTo.compareTo(address) < 0) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("(rule.addressFrom != null && rule.addressFrom.compareTo( address ) > 0) || (rule.addressTo != null && rule.addressTo.compareTo( address ) < 0)");
                continue;
            }
            if (rule.portFrom != 0 && rule.portFrom > port || rule.portTo != 0 && rule.portTo < port) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("(rule.portFrom [{}] != 0 && rule.portFrom [{}] > port [{}]) || (rule.portTo [{}] != 0 && rule.portTo [{}] < port [{}])", (Object)rule.portFrom, (Object)rule.portFrom, (Object)port, (Object)rule.portTo, (Object)rule.portTo, (Object)port);
                continue;
            }
            return rule;
        }
        return null;
    }
}

