/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.AdminPortListener;
import bitel.billing.server.ApplicationModule;
import bitel.billing.server.admin.bgsecure.bean.JAAS;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebServlet;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.scan.StandardJarScanner;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.LicCheckTask;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.MQCheckTask;
import ru.bitel.bgbilling.kernel.base.converters.BGConverter;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.ReadWriteClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ServerStartEvent;
import ru.bitel.bgbilling.kernel.event.processors.ServerEventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.pc.server.BGServerUtils;
import ru.bitel.bgbilling.kernel.pc.server.MyAccessLogValve;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.update.server.LibInfoUtil;
import ru.bitel.bgbilling.server.installer.server.ComponentUpdate;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.Log4j2;
import ru.bitel.common.logging.LoggingPrintStream;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class Server
extends Tomcat
implements BGServerUtils {
    private static Logger log = null;
    private static Setup setup;
    private StandardContext rootContext;
    private StandardContext uiContext;
    public static final Date START_TIME;
    public static final String CONTEXT_PATH_BGBILLING = "/bgbilling";
    public static final String CONTEXT_PATH_BGUI = "/bgui";

    public static void main(String[] args) {
        Log4j2.init((String)"data");
        log = LogManager.getLogger();
        Preferences _setup = new Preferences("data.data");
        int adminPort = _setup.getInt("port.admin", 2005);
        if (args.length > 0) {
            if (args[0].trim().equals("start")) {
                new Server();
            } else {
                Server.executeCommand("127.0.0.1", args, adminPort);
            }
        } else {
            Server.showHelp();
        }
    }

    public Server() {
        BGNestedContext.push((String)"server");
        LoggingPrintStream.assignToOutput();
        String catalinaHome = ServerUtils.getServerHome();
        this.setBaseDir(catalinaHome);
        log.info("catalina.base = " + catalinaHome);
        this.checkFiles(new String[]{"custom.css"});
        this.checkFiles(new String[]{"js", "custom.js"});
        Server.initSetup();
        new ComponentUpdate(setup);
        UserMap.initUserMap();
        LibInfoUtil.getClientLibInfos();
        try {
            log.info("Starting BGBillingServer...");
            System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
            String hostname = setup.get("server.host.name", "localhost.localdomain");
            this.getEngine().setDefaultHost(hostname);
            this.getHost().setName(hostname);
            this.getHost().setAppBase(catalinaHome + "/webroot");
            this.rootContext = this.addContext(catalinaHome, setup.get("context.path", CONTEXT_PATH_BGBILLING), "webroot");
            if (setup.getBoolean("bgui.enable", false)) {
                this.uiContext = this.addContext(catalinaHome, setup.get("context.path.ui", CONTEXT_PATH_BGUI), "webui");
            }
            this.initConnectors(this.getService(), this.getConnector());
            try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)setup, (boolean)true);){
                DomainRuntimeMap.getInstance(connectionSet);
            }
            ServerEventProcessor serverEventProcessor = new ServerEventProcessor(setup);
            AlarmSender.initSender(setup);
            AlarmSender.registerAlarmTask(new DatabaseCheckTask());
            AlarmSender.registerAlarmTask(new LicCheckTask());
            AlarmSender.registerAlarmTask(new MQCheckTask());
            try {
                Utils.checkJava();
            }
            catch (BGException e) {
                AlarmSender.sendAlarm(new AlarmErrorMessage("bad.java", "\u0421\u0435\u0440\u0432\u0435\u0440: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f Java", e.getMessage()), System.currentTimeMillis());
            }
            if (setup.get("no.event.process", null) == null) {
                ReadWriteClassManager manager = new ReadWriteClassManager();
                DynamicClassManager.setInstance(manager);
                if (Utils.parseBoolean((String)System.getProperty("dynamic.checkOnStart", setup.get("dynamic.checkOnStart", "1")))) {
                    new Thread(() -> {
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        manager.recompileAll();
                    }, "dyn-class-test").start();
                }
            }
            this.initKernel();
            this.initModules();
            this.initPlugins();
            serverEventProcessor.start();
            new AdminPortListener(setup, setup.getInt("port.admin", 2005));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Server.onServerShutdown();
                }
            });
            System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            log.info("start...");
            this.run\u0421onverters(setup);
            JAAS.init(setup);
            this.start();
            EventProcessor.getInstance().publish(new ServerStartEvent());
            JobScheduler.getInstance("reserve", 0);
            JobScheduler.getInstance("contract_period", 0);
            log.info("Start BGBillingServer OK");
        }
        catch (Exception ex) {
            log.error("HTTP server start alarm: \"" + ex.getMessage() + "\", exiting...", (Throwable)ex);
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private StandardContext addContext(String catalinaHome, String contextPath, String name) {
        StandardContext context = (StandardContext)this.addWebapp(contextPath, catalinaHome + "/" + name);
        context.setDefaultWebXml(catalinaHome + "/data/default.web.xml");
        context.setReloadable(false);
        context.setWorkDir("tmp");
        context.setUseNaming(false);
        context.setSessionTimeout(setup.getInt("context.session.timeout", 30));
        context.setIgnoreAnnotations(true);
        context.setSessionCookiePath("/");
        this.addResources(context);
        StandardJarScanner standardJarScanner = (StandardJarScanner)context.getJarScanner();
        standardJarScanner.setScanManifest(false);
        standardJarScanner.setScanClassPath(false);
        standardJarScanner.setJarScanFilter((type, jarName) -> jarName.endsWith("-server.jar"));
        ParameterMap errorPages = setup.sub(name + ".server.error.");
        for (Map.Entry me : errorPages.entrySet()) {
            ErrorPage errorPage = new ErrorPage();
            errorPage.setErrorCode(Utils.parseInt((String)((String)me.getKey())));
            errorPage.setLocation((String)me.getValue());
            context.addErrorPage(errorPage);
        }
        context.addValve((Valve)new MyAccessLogValve(name));
        return context;
    }

    private void initModules() {
        Connection con = setup.getDBConnectionFromPool();
        ModuleCache.removeModuleInstalledFlag(con);
        log.info("Browsing installed modules... and Creating installed modules map...");
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (BGInstalledModule module : ModuleCache.getInstance().getInstalledModulesList()) {
            if (module.getType() != ComponentType.MODULE) continue;
            String moduleName = module.getName();
            int lastIndex = moduleName.lastIndexOf(46);
            moduleName = lastIndex > -1 ? moduleName.substring(lastIndex + 1) : moduleName;
            VersionInfo versionInfo = VersionInfo.getVersionInfo((String)moduleName);
            if (versionInfo != null && versionInfo.getVersion() != null && versionInfo.getVersion().trim().length() > 0) {
                log.info("Module " + module.getName() + " ver. " + versionInfo.getVersionString());
            } else {
                log.info("Module " + module.getName() + " ver." + module.getVersion());
            }
            map2.put(module.getName(), module.getPackageServer());
            this.setServletAndFilters(this.rootContext, module.getPackageServer() + ".servlet");
        }
        this.rootContext.getServletContext().setAttribute("installed_modules_map", map2);
        try {
            javax.naming.Context env = Setup.getEnvironment();
            for (BGModule module : ModuleCache.getInstance().getModulesList()) {
                ApplicationModule applicationModule;
                javax.naming.Context ctx = null;
                try {
                    ctx = (javax.naming.Context)env.lookup(String.valueOf(module.getId()));
                }
                catch (Exception versionInfo) {
                    // empty catch block
                }
                if (ctx == null) {
                    ctx = env.createSubcontext(String.valueOf(module.getId()));
                }
                if ((applicationModule = ModuleCache.getInstance().getApplicationModule(module.getName())) == null) continue;
                try {
                    applicationModule.start(con, module);
                }
                catch (BGException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (NamingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ServerUtils.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPlugins() {
        Connection con = setup.getDBConnectionFromPool();
        try {
            BGPluginManagerServer bgPluginManagerServer = BGPluginManagerServer.getManager();
            bgPluginManagerServer.init(con, "server");
            log.info("Browsing installed plugins...");
            for (Map.Entry<String, BGPluginServer> plugin : bgPluginManagerServer.getPluginsMap().entrySet()) {
                String pluginName = plugin.getKey();
                int lastIndex = pluginName.lastIndexOf(46);
                pluginName = lastIndex > -1 ? pluginName.substring(lastIndex + 1) : pluginName;
                VersionInfo versionInfo = VersionInfo.getVersionInfo((String)pluginName);
                if (versionInfo != null && versionInfo.getVersion() != null && versionInfo.getVersion().trim().length() > 0) {
                    log.info("Plugin " + plugin.getKey() + " ver. " + versionInfo.getVersionString());
                } else {
                    log.info("Plugin " + plugin.getKey() + " ver. ???");
                }
                this.setServletAndFilters(this.rootContext, plugin.getValue().getPackServer() + ".servlet");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private void run\u0421onverters(Setup setup) {
        List classes = Utils.getClassList((String)"ru.bitel.bgbilling.kernel.base.converters");
        for (Class clazz : classes) {
            if (!BGConverter.class.isAssignableFrom(clazz) || clazz.getSuperclass() == null) continue;
            try {
                Connection con = setup.getDBConnectionFromPool();
                try {
                    BGConverter converter = (BGConverter)Utils.newInstance((String)clazz.getName(), (Class)clazz);
                    if (converter == null) continue;
                    converter.runConverter(con);
                }
                finally {
                    if (con == null) continue;
                    con.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public static void setSetup(Setup setup) {
        Server.setup = setup;
        UserMap.initUserMap();
    }

    public static void initSetup() {
        if (setup != null) {
            return;
        }
        setup = new Setup("data.data");
        Setup.setSetup(setup);
    }

    public static void exit() {
        Server.main(new String[]{"stop"});
    }

    private static void executeCommand(String host, String[] args, int port) {
        try {
            StringBuffer command = new StringBuffer(args[0]);
            for (int i = 1; i < args.length; ++i) {
                command.append(" ");
                command.append(args[i]);
            }
            byte[] data = command.toString().getBytes("ISO-8859-1");
            DatagramPacket packet = new DatagramPacket(data, data.length);
            packet.setAddress(InetAddress.getByName(host));
            packet.setPort(port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            byte[] buffer = new byte[1000000];
            DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
            socket.setSoTimeout(3000);
            socket.receive(responsePacket);
            socket.close();
            System.out.println(new String(responsePacket.getData(), 0, responsePacket.getLength(), "ISO-8859-1"));
        }
        catch (SocketTimeoutException ex) {
            System.err.println("Error: " + host + ":" + port + " unavailable: " + ex.getLocalizedMessage());
        }
        catch (Exception ex) {
            System.err.println("Error: " + host + ":" + port + ": " + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|status|sysvar|javavar|conpool|help]");
        sb.append("\nParameters:");
        sb.append("\n\t help                       - show this help");
        sb.append("\n\t start                      - starting BGBillingServer");
        sb.append("\n\t stop                       - stopping BGBillingServer");
        sb.append("\n\t sysvar                     - show system variables");
        sb.append("\n\t javavar                    - show java properties");
        sb.append("\n\t conpool                    - show connection pool trace, need option db.trace=1 in data.properties");
        sb.append("\n\t diskBenchmark           - disk benchmark");
        sb.append("\n\nExample: application.sh start");
        sb.append("\nExample: application.sh status");
        System.out.println(sb.toString());
    }

    private void initKernel() {
        this.setServletAndFilters(this.rootContext, "ru.bitel.bgbilling.kernel.base.server.servlet");
        List customServletPackages = Utils.toList((String)setup.get("custom.servlet.package"));
        if (customServletPackages != null && !customServletPackages.isEmpty()) {
            customServletPackages.forEach(a -> {
                log.info("Add custom servlet from " + a);
                this.setServletAndFilters(this.rootContext, (String)a);
            });
        }
        if (this.uiContext != null) {
            this.setServletAndFilters(this.uiContext, "ru.bitel.bgbilling.kernel.base.server.servlet_ui");
            customServletPackages = Utils.toList((String)setup.get("custom.ui.servlet.package"));
            if (customServletPackages != null && !customServletPackages.isEmpty()) {
                customServletPackages.forEach(a -> {
                    log.info("Add custom UI servlet from " + a);
                    this.setServletAndFilters(this.uiContext, (String)a);
                });
            }
        }
    }

    private void addResources(StandardContext context) {
        StandardRoot resourceRoot = new StandardRoot((Context)context);
        context.setResources((WebResourceRoot)resourceRoot);
        resourceRoot.setCachingAllowed(true);
        context.setDelegate(true);
    }

    private static void onServerShutdown() {
        for (OnDestroyServer p : BGPluginManagerServer.getManager().getInvokeables(OnDestroyServer.class, false)) {
            p.onDestroyServer("server");
        }
    }

    private void setServletAndFilters(StandardContext context, String packageName) {
        HashMap<String, WebFilter> filtersMap = new HashMap<String, WebFilter>();
        for (Class clazz : Utils.getClassList((String)packageName)) {
            String className = clazz.getName();
            if (clazz.isAnnotationPresent(WebServlet.class)) {
                WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
                this.addServlet(context, webServlet.name(), className, webServlet.urlPatterns());
            }
            if (!clazz.isAnnotationPresent(WebFilter.class)) continue;
            filtersMap.put(className, clazz.getAnnotation(WebFilter.class));
        }
        this.setServletFilter(context, filtersMap);
    }

    static {
        START_TIME = new Date();
    }
}

