/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionShowScheduledTask
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String id = this.getParameter("id", "-1");
        if (Utils.notBlankString((String)id)) {
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            StringBuilder query = new StringBuilder("SELECT st.id, st.mm, st.hh, st.dm, st.dw, st.min, st.date1, st.date2, st.status, st.class_id, st.class, st.module_id, st.prior, st.comment, sc.class, sc.title FROM scheduled_tasks AS st LEFT JOIN scheduled_class AS sc ON st.class_id=sc.id");
            if (!id.equals("-1")) {
                query.append(" WHERE st.module_id='" + id + "'");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String taskDescription;
                Element element = this.createElement(data, "item");
                element.setAttribute("f0", rs.getString("st.id"));
                String classId = rs.getString("st.class");
                if (Utils.isBlankString((String)classId)) {
                    classId = rs.getString("sc.class");
                }
                if (Utils.isBlankString((String)(taskDescription = TaskCache.getInstance().getTaskDescription(classId)))) {
                    taskDescription = rs.getString("sc.title");
                }
                element.setAttribute("f1", taskDescription);
                element.setAttribute("f2", rs.getString("st.comment"));
                element.setAttribute("f3", TimeUtils.formatPeriod((Date)rs.getDate("st.date1"), (Date)rs.getDate("st.date2")));
                element.setAttribute("f4", Utils.unpackValues((long)rs.getLong("st.mm"), (int)1));
                element.setAttribute("f5", Utils.unpackValues((long)rs.getLong("st.dm"), (int)1));
                element.setAttribute("f6", Utils.unpackValues((long)rs.getLong("st.dw"), (int)1));
                element.setAttribute("f7", Utils.unpackValues((long)rs.getLong("st.hh"), (int)0));
                element.setAttribute("f8", Utils.unpackValues((long)rs.getLong("st.min"), (int)0));
                String moduleName = "";
                String moduleId = rs.getString("st.module_id");
                if (!Utils.isBlankString((String)moduleId)) {
                    moduleName = moduleId.startsWith("p") ? BGPluginManagerServer.getManager().getPluginByUID(Integer.valueOf(moduleId.replace("p", ""))).getName() : (moduleId.equals("0") ? "\u042f\u0434\u0440\u043e" : ModuleCache.getInstance().optModule(Integer.valueOf(moduleId)).map(a -> a.getTitle()).orElse("??? [ID#" + moduleId + "]"));
                }
                element.setAttribute("f9", moduleName);
                element.setAttribute("f10", rs.getInt("st.status") == 1 ? "\u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442" : "\u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
                element.setAttribute("f11", rs.getInt("st.prior") == 0 ? "\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439" : (rs.getInt("st.prior") == 1 ? "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439" : "\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439"));
            }
            rs.close();
            ps.close();
            int runCount = new RunTaskDataManager(this.con).getTaskCount();
            table.setAttribute("run_count", String.valueOf(runCount));
        }
    }
}

