/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.config.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ConfigDAO
extends AbstractIdDao<ConfigData> {
    public ConfigDAO(Connection con) {
        super(con, 0, "module_config");
    }

    public List<ConfigData> list(int moduleId) throws BGException {
        return this.list(moduleId, true);
    }

    public ConfigData getActiveConfig(int moduleId) throws BGException {
        return (ConfigData)((Object)this.get("active=true AND mid=?", new Object[]{moduleId}));
    }

    public List<ConfigData> list(int moduleId, boolean loadConfig) throws BGException {
        List list = super.list("mid=?", "title", new Object[]{moduleId});
        if (!loadConfig) {
            list.forEach(a -> a.setConfig(""));
        }
        return list;
    }

    protected ConfigData getFromRS(ResultSet resultSet) throws SQLException, BGException {
        return ConfigData.builder().setId(resultSet.getInt("id")).setModuleId(resultSet.getInt("mid")).setTitle(resultSet.getString("title")).setConfig(resultSet.getString("config")).setUserId(resultSet.getInt("uid")).setActive(resultSet.getBoolean("active")).setLastEdited(resultSet.getTimestamp("dt")).build();
    }

    protected void updateImpl(ConfigData configData) throws BGException, SQLException {
        if (configData != null) {
            String query = (configData.getId() <= 0 ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET mid=?, dt=?, title=?, uid=?, config=?, active=?" + (configData.getId() > 0 ? " WHERE id=?" : "");
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                if (configData.getId() > 0) {
                    ps.setInt(7, configData.getId());
                }
                ps.setInt(1, configData.getModuleId());
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)configData.getLastEdited()));
                ps.setString(3, configData.getTitle());
                ps.setInt(4, configData.getUserId());
                ps.setString(5, configData.getConfig());
                ps.setBoolean(6, configData.isActive());
                ps.executeUpdate();
                if (configData.getId() <= 0) {
                    configData.setId(ServerUtils.lastInsertId(this.con));
                }
            }
        }
    }

    public void setActiveModuleConfig(int moduleId, int configId) throws BGException {
        String query = "UPDATE " + this.tableName + " SET active=(id=?) WHERE mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, configId);
            ps.setInt(2, moduleId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

