/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeLibraryPanel;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.GeneratorOptions;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class DynamicClassChooser
extends BGUPanel {
    public static final int MODE_FIELD = 0;
    public static final int MODE_LIST = 1;
    public static final int MODE_LIST_WITH_NEW_CLASS_PANEL = 2;
    private static final String CREATE_NEW_CLASS = "<< \u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043a\u043b\u0430\u0441\u0441 >>";
    private static final String ICON_ITEM_EDIT = "item_edit";
    private static final String ICON_ITEM_ADD = "item_add";
    private static final String ICON_ITEM_SELECT = "item_properties";
    public static final String EDIT_CLASS = "edit_class";
    public static final String NEW_CLASS = "new_class";
    public static final String SELECT_CLASS = "select_class";
    private static final String EMPTY_ELEMENT = " --- ";
    private int mode = 0;
    private boolean dummy = false;
    private boolean newClass = true;
    private boolean newClassWithAdditionalIfaces = false;
    private String newClassName = null;
    private String ifaceName;
    private List<String> additionalIfaces = new ArrayList<String>();
    private String extendsClassName;
    private Set<String> defaultImports;
    private Set<String> derivingIfaces;
    private BGUList<DynamicClass> classNamesList = new BGUList();
    private ClassNameField classNameField = new ClassNameField();
    private SelectDynamicClass selectDynamicClass = null;
    private List<DynamicClass> classes = new ArrayList<DynamicClass>();
    private String newClassPrefix;

    public DynamicClassChooser(boolean dummy) {
        this(dummy, 0);
    }

    public DynamicClassChooser(boolean dummy, int mode) {
        super(new ClientContext("kernel", 0, 0, ""));
        this.mode = mode;
        this.dummy = dummy;
        if (mode == 1 || mode == 2) {
            this.classNamesList.setSelectionMode(0);
            this.classNamesList.setToolTipText("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0434\u0432\u043e\u0439\u043d\u043e\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f/\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043b\u0430\u0441\u0441\u0430");
        }
        this.build();
    }

    public void setSelectHandler(SelectDynamicClass selectDynamicClass) {
        this.selectDynamicClass = selectDynamicClass;
    }

    public void onSelectDynamicClass(DynamicClass selectedItem) {
        if (this.selectDynamicClass != null) {
            try {
                this.selectDynamicClass.on(selectedItem, this.ifaceName);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        if (this.mode == 1) {
            this.buildListMode(this.mode);
        } else if (this.mode == 2) {
            this.buildListMode(this.mode);
            this.buildEditClassPanel();
        } else if (this.mode == 0) {
            this.buildEditClassPanel();
        }
    }

    private void buildListMode(int buildMode) {
        this.classNamesList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DynamicClass dynamicClass;
                if (mouseEvent.getClickCount() == 2 && (dynamicClass = (DynamicClass)DynamicClassChooser.this.classNamesList.getSelectedValue()) != null) {
                    if (DynamicClassChooser.CREATE_NEW_CLASS.equals(dynamicClass.getClassName())) {
                        JLabel message = new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u043a\u043b\u0430\u0441\u0441\u0430");
                        message.setPreferredSize(new Dimension(500, 20));
                        DynamicClassChooser.this.newClassName = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), message, "\u0417\u0430\u043f\u0440\u043e\u0441", 3);
                        if (Utils.notBlankString((String)DynamicClassChooser.this.newClassName)) {
                            DynamicClassChooser.this.performAction(DynamicClassChooser.NEW_CLASS);
                        }
                    } else {
                        DynamicClassChooser.this.performAction(DynamicClassChooser.EDIT_CLASS);
                    }
                }
            }
        });
        this.add(new JScrollPane((Component)this.classNamesList), new GridBagConstraints(0, 1, buildMode == 1 ? 1 : 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
    }

    private void buildEditClassPanel() {
        ActionListener actionListener = event -> {
            if (ICON_ITEM_ADD.equals(event.getActionCommand())) {
                new NewClassNameDialog("\u041d\u043e\u0432\u044b\u0439 \u043a\u043b\u0430\u0441\u0441", Utils.maskBlank((String)this.newClassPrefix, (String)"")).open();
            } else if (ICON_ITEM_EDIT.equals(event.getActionCommand())) {
                this.performAction(EDIT_CLASS);
            } else if (ICON_ITEM_SELECT.equals(event.getActionCommand())) {
                this.performAction(SELECT_CLASS);
            }
        };
        CCButton selectButton = new CCButton(ICON_ITEM_SELECT, "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441", actionListener);
        selectButton.setBorderPainted(false);
        CCButton newButton = new CCButton(ICON_ITEM_ADD, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043a\u043b\u0430\u0441\u0441", actionListener);
        newButton.setBorderPainted(false);
        CCButton editButton = new CCButton(ICON_ITEM_EDIT, "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043a\u043b\u0430\u0441\u0441", actionListener);
        editButton.setBorderPainted(false);
        if (this.mode == 0) {
            this.add(this.classNameField, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
            this.add(selectButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
            this.add(newButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(editButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add(newButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
            this.add(editButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.refresh((ClientContext)this.getContext()));
        new AbstractBGUPanel.DefaultAction(NEW_CLASS, ""){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (!Utils.notBlankString((String)DynamicClassChooser.this.newClassName)) {
                    throw new BGMessageException("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u0430!");
                }
                if (((DynamicCodeService)((ClientContext)DynamicClassChooser.this.getContext()).getPort(DynamicCodeService.class)).isClassExists(DynamicClassChooser.this.newClassName)) {
                    throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u043a\u043b\u0430\u0441\u0441 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                }
                GeneratorOptions options = new GeneratorOptions();
                options.setFullClassName(DynamicClassChooser.this.newClassName);
                options.setDefaultImports(DynamicClassChooser.this.defaultImports);
                options.setDerivingInterfaceNames(DynamicClassChooser.this.derivingIfaces);
                options.setSuperclassName(DynamicClassChooser.this.extendsClassName);
                if (Utils.notEmptyCollection(DynamicClassChooser.this.additionalIfaces) && DynamicClassChooser.this.newClassWithAdditionalIfaces) {
                    HashSet<String> ifaces = new HashSet<String>();
                    ifaces.add(DynamicClassChooser.this.ifaceName);
                    ifaces.addAll(DynamicClassChooser.this.additionalIfaces);
                    options.setInterfaceNames(ifaces);
                } else {
                    options.setInterfaceNames(Collections.singleton(DynamicClassChooser.this.ifaceName));
                }
                DynamicCodeLibraryPanel panel = DynamicClassChooser.getCodePanel();
                panel.performAction(options, "new", "new");
                panel.performAction(null, "compile", "compile");
                DynamicClass item = new DynamicClass(DynamicClassChooser.this.newClassName, 0L);
                if (DynamicClassChooser.this.mode == 1 || DynamicClassChooser.this.mode == 2) {
                    DynamicClassChooser.this.classNamesList.getModel().addElement(item);
                    DynamicClassChooser.this.classNamesList.setSelectedValue((Object)item, true);
                } else {
                    DynamicClassChooser.this.classNameField.setDynamicClass(item);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(EDIT_CLASS, ""){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (Utils.isBlankString((String)DynamicClassChooser.this.getSelectedClass())) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043a\u043b\u0430\u0441\u0441!");
                    return;
                }
                GeneratorOptions options = new GeneratorOptions();
                options.setFullClassName(DynamicClassChooser.this.getSelectedClass());
                DynamicClassChooser.getCodePanel().performAction(options, "edit", "edit");
            }
        };
        new AbstractBGUPanel.DefaultAction(SELECT_CLASS, ""){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                new SelectClassNameDialog("\u0412\u044b\u0431\u043e\u0440 \u043a\u043b\u0430\u0441\u0441\u0430", DynamicClassChooser.this.classNameField.getDynamicClass()).open();
            }
        };
    }

    public void setNewClass(boolean newClass) {
        this.newClass = newClass;
    }

    public void setNewNameClass(String newClassName) {
        this.newClassName = newClassName;
    }

    public void setNewClassPrefix(String prefix) {
        this.newClassPrefix = prefix;
    }

    public void setToolTipText(String text) {
        if (this.mode == 1 || this.mode == 2) {
            this.classNamesList.setToolTipText(text);
        } else {
            super.setToolTipText(text);
        }
    }

    public void setIfaceName(String ifaceName) {
        this.ifaceName = ifaceName;
    }

    public void addIfaceName(String additionalIfaceName) {
        if (Utils.notBlankString((String)additionalIfaceName)) {
            this.additionalIfaces.add(additionalIfaceName);
        }
    }

    public List<String> getAdditionalIfaces() {
        return this.additionalIfaces;
    }

    public void setNewClassWithAdditionalIfaces(boolean newClassWithAdditionalIfaces) {
        this.newClassWithAdditionalIfaces = newClassWithAdditionalIfaces;
    }

    public void setSuperclassName(String className) {
        this.extendsClassName = className;
    }

    public void setDefaultImports(Set<String> defaultImports) {
        this.defaultImports = defaultImports;
    }

    public void setDerivingIfaces(Set<String> derivingIfaces) {
        this.derivingIfaces = derivingIfaces;
    }

    private static DynamicCodeLibraryPanel getCodePanel() {
        return (DynamicCodeLibraryPanel)BGClientBase.getFrame().getTabbedPane().addTab("dynamic_library_panel", DynamicCodeLibraryPanel.class);
    }

    public String getSelectedClass() {
        DynamicClass selected = this.mode == 1 || this.mode == 2 ? (DynamicClass)this.classNamesList.getSelectedValue() : this.classNameField.getDynamicClass();
        if (selected == null || selected.getClassName().equals(EMPTY_ELEMENT) || selected.getClassName().equals(CREATE_NEW_CLASS)) {
            return null;
        }
        return selected.getClassName();
    }

    public void setSelectedIndex(int index) {
        if (this.mode == 1 || this.mode == 2) {
            this.classNamesList.setSelectedIndex(index);
        } else {
            this.classNameField.setDynamicClass(this.classes.get(index));
        }
    }

    public void setSelectedItem(String className) {
        DynamicClass item = new DynamicClass(className, 0L);
        if (this.mode == 1 || this.mode == 2) {
            this.classNamesList.setSelectedValue((Object)item, true);
        } else {
            this.classNameField.setDynamicClass(item);
        }
    }

    public void clearSelection() {
        if (this.mode == 1 || this.mode == 2) {
            this.classNamesList.clearSelection();
        } else {
            this.classNameField.setDynamicClass(null);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        ((JComponent)(this.mode == 1 || this.mode == 2 ? this.classNamesList : this.classNameField)).setEnabled(enabled);
    }

    public BGUList<DynamicClass> getClassNamesList() {
        return this.classNamesList;
    }

    public String getNewClassName() {
        return this.newClassName;
    }

    public void refresh(ClientContext context) {
        ArrayList<DynamicClass> classes = new ArrayList<DynamicClass>();
        try {
            classes.addAll(((DynamicCodeService)context.getPort(DynamicCodeService.class, 0)).getDynamicClassesByInterface(this.ifaceName));
            if (Utils.notEmptyCollection(this.additionalIfaces)) {
                for (String iface : this.additionalIfaces) {
                    classes.addAll(((DynamicCodeService)context.getPort(DynamicCodeService.class, 0)).getDynamicClassesByInterface(iface));
                }
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        if (this.dummy) {
            classes.add(0, new DynamicClass(EMPTY_ELEMENT, 0L));
        }
        this.classes = classes;
        if (this.mode == 1 || this.mode == 2) {
            if (this.newClass) {
                classes.add(0, new DynamicClass(CREATE_NEW_CLASS, 0L));
            }
            this.classNamesList.setData(classes);
        }
    }

    public List<DynamicClass> getClasses() {
        return this.classes;
    }

    public ClassNameField getClassNameField() {
        return this.classNameField;
    }

    public class ClassNameField
    extends JTextField {
        private Color bgColor;
        private DynamicClass dynamicClass;

        public ClassNameField() {
            super(30);
            this.dynamicClass = null;
            this.bgColor = this.getBackground();
            this.setEditable(false);
            this.setBackground(this.bgColor);
            this.setMinimumSize(new Dimension(300, 24));
            this.setPreferredSize(new Dimension(300, 24));
        }

        public DynamicClass getDynamicClass() {
            return this.dynamicClass;
        }

        public void setDynamicClass(DynamicClass dynamicClass) {
            this.dynamicClass = dynamicClass;
            this.setText(dynamicClass != null ? dynamicClass.getGuiTitle() : "");
            DynamicClassChooser.this.onSelectDynamicClass(dynamicClass);
            this.fireActionPerformed();
            this.setBackground(this.bgColor);
            if (dynamicClass != null) {
                DynamicClassChooser.this.classes.stream().filter(a -> a.getClassName().equals(dynamicClass.getClassName())).findFirst().ifPresentOrElse(a -> {}, () -> this.setBackground(Color.YELLOW));
            }
        }
    }

    public static interface SelectDynamicClass {
        public void on(DynamicClass var1, String var2);
    }

    static class CCButton
    extends JButton {
        public CCButton(String icon, String toolTipText, ActionListener actionListener) {
            super(ClientUtils.getIcon((String)icon));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setToolTipText(toolTipText);
            this.setActionCommand(icon);
            this.addActionListener(actionListener);
        }
    }

    class NewClassNameDialog
    extends BGEditorDialog<String> {
        private JTextField newClassNameField;

        public NewClassNameDialog(String title, String data) {
            super(title, (Object)data);
            this.newClassNameField = new JTextField(50);
            DynamicClassChooser.this.newClassName = null;
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0418\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.newClassNameField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.newClassNameField.setText((String)this.data);
        }

        public boolean doApply() throws Exception {
            if (this.newClassNameField.getText().length() == 0) {
                DynamicClassChooser.this.newClassName = null;
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u0430!");
                return false;
            }
            DynamicClassChooser.this.newClassName = this.newClassNameField.getText();
            DynamicClassChooser.this.performAction(DynamicClassChooser.NEW_CLASS);
            return true;
        }
    }

    class SelectClassNameDialog
    extends BGEditorDialog<DynamicClass> {
        private BGUList<DynamicClass> list;

        public SelectClassNameDialog(String title, DynamicClass data) {
            super(title, (Object)data);
            this.list = new BGUList();
        }

        public void doDialogPanel() {
            this.addFieldV("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043b\u0430\u0441\u0441\u044b:", BGSwingUtilites.wrapScrollPane(this.list, (int)800, (int)300));
            this.list.setSelectionMode(0);
            this.list.setData(DynamicClassChooser.this.classes);
            this.list.setSelectedValue(this.data, true);
        }

        public boolean doApply() throws Exception {
            DynamicClass dynamicClass = (DynamicClass)this.list.getSelectedValue();
            if (dynamicClass == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043b\u0430\u0441\u0441");
                return false;
            }
            DynamicClassChooser.this.classNameField.setDynamicClass(dynamicClass);
            return true;
        }
    }
}

