/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.processors;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ConvergenceBalanceEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.LimitChangedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

class BalanceEventProcessor
implements EventListener<Event> {
    private Logger logger = LogManager.getLogger();
    private final DefaultServerSetup setup;
    private final StatusCache statusCache = StatusCache.getInstance();
    private final ModuleCache moduleCache = ModuleCache.getInstance();

    public BalanceEventProcessor(Setup setup) throws BGException {
        this.setup = setup;
        ContractRuntimeMap.getInstance();
        ConvergenceBalanceManager.setGenerateConvergenceBalanceEvents(true);
        ConvergenceBalanceManager.getInstance();
        EventProcessor eventProcessor = EventProcessor.getInstance();
        eventProcessor.addListener(this, ContractStatusChangedEvent.class);
        eventProcessor.addListener(this, ConvergenceBalanceEvent.class);
        eventProcessor.addListener(this, PaymentEvent.class);
        eventProcessor.addListener(this, PaymentDeletedEvent.class);
        eventProcessor.addListener(this, ChargeEvent.class);
        eventProcessor.addListener(this, LimitChangedEvent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, EventListenerContext ctx) throws BGException {
        int contractId = event.getContractId();
        this.logger.info("Process event contractId:" + contractId + "; event:" + event.toString());
        try {
            ConnectionSet connectionSet = ctx.getConnectionSet();
            ContractRuntimeMap contractRuntimeMap = ContractRuntimeMap.getInstance();
            ContractRuntime contractRuntime = contractRuntimeMap.getContractRuntime(connectionSet, (Integer)contractId);
            contractRuntime.lock();
            try {
                Set<Integer> moduleSet = contractRuntime.getModuleIds();
                List<BGModule> moduleEventList = this.moduleCache.getModulesListProcessSorted(moduleSet);
                if (event instanceof ContractStatusChangedEvent) {
                    this.processStatus((ContractStatusChangedEvent)event, ctx, connectionSet, moduleEventList, contractId, contractRuntime);
                } else {
                    this.processBalance(event, ctx, connectionSet, moduleEventList, contractId, contractRuntime);
                    int[] dependSubContractsIds = contractRuntime.getDependSubContractIds();
                    if (dependSubContractsIds != null) {
                        for (int subContractId : dependSubContractsIds) {
                            this.logger.info("Processing balance event for depend sub contract " + subContractId);
                            ContractRuntime subContractRuntime = contractRuntimeMap.getContractRuntime(connectionSet, (Integer)subContractId);
                            moduleSet = subContractRuntime.getModuleIds();
                            moduleEventList = this.moduleCache.getModulesListProcessSorted(moduleSet);
                            this.processBalance(event, ctx, connectionSet, moduleEventList, subContractId, subContractRuntime);
                        }
                    }
                }
                ctx.commit();
            }
            finally {
                contractRuntime.unlock();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void processStatus(ContractStatusChangedEvent event, EventListenerContext ctx, ConnectionSet connectionSet, List<BGModule> moduleEventList, int contractId, ContractRuntime contractRuntime) throws BGException {
        ConvergenceBalance balance = ConvergenceBalanceManager.getInstance().getBalance(connectionSet, contractId, System.currentTimeMillis());
        boolean balanceOk = balance.isBalanceExceedsLimit();
        ContractStatus status = event.getStatus();
        int statusCode = status.getStatus();
        contractRuntime.setStatus(statusCode);
        for (BGModule module : moduleEventList) {
            if (this.statusCache.isModuleActiveStatus(module.getId(), statusCode)) {
                if (!balanceOk) continue;
                ApplicationModule applicationModule = this.moduleCache.getApplicationModule(module.getName());
                if (applicationModule != null) {
                    this.moduleCache.getApplicationModule(module.getName()).unlockService(connectionSet.getConnection(), module.getId(), contractRuntime, balance.getBalance(), balance.getLimit(), false);
                    continue;
                }
                this.logger.error("moduleCache.getApplicationModule( \"{}\" ) = null", (Object)module.getName());
                continue;
            }
            this.moduleCache.getApplicationModule(module.getName()).lockService(connectionSet.getConnection(), module.getId(), contractRuntime, balance.getBalance(), balance.getLimit(), false);
        }
    }

    private void processBalance(Event event, EventListenerContext ctx, ConnectionSet connectionSet, List<BGModule> moduleEventList, int contractId, ContractRuntime contractRuntime) throws Exception {
        if (event instanceof ConvergenceBalanceEvent) {
            ConvergenceBalance convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(connectionSet, contractId, System.currentTimeMillis());
            BigDecimal saldo = convergenceBalance.getSaldo();
            boolean balanceOk = convergenceBalance.isBalanceExceedsLimit();
            this.processBalance(connectionSet, contractRuntime, contractRuntime.getStatus(), balanceOk, convergenceBalance.getBalance(), saldo, convergenceBalance.getLimit(), moduleEventList, true);
        } else {
            try (ContractManager contractManager = new ContractManager(connectionSet.getConnection());
                 BalanceDao balanceDao = new BalanceDao(ctx.getConnection());){
                Contract contract = contractManager.getContractById(contractId);
                GregorianCalendar calendar = new GregorianCalendar();
                int yy = calendar.get(1);
                int mm = calendar.get(2) + 1;
                ContractBalance balance = contract.isDependSub() ? balanceDao.getContractBalance(contract.getSuperId(), yy, mm) : balanceDao.getContractBalance(contractId, yy, mm);
                BigDecimal balanceValue = balance.toBalance();
                boolean balanceOk = balanceValue.compareTo(contract.getBalanceLimit()) >= 0;
                BigDecimal saldoValue = balance.getYear() != yy || balance.getMonth() != mm ? balanceValue : balance.toSaldo();
                this.processBalance(connectionSet, contractRuntime, contract.getStatus(), balanceOk, balanceValue, saldoValue, contract.getBalanceLimit(), moduleEventList, false);
            }
        }
    }

    private void processBalance(ConnectionSet connectionSet, ContractRuntime contractRuntime, int currentStatus, boolean balanceOk, BigDecimal balance, BigDecimal saldo, BigDecimal limit, List<BGModule> moduleEventList, boolean lightweight) throws SQLException, BGException {
        if (balanceOk) {
            if (contractRuntime.getBalanceMode() == 0) {
                this.logger.debug("Try to activate credit contract by balance.");
                if (!this.activateCreditContract(connectionSet, contractRuntime, currentStatus, saldo)) {
                    this.logger.debug("Unlocking credit contract with now unlock.");
                    this.lockUnlock(ActionType.UnlockNow, moduleEventList, connectionSet.getConnection(), contractRuntime, balance, limit, lightweight);
                }
            } else {
                this.logger.debug("Activating debet contract by balance.");
                this.lockUnlock(ActionType.Unlock, moduleEventList, connectionSet.getConnection(), contractRuntime, balance, limit, lightweight);
            }
        } else {
            this.logger.debug("Locking service in modules with now lock");
            this.lockUnlock(ActionType.LockNow, moduleEventList, connectionSet.getConnection(), contractRuntime, balance, limit, lightweight);
        }
    }

    private void lockUnlock(ActionType mode, List<BGModule> moduleList, Connection con, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        for (BGModule module : moduleList) {
            ApplicationModule applicationModule = this.moduleCache.getApplicationModule(module.getName());
            if (applicationModule == null) {
                this.logger.error("Can't find application module: " + module.getName());
                continue;
            }
            if (mode == ActionType.Unlock && this.statusCache.isModuleActiveStatus(module.getId(), contractRuntime.getStatus())) {
                applicationModule.unlockService(con, module.getId(), contractRuntime, balance, limit, lightweight);
                continue;
            }
            if (mode == ActionType.UnlockNow && this.statusCache.isModuleActiveStatus(module.getId(), contractRuntime.getStatus())) {
                applicationModule.unlockServiceNow(con, module.getId(), contractRuntime, balance, limit, lightweight);
                continue;
            }
            if (mode != ActionType.LockNow) continue;
            applicationModule.lockServiceNow(con, module.getId(), contractRuntime, balance, limit, lightweight);
        }
    }

    private boolean activateCreditContract(ConnectionSet connectionSet, ContractRuntime contractRuntime, int currentStatus, BigDecimal saldo) throws SQLException, BGException {
        boolean wasActivate = false;
        if (!this.setup.get("do.not.open.contract.on.payment", "0").equals("0")) {
            return wasActivate;
        }
        String doNotOpenGroupsOnPayment = this.setup.get("do.not.open.groups.on.payment", null);
        if (doNotOpenGroupsOnPayment != null) {
            long groups = Utils.enumToMask((String)doNotOpenGroupsOnPayment);
            if ((contractRuntime.getContractGroups() & groups) != 0L) {
                return wasActivate;
            }
        }
        int creditActiveStatus = this.setup.getInt("credit.contract.active.status", 0);
        Set creditMayByOpenStatus = Utils.toIntegerSet((String)this.setup.get("credit.contract.open.by.payment.status", "2,3"));
        Set overrideToActiveFutureStatus = Utils.toIntegerSet((String)this.setup.get("credit.contract.override.future.to.active.status", "2"));
        GregorianCalendar date = new GregorianCalendar();
        if (saldo.compareTo(BigDecimal.ZERO) > -1) {
            try (ContractStatusDao contractStatusDao = new ContractStatusDao(connectionSet.getConnection());){
                if (creditMayByOpenStatus.contains(currentStatus)) {
                    contractStatusDao.changeStatus(ContractStatus.builder().setDateFrom(date.getTime()).setStatus(creditActiveStatus).setContractId(contractRuntime.contractId).build(), 0);
                    wasActivate = true;
                } else if (currentStatus == creditActiveStatus) {
                    List<ContractStatus> statusList = contractStatusDao.getStatusListAfterDate(contractRuntime.contractId, date);
                    for (ContractStatus status : statusList) {
                        if (!overrideToActiveFutureStatus.contains(status.getStatus())) continue;
                        status.setStatus(creditActiveStatus);
                        status.setComment("\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c");
                        contractStatusDao.changeStatus(status, 0);
                    }
                }
            }
        }
        return wasActivate;
    }

    private static enum ActionType {
        Unlock,
        UnlockNow,
        LockNow;

    }
}

