/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask;

import bitel.billing.server.admin.licview.Temp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.DefaultAlarmTask;
import ru.bitel.common.Utils;

public class LicCheckTask
extends DefaultAlarmTask {
    private long lastLCheck = 0L;
    private static final long L_CHECK_INTERVAL = 86400000L;

    @Override
    public void doTask() {
        if (!this.setup.get(Utils.swapWords("endel.cia.almr"), "0").equals("1")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastLCheck < 86400000L) {
            return;
        }
        StringBuilder messageBuilder = null;
        StringBuilder contrExpire = null;
        StringBuilder dateExpire = null;
        int contractRemaining = this.setup.getInt(Utils.swapWords("il.clara.moctnartcl.miti"), 10);
        int daysDelta = this.setup.getInt(Utils.swapWords("il.clara.madsyl.miti"), 5);
        String modules = this.setup.get(Utils.swapWords("il.clara.momudels"), "");
        HashSet<String> moduleNames = new HashSet<String>();
        if (!Utils.isEmptyString(modules)) {
            String[] parts;
            for (String module : parts = modules.split(",")) {
                moduleNames.add(module);
            }
        }
        LocalDate nowDate = LocalDate.now();
        Temp temp = Temp.getTemp();
        for (String name : temp.getMName()) {
            LocalDate exp;
            int delta;
            int cur = temp.getMCurrContract(name);
            int max = temp.getMMaxContract(name);
            if (moduleNames.size() > 0 && !moduleNames.contains(name)) continue;
            if (max != 0 && (delta = max - cur) <= contractRemaining) {
                if (contrExpire == null) {
                    contrExpire = new StringBuilder(50);
                }
                contrExpire.append("\t * \u041c\u043e\u0434\u0443\u043b\u044c: ");
                contrExpire.append(name);
                contrExpire.append(". \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: ");
                contrExpire.append(cur);
                contrExpire.append(" / ");
                contrExpire.append(max);
                contrExpire.append("\n");
            }
            if ((exp = temp.getMDateAvail(name)).toEpochDay() - nowDate.toEpochDay() > (long)daysDelta) continue;
            if (dateExpire == null) {
                dateExpire = new StringBuilder(50);
            }
            dateExpire.append("\t * \u041c\u043e\u0434\u0443\u043b\u044c: ");
            dateExpire.append(name);
            dateExpire.append(". \u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0438\u0441\u0442\u0435\u043a\u0430\u0435\u0442: ");
            dateExpire.append(exp.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
            dateExpire.append("\n");
        }
        if (contrExpire != null) {
            if (messageBuilder == null) {
                messageBuilder = new StringBuilder(100);
            }
            messageBuilder.append("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0414\u043b\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0438\u0441\u0447\u0435\u0440\u043f\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043b\u0438\u043c\u0438\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432! ");
            messageBuilder.append("\u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0440\u0430\u0441\u0448\u0438\u0440\u0438\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0434\u043b\u044f \u044d\u0442\u0438\u0445 \u043c\u043e\u0434\u0443\u043b\u0435\u0439. ");
            messageBuilder.append("\u0415\u0441\u043b\u0438 \u0412\u044b \u043d\u0435 \u0445\u043e\u0442\u0438\u0442\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u044d\u0442\u0438 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f, \u0442\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 ");
            messageBuilder.append("\u0444\u043b\u0430\u0433 ");
            messageBuilder.append(Utils.swapWords("endel.cia.almr"));
            messageBuilder.append("=0 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u0421\u043f\u0438\u0441\u043e\u043a \u043c\u043e\u0434\u0443\u043b\u0435\u0439:\n");
            messageBuilder.append(contrExpire.toString());
        }
        if (dateExpire != null) {
            if (messageBuilder == null) {
                messageBuilder = new StringBuilder(100);
            }
            messageBuilder.append("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0414\u043b\u044f \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u043e\u0434\u0443\u043b\u0435\u0439 \u0438\u0441\u0442\u0435\u043a\u0430\u0435\u0442 \u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438! ");
            messageBuilder.append("\u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0434\u043b\u0438\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438 \u0434\u043b\u044f \u044d\u0442\u0438\u0445 \u043c\u043e\u0434\u0443\u043b\u0435\u0439. ");
            messageBuilder.append("\u0415\u0441\u043b\u0438 \u0412\u044b \u043d\u0435 \u0445\u043e\u0442\u0438\u0442\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u044d\u0442\u0438 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f, \u0442\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 ");
            messageBuilder.append("\u0444\u043b\u0430\u0433 ");
            messageBuilder.append(Utils.swapWords("endel.cia.almr"));
            messageBuilder.append("=0 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.\n\u0421\u043f\u0438\u0441\u043e\u043a \u043c\u043e\u0434\u0443\u043b\u0435\u0439:\n");
            messageBuilder.append(dateExpire.toString());
        }
        if (messageBuilder != null) {
            String key = Utils.swapWords("il.cxeiper");
            AlarmSender.sendAlarm(key, 86400000L, "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0440\u043e\u0434\u043b\u0438\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e", messageBuilder.toString());
        }
    }
}

