/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.client.ContractAutopaymentMethods;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ContractAutopaymantLogPanel
extends BGUPanel {
    private ContractAutopaymentMethods contractAutopaymentMethods = null;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private ModeLogTableModel modeLogTableModel = new ModeLogTableModel();
    private BGUTable modeLogTable = new BGUTable(this.modeLogTableModel);

    public ContractAutopaymantLogPanel(ContractAutopaymentMethods contractAutopaymentMenhods) {
        this.contractAutopaymentMethods = contractAutopaymentMenhods;
    }

    @Override
    protected void jbInit() throws Exception {
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContractAutopaymantLogPanel.this.performAction("refresh");
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0440\u0435\u0436\u0438\u043c\u0430"));
        this.add((Component)this.pagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.modeLogTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            try {
                SearchResult<Autopayment> searchResult = this.contractAutopaymentMethods.searchAutopaymentList(((ClientContext)this.getContext()).getContractId(), this.pagePanel.getPage());
                if (searchResult != null) {
                    this.pagePanel.setPage(searchResult.getPage());
                    this.modeLogTableModel.setData(searchResult.getList());
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
    }

    class ModeLogTableModel
    extends BGTableModel<Autopayment> {
        private int weekDay;
        private int monthDay;

        public ModeLogTableModel() {
            super(ModeLogTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 300, 300, 300, "period", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0436\u0438\u043c", 200, 200, -1, "mode", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0435\u043d\u044c", 100, 100, 100, "modeDay", false, HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", 100, 100, 100, "sum", true, DecimalTableCellRenderer.DEFAULT());
            this.addColumn("BindingId", 200, 200, -1, "accessToken", true, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(Autopayment value, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("modeDay".equals(identifier)) {
                if (value.getMode().getCode() == AutopaymentMode.WEEK.getCode()) {
                    int day = Utils.parseInt(this.getParameter(value.getModeData(), "autopayment.mode.week.day"), this.weekDay);
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(7, day);
                    return TimeUtils.format((Calendar)calendar, "EEEE");
                }
                if (value.getMode().getCode() == AutopaymentMode.MONTH.getCode()) {
                    return Utils.parseInt(this.getParameter(value.getModeData(), "autopayment.mode.month.day"), this.monthDay);
                }
                return "";
            }
            return super.getValue(value, column);
        }

        protected String getParameter(String parameters, String key) {
            String value = "";
            if (parameters != null) {
                for (String pair : parameters.split("\n")) {
                    if (!pair.startsWith(key)) continue;
                    value = pair.substring(key.length() + 1).trim();
                    break;
                }
            }
            return value;
        }

        public void setWeekDay(int weekDay) {
            this.weekDay = weekDay;
        }

        public void setMonthDay(int monthDay) {
            this.monthDay = monthDay;
        }
    }
}

