/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.plugins.notification.common.bean.ContractNotification;
import ru.bitel.bgbilling.plugins.notification.server.bean.ContractNotificationDao;

public class ActionNotification
extends AbstractAction {
    public ActionNotification() {
        super("contract");
    }

    @Override
    public void execute() throws BGException {
        this.setResultParam("pageTitle", this.getPageTitle(2, this.moduleName));
        this.setResultParam("jspPage", "contract/notification.jsp");
    }

    public void list() throws BGException {
        try (ContractNotificationDao contractNotificationDao = new ContractNotificationDao(this.con);){
            this.setResultParam("notificationList", contractNotificationDao.list(this.contractId));
        }
        this.requestDispatcher(this.moduleName, "notification_list");
    }

    public void notification() throws BGException {
        int id = this.req.getInt("id", -1);
        try (ContractNotificationDao contractNotificationDao = new ContractNotificationDao(this.con);){
            if (id != -1) {
                ContractNotification contractNotification = (ContractNotification)contractNotificationDao.get(id);
                this.setResultParam("contractNotification", id);
                if (contractNotification != null && contractNotification.getContractId() == this.contractId) {
                    this.setResultParam("contractNotification", contractNotification);
                    if (!contractNotification.isRead()) {
                        contractNotification.setRead(true);
                        contractNotificationDao.update((Object)contractNotification);
                    }
                }
            }
        }
        this.requestDispatcher(this.moduleName, "notification_item");
    }

    public void delete() throws BGException {
        try (ContractNotificationDao contractNotificationDao = new ContractNotificationDao(this.con);){
            int id = this.req.getInt("id", -1);
            ContractNotification contractNotification = (ContractNotification)contractNotificationDao.get(id);
            if (contractNotification != null && contractNotification.getContractId() == this.contractId) {
                contractNotificationDao.delete(id);
            }
        }
        this.list();
    }
}

