/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.task.client.TaskEditor;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.bgbilling.kernel.task.common.service.SchedulerService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class SchedulerTaskPanel
extends BGUPanel {
    private static final String RUN_NOW_ACTION = "task.runnow";
    private static final String DISABLE_ENABLE_TASK_ACTION = "task.disableEnable";
    private static final long serialVersionUID = 1L;
    private BGComboBox<ComboBoxItem> filterModuleComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> filterStatusComboBox = new BGComboBox();
    private TaskTableModel taskTableModel;
    private BGUTable taskTable;
    private List<LightweightTaskData> lightweightTaskDatas;
    private JLabel statusLabel = new JLabel();
    private SchedulerService schedulerService;
    protected List<KeyValue> modules;
    protected List<IdTitle> priorityItems = Arrays.asList(new IdTitle(1, "\u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439"), new IdTitle(5, "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u044b\u0439"), new IdTitle(10, "\u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439"));
    protected List<IdTitle> statusItems = Arrays.asList(new IdTitle(-1, "------"), new IdTitle(0, "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430"), new IdTitle(1, "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430"));

    public SchedulerTaskPanel(ClientContext ctx) {
        super(ctx);
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getTablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SchedulerTaskPanel.this.performAction("refresh");
            }
        });
        this.setData();
        this.performAction("refresh");
    }

    private JPanel getTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getStatusPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.filterModuleComboBox.addActionListener(e -> this.doFilter());
        ComboBoxItem[] items = new ComboBoxItem[this.statusItems.size()];
        for (int i = 0; i < this.statusItems.size(); ++i) {
            IdTitle idTitle = this.statusItems.get(i);
            items[i] = new ComboBoxItem(idTitle.getId(), idTitle.getTitle());
        }
        this.filterStatusComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
        this.filterStatusComboBox.setSelectedIndex(2);
        this.filterStatusComboBox.addActionListener(e -> this.doFilter());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 3, 0), 0, 0));
        panel.add(this.filterModuleComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 5), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 3, 0), 0, 0));
        panel.add(this.filterStatusComboBox, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 5), 0, 0));
        return panel;
    }

    private JPanel getStatusPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430"));
        panel.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 10), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        this.taskTableModel = new TaskTableModel();
        this.taskTable = new BGUTable(this.taskTableModel);
        this.taskTable.setAutoRowHeight(true);
        this.taskTable.setSelectionMode(2);
        this.taskTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    SchedulerTaskPanel.this.performAction("edit");
                }
                if (e.getButton() == 3 && SchedulerTaskPanel.this.taskTableModel.isInSelectedRowIndex(SchedulerTaskPanel.this.taskTable.rowAtPoint(e.getPoint()))) {
                    SchedulerTaskPanel.this.showPopup(e.getX(), e.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.taskTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private void showPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        if (this.taskTable.getSelectedRowCount() == 1) {
            JMenuItem runNowItem = new JMenuItem("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441");
            runNowItem.addActionListener(e -> this.performAction(RUN_NOW_ACTION));
            popup.add(runNowItem);
        }
        JMenuItem enableDisableItem = new JMenuItem("\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443");
        enableDisableItem.addActionListener(e -> this.performAction(DISABLE_ENABLE_TASK_ACTION));
        popup.add(enableDisableItem);
        popup.show(this.taskTable, x, y);
    }

    private void setData() throws BGException {
        this.modules = this.getSchedulerService().getModuleAndPluginList();
        ComboBoxItem[] items = new ComboBoxItem[this.modules.size()];
        for (int i = 0; i < this.modules.size(); ++i) {
            KeyValue current = this.modules.get(i);
            items[i] = "-1".equals(current.getKey()) ? new BGComboBox.Separator(current.getValue()) : new ComboBoxItem(current.getKey(), current.getValue());
        }
        this.filterModuleComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(items));
    }

    protected SchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            this.schedulerService = ((ClientContext)this.getContext()).getPort(SchedulerService.class);
        }
        return this.schedulerService;
    }

    private void doFilter() {
        String filterValue = (String)this.filterModuleComboBox.getSelectedItem().getObject();
        boolean isPlugin = filterValue.startsWith("p");
        int id = Utils.parseInt(isPlugin ? filterValue.substring(1) : filterValue);
        int filterStatusId = Utils.parseInt((String)this.filterStatusComboBox.getSelectedItem().getObject(), -1);
        ArrayList rows = new ArrayList();
        this.lightweightTaskDatas.forEach(t -> {
            boolean addModule = id == -2;
            addModule = addModule || t.getModuleId() > -2 && t.isPlugin() == isPlugin && t.getModuleId() == id;
            addModule = addModule || t.getModuleId() == -2 && t.getDependentTasks().stream().anyMatch(dt -> dt.isPlugin() == isPlugin && dt.getModuleId() == id);
            boolean addStatus = filterStatusId == -1;
            addStatus = addStatus || t.getModuleId() > -2 && t.getTaskStatus().getStatus() == filterStatusId;
            boolean bl = addStatus = addStatus || t.getModuleId() == -2 && (t.getTaskStatus().getStatus() == filterStatusId || t.getDependentTasks().stream().anyMatch(dt -> dt.getTaskStatus().getStatus() == filterStatusId));
            if (!addModule || !addStatus) {
                return;
            }
            List<DependentTask> dependentTasks = t.getDependentTasks();
            boolean isBatch = dependentTasks != null && dependentTasks.size() > 0;
            TaskTableRow row = new TaskTableRow();
            row.lightweightTaskData = t;
            row.isBatch = isBatch;
            rows.add(row);
            if (isBatch) {
                for (int i = 0; i < dependentTasks.size(); ++i) {
                    row = new TaskTableRow();
                    row.lightweightTaskData = t;
                    row.isBatch = isBatch;
                    row.dependentTask = dependentTasks.get(i);
                    rows.add(row);
                }
            }
        });
        this.taskTableModel.setData(rows);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.lightweightTaskDatas = this.getSchedulerService().getSchedulerTasks(null);
            this.doFilter();
            int runTaskCount = this.getSchedulerService().getActiveTaskCount();
            this.statusLabel.setText("\u0412 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + runTaskCount + " \"\u0442\u044f\u0436\u0435\u043b\u044b\u0445\" \u0437\u0430\u0434\u0430\u0447");
        });
        new AbstractBGUPanel.BGActionNew(e -> new TaskEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f", new LightweightTaskData(), this).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.taskTableModel.optSelectedRow().ifPresentOrElse(task -> new TaskEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0437\u0430\u0434\u0430\u043d\u0438\u044f", task.lightweightTaskData, this).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435!")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            TaskTableRow selectedTask = (TaskTableRow)this.taskTableModel.getSelectedRow();
            if (selectedTask != null) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0, 1) == 0) {
                    this.getSchedulerService().deleteTask(selectedTask.lightweightTaskData.getId());
                    this.performAction("refresh");
                }
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
            }
        });
        new AbstractBGUPanel.DefaultAction(RUN_NOW_ACTION, "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u0435\u0439\u0447\u0430\u0441"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                TaskTableRow selectedTask = (TaskTableRow)SchedulerTaskPanel.this.taskTableModel.getSelectedRow();
                DependentTask selectedDependentTask = selectedTask.dependentTask;
                LightweightTaskData selectedLightweightTaskData = selectedTask.lightweightTaskData;
                if (selectedTask.dependentTask != null) {
                    LightweightTaskData taskData = selectedLightweightTaskData.clone();
                    taskData.getDependentTasks().clear();
                    taskData.getDependentTasks().add(selectedDependentTask);
                    SchedulerTaskPanel.this.getSchedulerService().immediateRunOneTask(taskData.getDependentTasks().size() > 0 ? taskData : null);
                } else if (selectedDependentTask == null && selectedLightweightTaskData != null && Utils.notEmptyCollection(selectedLightweightTaskData.getDependentTasks())) {
                    SchedulerTaskPanel.this.getSchedulerService().immediateRun(selectedLightweightTaskData);
                } else {
                    SchedulerTaskPanel.this.getSchedulerService().immediateRun(selectedLightweightTaskData);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(DISABLE_ENABLE_TASK_ACTION, "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0412\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedTasks = SchedulerTaskPanel.this.taskTableModel.getSelectedRows();
                if (selectedTasks != null && selectedTasks.size() > 0) {
                    for (TaskTableRow task : selectedTasks) {
                        if (task.isBatch && task.dependentTask != null) {
                            task.dependentTask.setTaskStatus(task.dependentTask.getTaskStatus() == TaskStatus.ENABLE ? TaskStatus.DISABLE : TaskStatus.ENABLE);
                        } else {
                            task.lightweightTaskData.setTaskStatus(task.lightweightTaskData.getTaskStatus() == TaskStatus.ENABLE ? TaskStatus.DISABLE : TaskStatus.ENABLE);
                        }
                        SchedulerTaskPanel.this.getSchedulerService().updateTask(task.lightweightTaskData);
                    }
                    SchedulerTaskPanel.this.performAction("refresh");
                } else {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443!");
                }
            }
        };
    }

    class TaskTableModel
    extends BGTableModel<TaskTableRow> {
        public TaskTableModel() {
            super(TaskTableModel.class.getName());
        }

        public boolean isInSelectedRowIndex(int rowAtPoint) {
            int[] indices = this.table.getSelectedRows();
            for (int index = 0; index < indices.length; ++index) {
                if (indices[index] != rowAtPoint) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u2116", 40, 50, 60, "id", false).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", -1, 150, 150, "moduleName", false);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", 150, 200, -1, "title", false, new TitleTableCellRenderer());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 50, 100, -1, "comment");
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 160, 170, 180, "periodString").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 110, 110, "taskStatus", false).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442", -1, 120, 120, "priorityTitle").setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430", -1, -1, -1, "start");
        }

        @Override
        public Object getValue(TaskTableRow val, int column) throws BGException {
            String i = this.getIdentifier(column);
            boolean a = !val.isBatch || val.isBatch && val.dependentTask == null;
            switch (i) {
                case "id": {
                    return a ? Integer.valueOf(val.lightweightTaskData.getId()) : "";
                }
                case "title": {
                    return val.dependentTask == null && val.lightweightTaskData.getModuleId() == -2 ? "\u041f\u0430\u043a\u0435\u0442\u043d\u043e\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u0435 (\u0417\u0430\u0434\u0430\u0447: " + val.lightweightTaskData.getDependentTasks().size() + ")" : (val.dependentTask == null ? val.lightweightTaskData.getTitle() : val.dependentTask.getTitle());
                }
                case "periodString": {
                    return a ? TimeUtils.formatPeriod(val.lightweightTaskData.getPeriod()) : "";
                }
                case "comment": {
                    return val.dependentTask != null ? val.dependentTask.getComment() : val.lightweightTaskData.getComment();
                }
                case "moduleName": {
                    return this.getModuleName(val);
                }
                case "taskStatus": {
                    return this.getStatusTitle(val);
                }
                case "priorityTitle": {
                    return this.getPriorityTitle(val);
                }
                case "start": {
                    return a ? this.start(val.lightweightTaskData) : "";
                }
            }
            return super.getValue(val, column);
        }

        private String getModuleName(TaskTableRow val) {
            String moduleName = val.dependentTask != null ? val.dependentTask.getModuleName() : val.lightweightTaskData.getModuleName();
            return moduleName != null ? moduleName : "";
        }

        private String getStatusTitle(TaskTableRow val) {
            TaskStatus taskStatus = val.dependentTask != null ? val.dependentTask.getTaskStatus() : val.lightweightTaskData.getTaskStatus();
            return taskStatus != null ? taskStatus.getStatusTitle() : "";
        }

        private String getPriorityTitle(TaskTableRow val) {
            int priority;
            int n = priority = val.dependentTask != null ? val.dependentTask.getPriority() : val.lightweightTaskData.getPriority();
            if (priority == 0) {
                priority = val.lightweightTaskData.getPriority();
            }
            for (IdTitle idTitle : SchedulerTaskPanel.this.priorityItems) {
                if (idTitle.getId() != priority) continue;
                return idTitle.getTitle();
            }
            return SchedulerTaskPanel.this.priorityItems.get(1).getTitle();
        }

        private String start(LightweightTaskData val) {
            String result = this.getTimeString(null, "\u041c\u0435\u0441\u044f\u0446", Utils.unpackValues(val.getMonth(), 1));
            result = this.getTimeString(result, "\u0414\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430", Utils.unpackValues(val.getDay(), 1));
            result = this.getTimeString(result, "\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438", Utils.unpackValues(val.getDayOfWeek(), 1));
            result = this.getTimeString(result, "\u0427\u0430\u0441\u044b", Utils.unpackValues(val.getHour(), 0));
            return (result = this.getTimeString(result, "\u041c\u0438\u043d\u0443\u0442\u044b", Utils.unpackValues(val.getMin(), 0))) == null ? "\u041a\u0430\u0436\u0434\u0443\u044e \u043c\u0438\u043d\u0443\u0442\u0443" : result;
        }

        private String getTimeString(String str, String title, String val) {
            String result;
            String string = result = "*".equals(val) ? null : title + ": " + val;
            return result == null ? str : (str == null ? result : str + "; " + result);
        }
    }

    class TaskTableRow {
        boolean isBatch = false;
        LightweightTaskData lightweightTaskData;
        DependentTask dependentTask;

        TaskTableRow() {
        }
    }

    public class TitleTableCellRenderer
    extends DefaultTableCellRenderer {
        private Font normal = null;
        private Font packet = null;
        private Font old = this.getFont().deriveFont(0);

        public TitleTableCellRenderer() {
            this.packet = this.old.deriveFont(1).deriveFont(this.old.getSize2D() * 1.05f);
            this.normal = this.old.deriveFont(2).deriveFont(this.old.getSize2D() * 1.05f);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TaskTableModel tableModel = (TaskTableModel)table.getModel();
            TaskTableRow tableRow = (TaskTableRow)tableModel.getRows().get(table.convertRowIndexToModel(row));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int left = tableRow.isBatch && tableRow.dependentTask != null ? 20 : 3;
            this.setBorder(BorderFactory.createEmptyBorder(1, left, 1, 3));
            this.setFont(Utils.notBlankString(tableRow.lightweightTaskData.getClassName()) || tableRow.dependentTask != null && !tableRow.isBatch ? this.old : (tableRow.isBatch && tableRow.dependentTask == null ? this.packet : this.normal));
            return this;
        }
    }
}

