/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.jmx.MBeanAttribute;

public class TaskRunProcessor
extends Thread {
    private static final Logger log = LogManager.getLogger();
    private Setup setup;
    private static final String THREAD_COUNT_KEY = "scheduler.nonperiodic.thread.count";
    private ThreadPoolExecutor pool;

    public TaskRunProcessor(Setup setup) {
        this.setup = setup;
        int schedulerThreadCount = setup.getInt(THREAD_COUNT_KEY, 5);
        this.pool = new ThreadPoolExecutor(schedulerThreadCount, schedulerThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.clearExecutingHardTasks();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Connection con = this.setup.getDBConnectionFromPool();
            RunTaskDataManager rtm = new RunTaskDataManager(con);
            List<RunTask> tasks = null;
            try {
                tasks = rtm.getNextTasks();
                for (RunTask task : tasks) {
                    task.init(this.setup);
                    log.info("\u0417\u0430\u043f\u0443\u0441\u043a \u0437\u0430\u0434\u0430\u0447\u0438: #" + task.getQueueId() + " " + task.getDescription());
                    this.pool.execute(task);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
            try {
                TaskRunProcessor.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void clearExecutingHardTasks() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement ps = con.prepareStatement("DELETE FROM scheduled_task_run WHERE executed=1");
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error clear executing hard tasks", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public String getStatusString() {
        StringBuffer result = new StringBuffer(50);
        result.append("Urgent tasks executed: " + this.pool.getCompletedTaskCount() + "; ").append("active: " + this.pool.getActiveCount()).append("\n");
        return result.toString();
    }

    @MBeanAttribute
    public int getActiveTaskCount() {
        return this.pool.getActiveCount();
    }

    @MBeanAttribute
    public int getMaxActiveTaskCount() {
        return this.pool.getMaximumPoolSize();
    }
}

