/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi;

import jakarta.servlet.Servlet;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ssi.SSIServlet;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.container.ws.server.WSClient;
import ru.bitel.bgbilling.kernel.wifi.AdminPortListener;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiChecker;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.kernel.wifi.common.service.WiFiActivateService;
import ru.bitel.bgbilling.kernel.wifi.dhcp.RelayAgent;
import ru.bitel.bgbilling.kernel.wifi.server.util.RadiusUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.ScriptUtil;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.Log4j2;
import ru.bitel.common.logging.LoggingPrintStream;
import ru.bitel.common.model.MapHolder;

public abstract class WiFiAgent {
    public static final String PORTAL_LOG_NAME = "portal";
    private static Logger log;
    private Setup setup;

    public WiFiAgent() {
        Log4j2.init("data");
        BGNestedContext.push("wifi_agent");
        log = LogManager.getLogger();
        LoggingPrintStream.assignToOutput();
        this.setup = Setup.getSetup();
        GlobalConfig.initGlobalConfig(this.setup);
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        if (cfg.getModuleId() <= 0) {
            log.error("Empty billing.server.module.id in configuration file");
            WiFiAgent.out();
        }
        Application.getInstance().getCommandPortListener().setApplicationBean(this);
        this.start();
    }

    public void start() {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        this.doit(cfg);
        log.info("Starting WiFiAgent...");
        int port = cfg.getAgentPort();
        WiFiManager manager = new WiFiManager();
        manager.init(port);
        manager.start();
        WiFiChecker checker = new WiFiChecker();
        checker.init(manager);
        checker.start();
        this.startServlet(cfg, manager);
        if (cfg.isDhcp()) {
            new RelayAgent().start();
        }
        int adminPort = cfg.getAdminPort();
        log.info("Starting listen admin port " + adminPort);
        new AdminPortListener(adminPort, manager);
    }

    private void startServlet(GlobalConfig cfg, WiFiManager manager) {
        try {
            Tomcat server = new Tomcat();
            String catalinaBase = ServerUtils.getServerHome();
            server.setBaseDir(catalinaBase);
            log.info("catalinaBase: " + server.getServer().getCatalinaBase());
            server.getEngine().setParentClassLoader(Thread.currentThread().getContextClassLoader());
            URL url = WiFiAgent.class.getResource(System.getProperty("portal.path", "/portal"));
            if (url == null) {
                log.error(WiFiAgent.class.getResource("/") + "portal not found...");
                System.exit(1);
            }
            String catalinaHome = url.getPath();
            log.info("catalinaHome: " + catalinaHome);
            String contextPath = "";
            StandardContext rootContext = (StandardContext)server.addWebapp(contextPath, catalinaHome);
            rootContext.setReloadable(false);
            rootContext.addWelcomeFile("index.html");
            rootContext.addWelcomeFile("index.htm");
            rootContext.addWelcomeFile("index.jsp");
            rootContext.setWorkDir("tmp");
            log.info("web app workPath: " + rootContext.getWorkPath());
            rootContext.setSessionCookiePath("/");
            rootContext.setIgnoreAnnotations(true);
            ((StandardJarScanner)rootContext.getJarScanner()).setScanManifest(false);
            StandardRoot resourceRoot = new StandardRoot((Context)rootContext);
            rootContext.setResources((WebResourceRoot)resourceRoot);
            resourceRoot.setAllowLinking(cfg.isAllowLinking());
            rootContext.getServletContext().setAttribute("manager", (Object)manager);
            RadiusUtil radiusUtil = new RadiusUtil();
            rootContext.getServletContext().setAttribute("radiusUtil", (Object)radiusUtil);
            ScriptUtil scriptUtil = new ScriptUtil();
            rootContext.getServletContext().setAttribute("scriptUtil", (Object)scriptUtil);
            rootContext.getServletContext().setAttribute("cfg", (Object)cfg);
            rootContext.getServletContext().setAttribute("wifiAgent", (Object)this);
            WiFiAgent.initConnectors(cfg, server);
            if (cfg.isUseSSI()) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("inputEncoding", "UTF-8");
                params.put("outputEncoding", "UTF-8");
                String className = SSIServlet.class.getName();
                WiFiAgent.addServlet(className, rootContext, null, params);
                rootContext.addServletMappingDecoded("*.shtml", className);
                rootContext.setPrivileged(true);
            }
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            server.start();
        }
        catch (Exception ex) {
            log.error("HTTP server start alarm: \"" + ex.toString() + "\", exiting...", (Throwable)ex);
            System.exit(1);
        }
    }

    private static void initConnectors(GlobalConfig cfg, Tomcat server) {
        int portHTTP = cfg.getHttpPort();
        log.info("HTTP port: " + portHTTP);
        if (portHTTP > 0) {
            log.info("Starting HTTP connector...");
            Connector connector = server.getConnector();
            connector.setPort(portHTTP);
            connector.setEnableLookups(false);
            connector.setProperty("maxThreads", "200");
            WiFiAgent.setCommonConnectorOptions(connector);
            WiFiAgent.setCustomConnectorOptions(connector, cfg, "portal.tomcat.connector.http.attribute.");
        }
        int portHTTPS = cfg.getHttpsPort();
        log.info("HTTPS port: " + portHTTPS);
        if (portHTTPS > 0) {
            log.info("Starting HTTPS connector...");
            String alias = cfg.getSetup().get("portal.https.keystore.alias", null);
            String password = cfg.getSetup().get("portal.https.keystore.password", "bgbilling");
            URL url = WiFiAgent.class.getResource("/.keystore");
            Connector connector = new Connector("HTTP/1.1");
            connector.setPort(portHTTPS);
            connector.setSecure(true);
            connector.setEnableLookups(false);
            if (url != null) {
                connector.setProperty("keystoreFile", url.getPath());
            } else {
                log.error(WiFiAgent.class.getResource("/") + ".keystore not found...");
            }
            connector.setProperty("keystorePass", password);
            if (alias != null) {
                connector.setProperty("keyAlias", alias);
            }
            if (cfg.isUseHttpsClientAuth()) {
                connector.setProperty("clientAuth", "want");
            }
            connector.setScheme("https");
            connector.setProperty("SSLEnabled", "true");
            connector.setProperty("maxThreads", "200");
            WiFiAgent.setCommonConnectorOptions(connector);
            WiFiAgent.setCustomConnectorOptions(connector, cfg, "portal.tomcat.connector.https.attribute.");
            server.getService().addConnector(connector);
        }
    }

    private static void setCustomConnectorOptions(Connector connector, GlobalConfig cfg, String prefix) {
        Map<String, String> options = cfg.getConnectorOptions(prefix);
        for (Map.Entry<String, String> entry : options.entrySet()) {
            connector.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void addServlet(String servletClass, StandardContext rootContext, Wrapper wrapper, Map<String, String> params) {
        try {
            Servlet servlet = Utils.newInstance(servletClass, Servlet.class);
            if (servlet != null) {
                if (wrapper == null) {
                    wrapper = rootContext.createWrapper();
                }
                wrapper.setName(servletClass);
                wrapper.setServletClass(servletClass);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        wrapper.addInitParameter(entry.getKey(), entry.getValue());
                    }
                }
                rootContext.addChild((Container)wrapper);
            }
        }
        catch (Exception e) {
            log.error("Error while init class " + servletClass, (Throwable)e);
        }
    }

    private static void setCommonConnectorOptions(Connector connector) {
        connector.setUseBodyEncodingForURI(true);
        connector.setMaxPostSize(10000000);
        connector.setMaxSavePostSize(1000000);
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|help]");
        sb.append("\nParameters:");
        sb.append("\n\t help                       - show this help");
        sb.append("\n\t start                      - starting WiFi agent");
        sb.append("\n\t stop                       - stopping WiFi agent");
        sb.append("\n\t status                       - show  WiFi agent status");
        sb.append("\n\nExample: wifi_agent.sh start");
        sb.append("\nExample: wifi_agent.sh stop");
        System.out.println(sb.toString());
    }

    private double doit(GlobalConfig cfg) {
        Document doc = null;
        try {
            int sleep = cfg.getSetup().getInt("wifi.agent.start.sleep", 0);
            Thread.sleep(sleep);
            HashMap<String, String> request = new HashMap<String, String>();
            request.put("module", "util");
            request.put("action", "Temp");
            request.put("checkedModule", this.getModuleName());
            cfg.isUseHttps();
            doc = WiFiUtil.getDocument(request, cfg.isUseHttps() ? cfg.getServerHttpsUrl() : cfg.getServerHttpUrl(), cfg.getServerLogin(), cfg.getServerPasswd());
        }
        catch (Exception e) {
            log.error(Utils.swapWords("reor rhwli eocnnceitgnw ti hesvrre"), (Throwable)e);
        }
        String err = null;
        if (doc == null || (err = WiFiUtil.checkStatus(doc)) != null) {
            log.info(Utils.swapWords("oY uahev'n tocnnceitnot  ogbibllni gesvrreo  rileccn eof riWif\u0430 egtn"));
            if (err != null) {
                log.info(err);
            }
            WiFiAgent.out();
        }
        return 0.0;
    }

    private static void out() {
        LogManager.shutdown();
        System.exit(1);
    }

    protected abstract String getModuleName();

    public abstract double getBalance(String var1) throws BGException;

    public abstract String sendPasswords(String var1);

    public String activate(Map<String, String> params) throws BGException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        WiFiActivateService service = this.getWebService(WiFiActivateService.class);
        return service.activate(cfg.getModuleId(), new MapHolder<String, String>(params));
    }

    public String activateWithForward(Map<String, String> params) throws BGException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        WiFiActivateService service = this.getWebService(WiFiActivateService.class);
        return service.activateWithForward(cfg.getModuleId(), new MapHolder<String, String>(params));
    }

    public <T> T getWebService(Class<T> clazz, int moduleId) {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        Preferences params = new Preferences();
        params.set("system.username", cfg.getServerLogin());
        params.set("system.password", cfg.getServerPasswd());
        String url = cfg.isUseHttps() ? cfg.getServerHttpsUrl() : cfg.getServerHttpUrl();
        return new WSClient(params).getPort(url + "/executer", clazz, moduleId);
    }

    public <T> T getWebService(Class<T> clazz) {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        return this.getWebService(clazz, cfg.getModuleId());
    }

    public Document getAnswer(Map<String, String> request) {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        String url = cfg.isUseHttps() ? cfg.getServerHttpsUrl() : cfg.getServerHttpUrl();
        return WiFiUtil.getDocument(request, url, cfg.getServerLogin(), cfg.getServerPasswd());
    }

    private static void executeCommand(String host, String command, int portAdmin) {
        try {
            byte[] data = command.toString().getBytes("ISO-8859-1");
            DatagramPacket packet = new DatagramPacket(data, data.length);
            packet.setAddress(InetAddress.getByName(host));
            packet.setPort(portAdmin);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            byte[] buffer = new byte[1000000];
            DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
            socket.setSoTimeout(2000);
            try {
                socket.receive(responsePacket);
                socket.close();
                System.out.println(new String(responsePacket.getData(), 0, responsePacket.getLength(), "ISO-8859-1"));
            }
            catch (Exception e) {
                System.err.println("Error: " + host + ":" + portAdmin + " unavailable: " + e.getLocalizedMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + host + ":" + portAdmin + ": " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

