/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.event.CityModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=CityModifiedEvent.class, serviceClass=AddressService.class)
public class City
extends IdTitle {
    private int countryId;
    private int positionIndex;
    private Country country = null;

    @XmlAttribute
    public int getCountryId() {
        return this.countryId;
    }

    public City setCountryId(int countryId) {
        this.countryId = countryId;
        return this;
    }

    @XmlAttribute
    public int getPositionIndex() {
        return this.positionIndex;
    }

    public City setPositionIndex(int positionIndex) {
        this.positionIndex = positionIndex;
        return this;
    }

    public Country getCountry() {
        return this.country;
    }

    public City setCountry(Country country) {
        this.country = country;
        return this;
    }

    public static City from(City city) {
        return City.builder().setId(city.getId()).setTitle(city.getTitle()).setCountryId(city.getCountryId()).setPositionIndex(city.getPositionIndex()).setCountry(Country.from(city.getCountry())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private City city = new City();

        private Builder() {
        }

        public Builder setId(int id) {
            this.city.id = id;
            return this;
        }

        public Builder setCountryId(int countryId) {
            this.city.countryId = countryId;
            return this;
        }

        public Builder setCountry(Country country) {
            this.city.setCountry(country);
            return this;
        }

        public Builder setPositionIndex(int positionIndex) {
            this.city.positionIndex = positionIndex;
            return this;
        }

        public Builder setTitle(String title) {
            this.city.title = title;
            return this;
        }

        public City build() {
            try {
                City city = this.city;
                return city;
            }
            finally {
                this.city = null;
            }
        }
    }
}

