/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.common.bean;

import ru.bitel.bgbilling.kernel.directory.api.common.DirectoryItem;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;
import ru.bitel.oss.kernel.directories.address.common.event.QuarterModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

@DirectoryItem(eventClass=QuarterModifiedEvent.class, serviceClass=AddressService.class)
public class Quarter
extends CityItem {
    public Quarter() {
    }

    public Quarter(City city, int id, String title) {
        super(id, title);
        this.setCity(city);
    }

    public static Quarter from(Quarter quarter) {
        return Quarter.builder().setId(quarter.getId()).setTitle(quarter.getTitle()).setCityId(quarter.getCityId()).setCity(City.from(quarter.getCity())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Quarter quarter = new Quarter();

        private Builder() {
        }

        public Builder setId(int id) {
            this.quarter.id = id;
            return this;
        }

        public Builder setCityId(int cityId) {
            this.quarter.cityId = cityId;
            return this;
        }

        public Builder setCity(City city) {
            this.quarter.setCity(city);
            return this;
        }

        public Builder setTitle(String title) {
            this.quarter.title = title;
            return this;
        }

        public Quarter build() {
            try {
                Quarter quarter = this.quarter;
                return quarter;
            }
            finally {
                this.quarter = null;
            }
        }
    }
}

