/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.softline.common.bean.SotfLineProductCategory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ProductCategoryDao
extends AbstractIdDao<SotfLineProductCategory> {
    public ProductCategoryDao(Connection connection, int moduleId) {
        this(connection, moduleId, "softline_product_category");
    }

    public ProductCategoryDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public void getList(SearchResult<SotfLineProductCategory> searchResult) throws BGException {
        List result = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName;
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected SotfLineProductCategory getFromRS(ResultSet rs) throws SQLException, BGException {
        SotfLineProductCategory productCategory = new SotfLineProductCategory();
        productCategory.setId(rs.getInt("id"));
        productCategory.setTitle(rs.getString("title"));
        productCategory.setDescription(rs.getString("description"));
        return productCategory;
    }

    protected void updateImpl(SotfLineProductCategory productCategory) throws BGException, SQLException {
        String query = productCategory.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?, description=? WHERE id=?" : "INSERT INTO " + this.tableName + " (title, description) VALUES (?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, productCategory.getTitle());
            ps.setString(index++, productCategory.getDescription());
            if (productCategory.getId() > 0) {
                ps.setInt(index, productCategory.getId());
            }
            ps.executeUpdate();
            if (productCategory.getId() == 0) {
                productCategory.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

