/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vepay.server.action.apps;

import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.vepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.vepay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;

public class ActionDoPayment
extends AppsAbstractAction {
    public void execute() throws BGException {
        int moduleId = this.getIntParameter("module_id", -1);
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.");
        }
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        BigDecimal amount = this.getBigDecimal("amount", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        try (TransactionManager transactionManager = new TransactionManager(this.con, moduleId);
             ContractDao contractDao = new ContractDao(this.con, -1);){
            Contract contract = (Contract)contractDao.get(this.contractId);
            if (contract == null) {
                throw new BGMessageException("Contract don't finde !");
            }
            String description = "";
            description = moduleSetup.get("vepay.comment", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(amount)).setContractId(this.contractId)).setCreateDate(new Date())).build();
            transactionManager.update(transaction);
            String urlSuccess = moduleSetup.get("vepay.url.success", "");
            String urlFail = moduleSetup.get("vepay.url.fail", "");
            String redirectUrl = transactionManager.doPaymentRequest(transaction, amount, description, urlSuccess, urlFail, false);
            if (redirectUrl != null) {
                this.actionMap.put("urlRedirect", redirectUrl);
                this.actionMap.put("urlSuccess", urlSuccess);
                this.actionMap.put("urlFailure", urlFail);
            }
        }
    }
}

