/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.proccess.radius;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.proccess.radius.RadiusLogProcessTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyLogFileUtils;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.voice.server.bean.DataProccessRecordDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceDao;
import ru.bitel.bgbilling.modules.voice.server.event.RequestRadiusLogInfoEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.PeriodicalTaskRunner;

public class RadiusLogProcessor
extends PeriodicalTaskRunner<RadiusLogProcessTask>
implements EventListener<RequestRadiusLogInfoEvent>,
Lifecycle {
    protected final int moduleId;
    private static Logger logger = LogManager.getLogger();

    @ConstructorProperties(value={"app", "initialDelay", "delay"})
    public RadiusLogProcessor(VoiceApplication application, long initialDelay, long delay) {
        super(application.getSetup(), 1, initialDelay, delay, application.getModuleId(), "radiusLogProcess");
        this.moduleId = application.getModuleId();
        try {
            EventProcessor.getInstance().addListener((EventListener)this, RequestRadiusLogInfoEvent.class, this.moduleId, null);
        }
        catch (BGException ex) {
            logger.error("", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<RadiusLogProcessTask> readTasks() throws BGException {
        ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        ArrayList<RadiusLogProcessTask> result = new ArrayList<RadiusLogProcessTask>();
        try (VoiceDeviceDao deviceDAO = new VoiceDeviceDao(connectionSet.getConnection(), this.moduleId);
             DataProccessRecordDao dataProccessRecordDao = new DataProccessRecordDao(connectionSet.getConnection(), this.moduleId);){
            List<DataProcessRecord> records = dataProccessRecordDao.list(true);
            for (DataProcessRecord record : records) {
                RadiusLogProcessTask task = new RadiusLogProcessTask(this.setup, record.getDeviceId(), record.getDay(), this.moduleId);
                result.add(task);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            connectionSet.recycle();
        }
        return result;
    }

    public void stop() throws Exception {
    }

    public void notify(RequestRadiusLogInfoEvent event, EventListenerContext ctx) throws BGException {
        try {
            int[] logs = HourlyLogFileUtils.getLogExistsForMonth((ParameterMap)this.setup, (String)"datalog.radius.accounting.dir", (Date)event.getMonth(), (int)event.getDeviceId());
            event.addLogs(logs);
        }
        catch (Exception e) {
            logger.error("error while recieving message", (Throwable)e);
        }
    }
}

