/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceOperatorDao
extends AbstractIdDao<VoiceOperator> {
    private static final String OPERATOR_TABLE = "voice_operator";

    public VoiceOperatorDao(Connection con, int mid) {
        super(con, mid, OPERATOR_TABLE);
    }

    protected VoiceOperator getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceOperator result = new VoiceOperator();
        result.setId(rs.getInt("operator.id"));
        result.setTitle(rs.getString("operator.title"));
        result.setContractId(rs.getInt("operator.contractId"));
        result.setContractTitle(rs.getString("contract.title"));
        result.setComment(rs.getString("operator.comment"));
        result.setUseCustomGeoDict(rs.getBoolean("useCustomGeoDict"));
        return result;
    }

    protected void updateImpl(VoiceOperator b) throws BGException, SQLException {
        String query = b.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?,contractId=?,comment=?, useCustomGeoDict=? WHERE id=?" : "INSERT INTO " + this.tableName + "(title,contractId,comment,useCustomGeoDict) VALUES (?,?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setInt(index++, b.getContractId());
            ps.setString(index++, b.getComment());
            ps.setBoolean(index++, b.isUseCustomGeoDict());
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException e) {
            int errorCode = e.getErrorCode();
            if (errorCode == 1062) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c/\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0438\u0441\u044c, \u0442.\u043a. \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + b.getContractId() + ". \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u043f\u043e\u043c\u0435\u043d\u044f\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
            }
            throw new BGException((Throwable)e);
        }
    }

    public List<VoiceOperator> list() throws BGException {
        ArrayList<VoiceOperator> result = new ArrayList<VoiceOperator>();
        String query = "SELECT operator.*, contract.title FROM " + this.tableName + " operator LEFT JOIN contract ON contract.id=operator.contractId ORDER BY operator.id";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    protected int deleteImpl(int id) throws BGException {
        int result = 0;
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=" + id);){
            result = ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430, \u0442.\u043a. \u043a \u043d\u0435\u043c\u0443 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043e \u043e\u0434\u043d\u043e \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439!");
        }
        return result;
    }

    protected VoiceOperator getImpl(int id) throws BGException {
        VoiceOperator result = null;
        String query = "SELECT operator.*, contract.title FROM " + this.tableName + " operator LEFT JOIN contract ON contract.id=operator.contractId WHERE operator.id = " + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

