/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.radius;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchModeEq;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchModePattern;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class RadiusSearchPattrernManager {
    private static final Logger logger = LogManager.getLogger();
    private List<VoiceSearchModePattern> patterns = new ArrayList<VoiceSearchModePattern>();
    private List<VoiceSearchModePattern> operpatterns = new ArrayList<VoiceSearchModePattern>();
    private Map<Integer, VoiceSearchModePattern> patternMap = new HashMap<Integer, VoiceSearchModePattern>();
    private Map<Integer, VoiceSearchModePattern> operPatternMap = new HashMap<Integer, VoiceSearchModePattern>();
    private Preferences setup;

    public RadiusSearchPattrernManager(Preferences setup) {
        this.setup = setup;
        this.load("radius.search.mode.pattern.", this.patterns, this.patternMap);
        this.load("radius.oper.search.mode.pattern.", this.operpatterns, this.operPatternMap);
    }

    private void load(String prefix, List<VoiceSearchModePattern> patterns, Map<Integer, VoiceSearchModePattern> patternMap) {
        for (Map.Entry me : this.setup.subIndexed(prefix).entrySet()) {
            int id = (Integer)me.getKey();
            ParameterMap params = (ParameterMap)me.getValue();
            String value = params.get("rule");
            if (Utils.isEmptyString((String)value)) {
                logger.error("Error findmode string: " + me.getKey() + "=" + me.getValue());
                continue;
            }
            String[] parts = value.split("=");
            String attribute = parts[0];
            String eqString = parts[1];
            VoiceSearchModeEq eq = null;
            if (parts.length != 2) {
                logger.error("Error findmode string: " + me.getKey() + "=" + me.getValue());
                continue;
            }
            if (eqString.equalsIgnoreCase("PHONE")) {
                eq = VoiceSearchModeEq.PHONE;
            } else if (eqString.equalsIgnoreCase("LOGIN")) {
                eq = VoiceSearchModeEq.LOGIN;
            } else {
                logger.error("Error findmode string: " + me.getKey() + "=" + me.getValue());
                continue;
            }
            RadiusAttributeInfo attributeInfo = RadiusDictionary.findAttributeInfo((String)attribute);
            if (attributeInfo == null) {
                logger.error("Can't find " + attribute);
                continue;
            }
            VoiceSearchModePattern mode = new VoiceSearchModePattern();
            mode.setAttributeInfo(attributeInfo);
            mode.setEq(eq);
            patterns.add(mode);
            patternMap.put(id, mode);
        }
    }

    public List<VoiceSearchModePattern> getPatterns() {
        return this.patterns;
    }

    public Map<Integer, VoiceSearchModePattern> getPatternMap() {
        return this.patternMap;
    }

    public Map<Integer, VoiceSearchModePattern> getOperPatternMap() {
        return this.operPatternMap;
    }
}

