/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.radius;

import bitel.billing.server.contract.bean.ContractManager;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.VoiceSessionRuntimeFlushingManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.network.radius.Digest5090RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPSession;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.voice.common.bean.AccessCodes;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.common.om.ProtocolHandler;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadEvent;
import ru.bitel.bgbilling.modules.voice.server.radius.RadiusAccessRequestEvent;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNas;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasConnection;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceNasList;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceRadiusSessionParams;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchMode;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchModeEq;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountTypeRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountTypeRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOptionRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOptionRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceRadius;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class VoiceRadiusProcessor
extends RadiusProcessor<VoiceNasConnection, VoiceNas, VoiceRadiusSessionParams> {
    private final VoiceRadius application;
    private static Logger logger = LogManager.getLogger();
    private int maxSessionTime;

    @ConstructorProperties(value={"setup", "app"})
    public VoiceRadiusProcessor(Setup setup, VoiceRadius application) throws BGException {
        this(setup, application, new VoiceNasList(application));
    }

    public VoiceRadiusProcessor(Setup setup, VoiceRadius application, VoiceNasList nasList) throws BGException {
        super(setup, "voice", SetupParam.getModuleId((ParameterMap)setup), (NasList)nasList, false, false);
        this.application = application;
        this.maxSessionTime = setup.getInt("radius.max.session.time", 5400);
        this.init();
    }

    private void init() {
        this.reloadNasList();
        try {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<VoiceDevicesReloadEvent>(){

                public void notify(VoiceDevicesReloadEvent e, EventListenerContext ctx) throws BGException {
                    VoiceRadiusProcessor.this.reloadNasList();
                }
            }, VoiceDevicesReloadEvent.class);
        }
        catch (BGException e) {
            logger.error("error while add listener", (Throwable)e);
        }
    }

    public String executeCommand(String command, String params) {
        return null;
    }

    protected RadiusSession<VoiceNas, VoiceRadiusSessionParams> newRadiusSession(Connection con, VoiceNas nas, RadiusPacket request, RadiusSession.State state) {
        RadiusAttribute.RadiusAttributeString userNameAttribute = (RadiusAttribute.RadiusAttributeString)request.getAttribute(-1, 1);
        if (userNameAttribute == null) {
            return null;
        }
        short callType = nas.getCallType(request);
        String userName = (String)userNameAttribute.getValue();
        int pos = (userName = Utils.deleteAfterDog((String)userName)).indexOf(92);
        if (pos >= 0) {
            userName = userName.substring(pos + 1);
        }
        userNameAttribute = userNameAttribute.clone();
        if (request.getAttribute(-1, 79) != null) {
            return new EAPSession(userName, userNameAttribute, (Object)new VoiceRadiusSessionParams(callType));
        }
        if (request.getAttribute(-1, 108) != null) {
            return new Digest5090RadiusSession(state != null ? state.state : null, userName, userNameAttribute, (Object)new VoiceRadiusSessionParams(callType));
        }
        return new RadiusSession(state != null ? state.state : null, userName, userNameAttribute, (Object)new VoiceRadiusSessionParams(callType));
    }

    protected void preprocessAccessRequest(VoiceNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        nas.setCallTypeToRequest(request);
        ProtocolHandler protocolHandler = nas.getProtocolHandler();
        if (protocolHandler != null) {
            try {
                protocolHandler.preprocessAccessRequest(request, response, connectionSet);
                logger.info("REQUEST_AFTER_PREPROCESS:\n" + request);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void preprocessAccountingRequest(VoiceNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        nas.setCallTypeToRequest(request);
        if (nas.getProtocolHandler() != null) {
            try {
                nas.getProtocolHandler().preprocessAccountingRequest(request, response, connectionSet);
                logger.info("REQUEST_AFTER_PREPROCESS:\n" + request);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int authentication(RadiusListenerWorker<?> req, VoiceNas nas, RadiusSession<VoiceNas, VoiceRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id) {
        int errorCode = AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
        nas.setErrorCode(response, errorCode);
        try {
            short callType = ((VoiceRadiusSessionParams)session.sessionParams).getCallType();
            logger.debug("Process  " + (switch (callType) {
                case 1 -> "outgoing";
                case 2 -> "incoming";
                default -> "undefined";
            }) + " auth " + request.toString());
            int n = errorCode = this.authenticationImpl(req, nas, session, request, response, connectionSet, log_record_id, false);
            return n;
        }
        catch (Exception ex) {
            logger.error("error in authentication", (Throwable)ex);
            errorCode = AccessCode.SYSTEM_ERROR.getCode();
            int n = AccessCode.SYSTEM_ERROR.getCode();
            return n;
        }
        finally {
            if (errorCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                String message = AccessCodes.toString((ParameterMap)this.setup.getModuleSetup(Integer.valueOf(this.moduleId)), (int)errorCode) + "[" + errorCode + "]";
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeString(-1, 18, message));
                nas.setErrorCode(response, errorCode);
                session.errorCode = errorCode;
            }
        }
    }

    protected int authenticationImpl(RadiusListenerWorker<?> req, VoiceNas nas, RadiusSession<VoiceNas, VoiceRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int logRecordId, boolean realtimeTariff) throws BGException {
        logger.debug("Finding account..");
        List<AccountSearchResult> results = this.searchAccount(connectionSet.getConnection(), nas, request, true);
        boolean isOperator = false;
        if (results.size() == 0) {
            logger.debug("Client accountRuntime is null. Try to search operator...");
            VoiceAccountRuntime accountRuntime = this.searchOperAccount(request);
            isOperator = true;
            return this.checkAuthForAccount(req, nas, session, request, response, connectionSet, logRecordId, accountRuntime, ((VoiceRadiusSessionParams)session.sessionParams).getCallType(), isOperator);
        }
        for (AccountSearchResult res : results) {
            VoiceAccountRuntime accountRuntime = res.accountRuntime;
            short callType = ((VoiceRadiusSessionParams)session.sessionParams).getCallType();
            if (res.callType > 0) {
                callType = res.callType;
                ((VoiceRadiusSessionParams)session.sessionParams).setCallType(callType);
            }
            ((VoiceRadiusSessionParams)session.sessionParams).setCallType(callType);
            int result = this.checkAuthForAccount(req, nas, session, request, response, connectionSet, logRecordId, accountRuntime, callType, isOperator);
            if (result <= 0) continue;
            return result;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkAuthForAccount(RadiusListenerWorker<?> req, VoiceNas nas, RadiusSession<VoiceNas, VoiceRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, VoiceAccountRuntime accountRuntime, short callType, boolean isOperator) throws BGException {
        Contract contract;
        boolean isOutgoing;
        boolean bl = isOutgoing = callType == 1;
        if (accountRuntime != null) {
            String contractTitle;
            session.login = accountRuntime;
            ContractRuntime contractRuntime = this.application.getContractRuntimeMap().getContractRuntime(connectionSet, Integer.valueOf(accountRuntime.getContractId()));
            String string = contractTitle = contractRuntime != null ? contractRuntime.getContractTitle() : null;
            if (contractTitle == null && (contract = (Contract)new ContractDao(connectionSet.getConnection(), 0).get(accountRuntime.getContractId())) != null) {
                contractTitle = contract.getTitle();
            }
            session.contract = new bitel.billing.server.contract.bean.Contract();
            session.contract.setTitle(contractTitle);
            session.contract.setId(accountRuntime.getContractId());
        }
        if (accountRuntime != null) {
            logger.debug("account with id=" + accountRuntime.getAccountId() + " found ");
        } else if (isOutgoing) {
            logger.debug("account not found. trying to search card ");
        }
        if (accountRuntime == null) {
            logger.debug("account not found ");
            return AccessCode.INVALID_ACCOUNT.getCode();
        }
        if (callType != 1 && callType != 2) {
            return AccessCode.CALL_TYPE_NOT_RECOGNIZED.getCode();
        }
        this.checkLoginAndContract();
        int result = 0;
        result = this.checkPassword(nas, session, request, response, isOutgoing, accountRuntime, isOperator);
        if (result > 0) {
            return result;
        }
        ContractManager contractManager = new ContractManager(connectionSet.getConnection());
        try {
            contract = null;
            String userName = null;
            int n = this.authorization(req, nas, session, request, response, connectionSet, log_record_id, contractManager, (bitel.billing.server.contract.bean.Contract)contract, (Object)accountRuntime, userName);
            return n;
        }
        finally {
            contractManager.recycle();
        }
    }

    private int checkPassword(VoiceNas nas, RadiusSession<VoiceNas, VoiceRadiusSessionParams> session, RadiusPacket request, RadiusPacket response, boolean isOutgoing, VoiceAccountRuntime accountRuntime, boolean isOperator) throws BGException {
        boolean checkPassword;
        VoiceAccountType type = null;
        VoiceAccountTypeRuntimeMap voiceAccountTypeRuntimeMap = this.application.getAccountTypeRuntimeMap();
        VoiceAccountTypeRuntime typeRuntime = (VoiceAccountTypeRuntime)voiceAccountTypeRuntimeMap.get(((VoiceAccount)accountRuntime.getAccount()).getTypeId());
        if (typeRuntime == null || (type = typeRuntime.getType()) == null) {
            logger.error("type is null for account id = " + accountRuntime.getAccountId());
            return AccessCode.SYSTEM_ERROR.getCode();
        }
        boolean bl = checkPassword = type != null && type.isCheckPassword();
        if (checkPassword && (isOperator || isOutgoing)) {
            logger.debug("Checking password...");
            if (!session.checkPassword((Nas)nas, (RadiusAttributeSet)request, (RadiusAttributeSet)response, accountRuntime.getPassword(), nas.getSecret(), request.getAuthenticator())) {
                logger.debug("password check failed..");
                return AccessCode.INVALID_PIN.getCode();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int authorization(RadiusListenerWorker<?> req, VoiceNas nas, RadiusSession<VoiceNas, VoiceRadiusSessionParams> radiusSession, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, int log_record_id, ContractManager contractM, bitel.billing.server.contract.bean.Contract contract, Object login, String userName) {
        try {
            VoiceAccountRuntime accountRuntime = (VoiceAccountRuntime)login;
            logger.debug("Checking account  status...");
            if (accountRuntime.getStatus().getCode() != VoiceAccountStatus.STATUS_ON.getCode()) {
                logger.debug("account status blocked");
                return AccessCode.ACCOUNT_LOCKED.getCode();
            }
            ContractRuntime contractRuntime = this.application.getContractRuntimeMap().getContractRuntime(connectionSet, Integer.valueOf(accountRuntime.getContractId()));
            if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, contractRuntime.getStatus())) {
                return AccessCode.CONTRACT_LOCKED.getCode();
            }
            long millis = System.currentTimeMillis();
            logger.debug("Checking tariff...");
            List treeList = accountRuntime.getTariffTreeSet().getEntryList(millis);
            if (treeList.size() == 0) {
                logger.debug("Tariff plan not found.");
                return AccessCode.TARIFF_NOT_FOUND.getCode();
            }
            short callType = ((VoiceRadiusSessionParams)radiusSession.sessionParams).getCallType();
            String number = nas.getTarifficationNumber(request, callType);
            if (number == null) {
                int contractId = ((VoiceAccount)accountRuntime.getAccount()).getContractId();
                int result = this.checkBalance(response, connectionSet, millis, nas, contractId);
                if (result > 0) {
                    return result;
                }
                ConvergenceBalance balance = this.application.getConvergenceBalanceManager().getBalance(connectionSet, Integer.valueOf(contractId), millis);
                BigDecimal balanceOverLimit = balance.getBalance().subtract(balance.getLimit(), MathContext.DECIMAL64);
                nas.setCreditAmount(response, balanceOverLimit);
                response.setCode((byte)2);
            } else {
                SessionTemp sessionTemp;
                int result;
                logger.debug("Checking sessionCount...");
                if (((VoiceAccount)accountRuntime.getAccount()).getSessionCountLimit() > 0) {
                    accountRuntime.lock();
                    try {
                        logger.debug("sessionCountLimit is " + ((VoiceAccount)accountRuntime.getAccount()).getSessionCountLimit());
                        Set<VoiceSessionRuntime> sessions = this.application.getSessionsByAccountId(accountRuntime.getAccountId());
                        String indentifier = nas.getIdentifier(request);
                        sessions = sessions.stream().filter(s -> !s.getSession().getIdentifier().equals(indentifier)).collect(Collectors.toSet());
                        if (sessions != null && sessions.size() >= ((VoiceAccount)accountRuntime.getAccount()).getSessionCountLimit()) {
                            logger.debug("Sessions count exceeded");
                            int n = AccessCode.TOO_MANY_SESSIONS_ERROR.getCode();
                            return n;
                        }
                    }
                    finally {
                        accountRuntime.unlock();
                    }
                }
                if ((result = (sessionTemp = new SessionTemp()).checkRestAndGetMaxSessionTime(response, accountRuntime, this.maxSessionTime, connectionSet, number, callType, millis, nas)) > 0) {
                    return result;
                }
                this.setOptionAttributes(response, sessionTemp);
            }
            if (callType == 1) {
                return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
            }
            if (callType != 2) return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
            return AccessCode.AUTHORIZATION_SUCCEEDED.getCode();
        }
        catch (BGException e) {
            logger.error("error in authorizatiob", (Throwable)e);
            return AccessCode.SYSTEM_ERROR.getCode();
        }
    }

    private void setOptionAttributes(RadiusPacket response, SessionTemp sessionTemp) throws BGException {
        Set<Integer> options = sessionTemp.getOptions();
        VoiceOptionRuntimeMap optionMap = VoiceOptionRuntimeMap.getInstance(this.moduleId);
        for (Integer optionId : options) {
            VoiceOptionRuntime option = optionMap.get(optionId);
            RadiusAttributeSet attrSet = option.getRadiusAttributes();
            response.addAttributes(attrSet);
        }
    }

    private void checkLoginAndContract() {
    }

    public String getStatus() {
        return null;
    }

    protected int insertToLog(Date date, RadiusPacket packet) {
        return 0;
    }

    protected void addToLog(Date date, RadiusPacket packet, int recordId) {
    }

    private List<AccountSearchResult> searchAccount(Connection con, VoiceNas nas, RadiusPacket request, boolean isAuth) throws BGException {
        List<VoiceSearchMode> searchModes = isAuth ? nas.getAuthSearchModes() : nas.getAccSearchModes();
        ArrayList<AccountSearchResult> result = new ArrayList<AccountSearchResult>();
        for (VoiceSearchMode mode : searchModes) {
            VoiceAccountRuntime accountRuntime = null;
            List attributes = request.getAttributes(mode.getPattern().getAttributeInfo().vendor, mode.getPattern().getAttributeInfo().type);
            if (attributes == null || attributes.size() == 0) continue;
            String attributeValue = ((RadiusAttribute)attributes.get(attributes.size() - 1)).toString();
            if (logger.isTraceEnabled()) {
                logger.trace("attributeValue->" + attributeValue);
            }
            if (Utils.isBlankString((String)attributeValue)) continue;
            if (mode.getPattern().getEq() == VoiceSearchModeEq.LOGIN) {
                accountRuntime = this.application.getVoiceAccountRuntimeMap().searchByLogin(attributeValue, new Date());
            } else if (mode.getPattern().getEq() == VoiceSearchModeEq.PHONE) {
                if (!attributeValue.matches("^\\d+$")) {
                    logger.error("\u041f\u0420\u041e\u041f\u0423\u0421\u041a\u0410\u0415\u041c \u041f\u041e\u0418\u0421\u041a. \u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u043e\u043c\u0435\u0440\u0430 -> " + attributeValue);
                    continue;
                }
                long phoneNumber = Utils.parseLong((String)attributeValue, (long)-1L);
                if (phoneNumber < 0L) {
                    logger.error("\u041f\u0420\u041e\u041f\u0423\u0421\u041a\u0410\u0415\u041c \u041f\u041e\u0418\u0421\u041a. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0432 long -> " + attributeValue + " toLong -> " + phoneNumber);
                    continue;
                }
                accountRuntime = this.application.getVoiceAccountRuntimeMap().searchByDeviceAndNumber(nas.getId(), phoneNumber, new Date(), nas.isDeepDeviceSearch());
            }
            if (accountRuntime == null) continue;
            logger.trace("if found...");
            AccountSearchResult searchResult = new AccountSearchResult();
            searchResult.accountRuntime = accountRuntime;
            searchResult.callType = mode.getCallType();
            result.add(searchResult);
        }
        return result;
    }

    private VoiceAccountRuntime getOperAccountFromRequest(RadiusPacket request) {
        Integer operAccountId = (Integer)request.getOption(VoiceNas.OPERATOR_ACCOUNT);
        Integer operatorId = (Integer)request.getOption(VoiceNas.OPERATOR);
        if (operAccountId == null && operatorId != null) {
            operAccountId = 0;
        }
        if (operAccountId != null) {
            VoiceAccountRuntimeMap voiceAccountRuntimeMap = this.application.getVoiceAccountRuntimeMap();
            return voiceAccountRuntimeMap.get(operAccountId);
        }
        return null;
    }

    public VoiceAccountRuntime searchOperAccount(RadiusPacket request) throws BGException {
        VoiceAccountRuntime accountRuntime = this.getOperAccountFromRequest(request);
        if (accountRuntime != null) {
            return accountRuntime;
        }
        return accountRuntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateSession(VoiceSessionRuntime sessionRuntime, ConnectionSet connectionSet, boolean round) {
        VoiceTariffWorkerContext workerContext = new VoiceTariffWorkerContext(this.setup, connectionSet, this.moduleId);
        ServerContext parentContext = (ServerContext)ServerContext.get();
        ServerContext.push((ThreadContext)workerContext);
        int result = 0;
        try {
            result = sessionRuntime.calculate(this.application.getRuntimeTariffContext(), sessionRuntime.getCalculateAmountDelta(), round);
            sessionRuntime.setCalculateAmountDelta(0L);
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
        }
        return result;
    }

    public List<VoiceSessionRuntime> createSessionRuntimes(ConnectionSet connectionSet, RadiusPacket request, String acctSessionId, String identifier, VoiceNas nas, Date time) throws BGException {
        List<AccountSearchResult> accounts = this.searchAccount(connectionSet.getConnection(), nas, request, false);
        ArrayList<VoiceSessionRuntime> sessions = new ArrayList<VoiceSessionRuntime>();
        if (accounts.size() == 0) {
            VoiceAccountRuntime accountRuntime = this.searchOperAccount(request);
            if (accountRuntime == null) {
                logger.error("Account not found");
                return sessions;
            }
            logger.debug("Operator account with id=" + accountRuntime.getAccountId() + " found ");
            VoiceSessionRuntime sessionRuntime = this.createSessionRuntimeForAccount(request, acctSessionId, identifier, nas, accountRuntime, nas.getCallType(request), time);
            if (sessionRuntime != null) {
                sessions.add(sessionRuntime);
            } else {
                logger.error("Session was not created for account" + accountRuntime.getAccountId());
            }
        } else {
            for (AccountSearchResult res : accounts) {
                VoiceSessionRuntime sessionRuntime;
                logger.debug("account with id=" + res.accountRuntime.getAccountId() + " found ");
                short callType = nas.getCallType(request);
                if (res.callType > 0) {
                    callType = res.callType;
                }
                if ((sessionRuntime = this.createSessionRuntimeForAccount(request, acctSessionId, identifier, nas, res.accountRuntime, callType, time)) != null) {
                    sessions.add(sessionRuntime);
                    continue;
                }
                logger.error("Session was not created for account" + res.accountRuntime.getAccountId());
            }
        }
        return sessions;
    }

    private VoiceSessionRuntime createSessionRuntimeForAccount(RadiusPacket request, String acctSessionId, String identifier, VoiceNas nas, VoiceAccountRuntime accountRuntime, short callType, Date time) {
        Date sessionStart = time;
        String callingStationId = nas.getCallingStationId(request);
        String calledStationId = nas.getCalledStationId(request);
        String toPort = nas.getToPort(request);
        String fromPort = nas.getFromPort(request);
        VoiceSession session = VoiceSession.builder().setAcctSessionId(acctSessionId).setIdentifier(identifier).setAccountId(accountRuntime.getAccountId()).setContractId(accountRuntime.getContractId()).setDeviceId(nas.getId()).setCallingStationId(callingStationId).setCalledStationId(calledStationId).setSessionStart(sessionStart).setHour(TimeUtils.clear_MIN_MIL_SEC((Date)sessionStart)).setE164CallingStationId(callingStationId).setE164CalledStationId(calledStationId).setFromPort(fromPort).setToPort(toPort).setAccountMap(new HashMap()).setSessionCost(BigDecimal.ZERO).setCallType(callType).build();
        logger.debug("create session =>" + session);
        VoiceSessionRuntime sessionRuntime = new VoiceSessionRuntime(session, accountRuntime);
        sessionRuntime.setTarifficationNumber(nas.getTarifficationNumber(request, callType));
        return sessionRuntime;
    }

    public void addSesionRuntime(VoiceSessionRuntime sessionRuntime) {
        this.application.addSesionRuntime(sessionRuntime);
    }

    private int checkBalance(RadiusPacket response, ConnectionSet connectionSet, long millis, VoiceNas nas, int contractId) throws BGException {
        logger.debug("checkingBalance");
        ConvergenceBalance balance = this.application.getConvergenceBalanceManager().getBalance(connectionSet, Integer.valueOf(contractId), millis);
        return !balance.isBalanceExceedsLimit(BigDecimal.ZERO) ? AccessCode.BALANCE_INSUFFICIENT.getCode() : 0;
    }

    protected void saveSessionRuntime(VoiceSessionRuntime sessionRuntime, ConnectionSet connectionSet) throws BGException {
        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
            VoiceSessionRuntimeFlushingManager manager = new VoiceSessionRuntimeFlushingManager(this.moduleId, sessionRuntime.getSession().getSessionStart(), this.application.getBalanceEP());
            if (sessionRuntime.getSession().getId() > 0L) {
                manager.update(connectionSet, sessionRuntime);
            } else {
                manager.insert(connectionSet, sessionRuntime);
                this.addSesionRuntime(sessionRuntime);
            }
            this.setBalanceAccount(sessionRuntime, connectionSet, balanceDao);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    private void setBalanceAccount(VoiceSessionRuntime sessionRuntime, ConnectionSet connectionSet, BalanceDao balanceDao) throws BGException {
        int contractId = sessionRuntime.getContractId();
        ContractRuntime contractRuntime = this.application.getContractRuntimeMap().getContractRuntime(connectionSet, Integer.valueOf(contractId));
        if (contractRuntime == null) {
            throw new BGException("ContractRuntime is null for " + contractId);
        }
        Calendar cal = TimeUtils.convertDateToCalendar((Date)sessionRuntime.getSession().getSessionStart());
        int yy = cal.get(1);
        int mm = cal.get(2) + 1;
        balanceDao.setBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm);
    }

    public void removeSessionRuntime(VoiceSessionRuntime sessionRuntime) {
        this.application.removeSessionRuntime(sessionRuntime);
    }

    protected void accessRequestImpl(RadiusListenerWorker<VoiceNas> req, VoiceNas nas, RadiusPacket request, RadiusPacket response, Date date, RadiusSession<VoiceNas, VoiceRadiusSessionParams> radiusSession, int logRecordId, ConnectionSet connectionSet) {
        super.accessRequestImpl(req, (Nas)nas, request, response, date, radiusSession, logRecordId, connectionSet);
        byte result = response.getCode();
        if (result == 2) {
            try {
                EventProcessor.getInstance().request((QueueEvent)new RadiusAccessRequestEvent(this.moduleId, nas, radiusSession, request, response));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void postprocessAccessRequest(VoiceNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        if (nas.getProtocolHandler() != null) {
            try {
                logger.info("RESPONSE_BEFORE_POSTPROCESS:\n" + response);
                nas.getProtocolHandler().postprocessAccessRequest(request, response, connectionSet);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void postprocessAccountingRequest(VoiceNas nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet) {
        if (nas.getProtocolHandler() != null) {
            try {
                logger.info("RESPONSE_BEFORE_POSTPROCESS:\n" + response);
                nas.getProtocolHandler().postprocessAccountingRequest(request, response, connectionSet);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public VoiceNas getNas(int id) {
        return (VoiceNas)this.nasList.get(id);
    }

    public PoolEventPublisher<ContractBalanceChangedEvent> getBalanceEP() {
        return this.application.getBalanceEP();
    }

    private static class AccountSearchResult {
        VoiceAccountRuntime accountRuntime;
        short callType;

        private AccountSearchResult() {
        }
    }

    class SessionTemp {
        public int maxSessionTime;
        private Set<Integer> options = new HashSet<Integer>();

        SessionTemp() {
        }

        private int checkRestAndGetMaxSessionTime(RadiusPacket response, VoiceAbtractAccountRuntime accountRuntime, int maxSessionTime, ConnectionSet connectionSet, String number, short callType, long millis, VoiceNas nas) throws BGException {
            int creditTime;
            boolean sessionCostIsNull;
            this.maxSessionTime = maxSessionTime;
            Date now = new Date();
            String phoneTo = number;
            VoiceSession session = VoiceSession.builder().setContractId(accountRuntime.getContractId()).setSessionStart(now).setCalledStationId(phoneTo).setE164CalledStationId(phoneTo).setCallType(callType).build();
            VoiceSessionRuntime sessionRuntime = new VoiceSessionRuntime(session, accountRuntime);
            ServerContext parentContext = (ServerContext)ServerContext.get();
            VoiceTariffWorkerContext workerContext = new VoiceTariffWorkerContext(parentContext.getSetup(), parentContext.getConnectionSet(), parentContext.getModuleId());
            int result = 0;
            try {
                ServerContext.push((ThreadContext)workerContext);
                result = sessionRuntime.calculate(VoiceRadiusProcessor.this.application.getRuntimeTariffContext(), 60L, false);
                if (result > 0) {
                    logger.debug("session.getContractId() after calculation is " + session.getContractId());
                    int n = result;
                    return n;
                }
                this.options = sessionRuntime.getOptionsSet();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
            finally {
                workerContext.commit();
                workerContext.recycle();
                ServerContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
            }
            result = VoiceRadiusProcessor.this.checkBalance(response, connectionSet, millis, nas, session.getContractId());
            if (result > 0) {
                return result;
            }
            ConvergenceBalance balance = VoiceRadiusProcessor.this.application.getConvergenceBalanceManager().getBalance(connectionSet, Integer.valueOf(session.getContractId()), millis);
            BigDecimal balanceOverLimit = balance.getBalance().subtract(balance.getLimit(), MathContext.DECIMAL64);
            boolean bl = sessionCostIsNull = session.getSessionCost().setScale(5, RoundingMode.HALF_EVEN).compareTo(BigDecimal.ZERO) == 0;
            if (!sessionCostIsNull) {
                logger.debug("balanceOverLimit: {}; session.getRoundedSessionTime(): {}; session.getSessionTime(): {}; session.getSessionCost(): {}", (Object)balanceOverLimit, (Object)session.getRoundedSessionTime(), (Object)session.getSessionTime(), (Object)session.getSessionCost());
                BigDecimal maxTime = balanceOverLimit.multiply(new BigDecimal(60)).divide(session.getSessionCost(), 0, RoundingMode.FLOOR);
                logger.debug("maxTime: {}", (Object)maxTime);
                this.maxSessionTime = maxTime.intValue();
                if (this.maxSessionTime < 0) {
                    this.maxSessionTime = Integer.MAX_VALUE;
                }
                if (this.maxSessionTime == 0) {
                    return AccessCode.BALANCE_INSUFFICIENT.getCode();
                }
            }
            if ((creditTime = nas.getCreditTime(response)) == 0 || creditTime > this.maxSessionTime) {
                nas.setCreditTime(response, this.maxSessionTime);
                nas.setCreditAmount(response, balanceOverLimit);
            }
            return result;
        }

        public Set<Integer> getOptions() {
            return this.options;
        }
    }
}

