/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class PacketCountFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private static final int LESS = 1;
    private static final int LESS_OR_EQ = 2;
    private static final int EQ = 3;
    private static final int MORE_OR_EQ = 4;
    private static final int MORE = 5;
    private int packetCount = -1;
    private int compare = -1;
    private boolean exclude_discount_ignore = false;
    private boolean only_current_packet = false;
    private boolean on_contract_total = false;

    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map dataHash = this.getDataInHash();
        this.packetCount = Utils.parseInt((String)((String)dataHash.get("packet_count")), (int)1);
        String compare = (String)dataHash.get("compare");
        if ("<".equals(compare)) {
            this.compare = 1;
        } else if ("<=".equals(compare)) {
            this.compare = 2;
        } else if ("=".equals(compare)) {
            this.compare = 3;
        } else if (">=".equals(compare)) {
            this.compare = 4;
        } else if (">".equals(compare)) {
            this.compare = 5;
        }
        this.exclude_discount_ignore = Utils.parseBoolean((String)((String)dataHash.get("exclude_discount_ignore")));
        this.only_current_packet = Utils.parseBoolean((String)((String)dataHash.get("only_current_packet")));
        this.on_contract_total = Utils.parseBoolean((String)((String)dataHash.get("on_contract_total")));
    }

    public void processRequest(TariffRequest request) {
        Integer packetCount = (Integer)request.getRequestParam("packet_count");
        Integer packetMinus = (Integer)request.getRequestParam("packet_minus");
        Integer packetCount_oncontract = (Integer)request.getRequestParam("packet_count_oncontract");
        Integer packetMinus_oncontract = (Integer)request.getRequestParam("packet_minus_oncontract");
        Integer packetCount_current_oncontract = (Integer)request.getRequestParam("packet_count_current_oncontract");
        Integer packetMinus_current_oncontract = (Integer)request.getRequestParam("packet_minus_current_oncontract");
        if (this.on_contract_total) {
            if (this.only_current_packet) {
                packetCount = packetCount_current_oncontract;
                packetMinus = packetMinus_current_oncontract;
            } else {
                packetCount = packetCount_oncontract;
                packetMinus = packetMinus_oncontract;
            }
        }
        if (packetCount == null) {
            packetCount = 0;
        }
        if (packetMinus == null) {
            packetMinus = 0;
        }
        if (this.exclude_discount_ignore) {
            packetCount = packetCount - packetMinus;
        }
        if (packetCount >= 0) {
            boolean check = false;
            switch (this.compare) {
                case 1: {
                    check = packetCount < this.packetCount;
                    break;
                }
                case 2: {
                    check = packetCount <= this.packetCount;
                    break;
                }
                case 3: {
                    check = packetCount == this.packetCount;
                    break;
                }
                case 4: {
                    check = packetCount >= this.packetCount;
                    break;
                }
                case 5: {
                    boolean bl = check = packetCount > this.packetCount;
                }
            }
            if (check) {
                this.processForChilds(request);
            }
        }
    }
}

