/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.contract;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTextArea;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.plugins.dispatch.client.common.DispatchMessageStatisticPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.common.SchedulePane;
import ru.bitel.bgbilling.plugins.dispatch.client.contract.ContractDispatchConditionsPanel;
import ru.bitel.bgbilling.plugins.dispatch.client.contract.DaysOfWeekSchedulePane;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.service.DispatchService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.ScheduleTime;

public class ContractDispatchPanel
extends BGUPanel {
    private DispatchService dispatchService = null;
    private SubscriptionTableModel model = new SubscriptionTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.model));
    private DispatchMessageStatisticPanel statisticPanel = new DispatchMessageStatisticPanel();
    private JPanel mainPanel;
    private CardLayout switchLayout = new CardLayout();

    protected void jbInit() {
        this.table.setName("dispatch_subscribe");
        this.mainPanel = new JPanel(this.switchLayout);
        this.mainPanel.add((Component)new JScrollPane((Component)this.table), "table");
        this.mainPanel.add((Component)((Object)this.statisticPanel), "statistic");
        this.setLayout(new GridBagLayout());
        this.add(this.mainPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
    }

    private DispatchService getDispatchService() {
        if (this.dispatchService == null) {
            this.dispatchService = (DispatchService)((ClientContext)this.getContext()).getPort(DispatchService.class);
        }
        return this.dispatchService;
    }

    private Subscription getCurrentAndCheck() throws BGException {
        Subscription subscription = (Subscription)this.model.getSelectedRow();
        if (subscription == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
            throw new BGException();
        }
        return subscription;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(this.getDispatchService().getSubscriptions(0, ((ClientContext)this.getContext()).getContractId()))));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            Subscription subscription = new Subscription();
            subscription.setSubscriptionPeriod(new Period(new Date(), null));
            new SubscriptionDialog("\u041d\u043e\u0432\u0430\u044f \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0430", subscription).open();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> new SubscriptionDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438", this.getCurrentAndCheck()).open());
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Subscription current = this.getCurrentAndCheck();
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u043d\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                this.getDispatchService().deleteSubscription(current.getId());
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.MenuAction("dispatch_subscribe.show_stat", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                Subscription selectedRow = (Subscription)ContractDispatchPanel.this.model.getSelectedRow();
                if (selectedRow != null) {
                    ContractDispatchPanel.this.switchLayout.show(ContractDispatchPanel.this.mainPanel, "statistic");
                    ContractDispatchPanel.this.statisticPanel.setDispatch(selectedRow.getDispatch());
                    ContractDispatchPanel.this.statisticPanel.setContractId(selectedRow.getContractId());
                    ContractDispatchPanel.this.statisticPanel.performAction("refresh");
                }
            }
        };
    }

    class SubscriptionTableModel
    extends BGTableModel<Subscription> {
        public SubscriptionTableModel() {
            super(SubscriptionTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", 100, 100, 100, "active", true);
            this.addColumn("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430", 100, -1, -1, "dispatchTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 200, 250, "subscriptionPeriod", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Subscription subscription, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "dispatchTitle": {
                    return subscription.getDispatch().getTitle();
                }
            }
            return super.getValue((Object)subscription, column);
        }
    }

    class SubscriptionDialog
    extends BGEditorDialog<Subscription> {
        private BGUComboBox<Dispatch> dispatchBox;
        private JCheckBox activeCheckBox;
        private BGControlPanelPeriod periodPanel;
        private SchedulePane schedulePane;
        private List<Contact> contactList;
        private BGTextArea commentArea;
        private BGControlPanelListSelect subscribedContacts;
        private ContractDispatchConditionsPanel conditionPanel;

        public SubscriptionDialog(String title, Subscription data) {
            super(title, (Object)data);
            this.dispatchBox = new BGUComboBox();
            this.activeCheckBox = new JCheckBox("\u0430\u043a\u0442\u0438\u0432\u043d\u0430");
            this.periodPanel = new BGControlPanelPeriod();
            this.schedulePane = new DaysOfWeekSchedulePane();
            this.contactList = new ArrayList<Contact>();
            this.commentArea = new BGTextArea();
            this.subscribedContacts = new BGControlPanelListSelect();
            this.conditionPanel = new ContractDispatchConditionsPanel((ClientContext)ContractDispatchPanel.this.getContext());
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.getBasePanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 3, 5, 3), 0, 0));
            this.panel.add((Component)this.getContactPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 5, 3), 0, 0));
            boolean editMode = ((Subscription)this.data).getId() < 1;
            Dispatch dispatch = ((Subscription)this.data).getDispatch();
            if (dispatch != null) {
                if (dispatch.isPersonal()) {
                    this.panel.add((Component)((Object)this.conditionPanel), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 5, 3), 0, 0));
                    this.conditionPanel.loadFromDispatch(dispatch);
                    this.conditionPanel.setPreferences(((Subscription)this.data).getPreferences());
                }
                this.dispatchBox.setSelectedItem((Object)dispatch);
                this.dispatchBox.setEnabled(editMode);
                this.activeCheckBox.setSelected(((Subscription)this.data).isActive());
                this.schedulePane.setVisible(dispatch.isPersonal());
                this.schedulePane.setTime(((Subscription)this.data).getRepeatTime());
                this.commentArea.setText(((Subscription)this.data).getComment());
                this.periodPanel.setPeriod(((Subscription)this.data).getSubscriptionPeriod());
            }
            if (editMode) {
                this.dispatchBox.addActionListener(event -> {
                    Dispatch dispatch1 = (Dispatch)this.dispatchBox.getSelectedItem();
                    boolean selected = dispatch1.getId() > 0;
                    this.activeCheckBox.setEnabled(selected);
                    this.subscribedContacts.setEnabled(selected);
                    this.commentArea.setEnabled(selected);
                    if (selected) {
                        if (this.dispatchBox.isEnabled()) {
                            this.conditionPanel.loadFromDispatch(dispatch1);
                        }
                        if (!dispatch1.isPersonal()) {
                            this.conditionPanel.clear();
                        }
                        this.subscribedContacts.setEnabled(!dispatch1.isWoContactType());
                        this.subscribedContactsRefreshFilter(((Subscription)this.data).getContacts());
                    } else {
                        this.subscribedContacts.getList().setModel(new DefaultListModel());
                    }
                });
            } else {
                this.subscribedContactsRefreshFilter(((Subscription)this.data).getContacts());
            }
        }

        public boolean doApply() throws Exception {
            Dispatch selectedDispatch = (Dispatch)this.dispatchBox.getSelectedItem();
            if (selectedDispatch.getId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443!");
                return false;
            }
            Period period = this.periodPanel.getPeriod();
            if (period.getDateTo() != null && period.getDateFrom() != null && TimeUtils.dateBefore((Date)period.getDateTo(), (Date)period.getDateFrom())) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e, \u0447\u0442\u043e\u0431\u044b \u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0431\u044b\u043b\u0430 \u043f\u043e\u0441\u043b\u0435 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f!");
                return false;
            }
            if (selectedDispatch.isPersonal()) {
                ((Subscription)this.data).setRepeatTime(this.schedulePane.getTime());
            }
            boolean flag = true;
            ArrayList<Contact> list = new ArrayList<Contact>();
            for (int id : this.subscribedContacts.getSelectedIds()) {
                for (Contact contact : this.contactList) {
                    if (contact.getId() >= 0) {
                        if (contact.getId() != id) continue;
                        list.add(contact);
                        continue;
                    }
                    flag = false;
                }
            }
            if (flag && list.isEmpty() && !selectedDispatch.isWoContactType()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b.");
                return false;
            }
            ((Subscription)this.data).setContacts(list);
            ((Subscription)this.data).setDispatch(selectedDispatch);
            ((Subscription)this.data).setActive(this.activeCheckBox.isSelected());
            ((Subscription)this.data).setContractId(((ClientContext)ContractDispatchPanel.this.getContext()).getContractId());
            ((Subscription)this.data).setComment(this.commentArea.getText());
            ((Subscription)this.data).setPreferences(this.conditionPanel.getPreferences());
            ((Subscription)this.data).setSubscriptionPeriod(period);
            ContractDispatchPanel.this.getDispatchService().updateSubscriptions((Subscription)this.data);
            ContractDispatchPanel.this.performAction("refresh");
            return super.doApply();
        }

        private JPanel getBasePanel() {
            this.schedulePane.setVisible(false);
            this.schedulePane.setTime(this.getDefaultPersonalTime());
            this.schedulePane.setBorder((Border)new BGTitleBorder("\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438"));
            try {
                Dispatch dispatch = new Dispatch();
                dispatch.setId(-1);
                dispatch.setTitle("-- \u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0443 --");
                List dispatches = ContractDispatchPanel.this.getDispatchService().getDispatchList();
                dispatches.add(0, dispatch);
                this.dispatchBox.setData(dispatches);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)this.dispatchBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)this.activeCheckBox, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.periodPanel, (String)"\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)this.schedulePane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
            panel.add((Component)this.getCommentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 3, 0, 3), 0, 0));
            return panel;
        }

        private JPanel getContactPanel() {
            Dimension dimension = new Dimension(300, 200);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(dimension);
            panel.setPreferredSize(dimension);
            panel.setBorder((Border)new BGTitleBorder("\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b"));
            panel.add((Component)this.subscribedContacts, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getCommentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
            panel.setMinimumSize(new Dimension(100, 100));
            panel.setPreferredSize(new Dimension(100, 150));
            panel.add((Component)new JScrollPane((Component)this.commentArea), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
            return panel;
        }

        private void subscribedContactsRefreshFilter(List<Contact> selected) {
            DefaultListModel<BGUListItem> contactListModel = new DefaultListModel<BGUListItem>();
            Dispatch selectedDispatch = (Dispatch)this.dispatchBox.getSelectedItem();
            int contactTypeId = selectedDispatch.getContactTypeId();
            try {
                this.contactList = ContractDispatchPanel.this.getDispatchService().getContacts(((ClientContext)ContractDispatchPanel.this.getContext()).getContractId(), selectedDispatch);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            for (Contact contact : this.contactList) {
                if (contact.getContactTypeId() != contactTypeId) continue;
                BGUListItem listItem = new BGUListItem(contact.getId(), contact.toString());
                if (contact.getId() == -1) {
                    listItem.setSelected(true);
                    this.subscribedContacts.setEnabled(false);
                } else {
                    listItem.setSelected(selected.contains(contact));
                }
                contactListModel.addElement(listItem);
            }
            if (this.contactList != null && this.contactList.size() > 0 && this.contactList.get(0).getId() == -1) {
                contactListModel.add(0, new BGUListItem(-1, "--\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u044b \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430--", true));
            }
            this.subscribedContacts.getList().setModel(contactListModel);
        }

        private ScheduleTime getDefaultPersonalTime() {
            int DEFAULT_HOURS = 21;
            boolean DEFAULT_MINUTES = false;
            int packedHours = (int)Utils.packValues((Collection)Utils.toList((String)String.valueOf(21)), (int)0);
            int packedMinutes = (int)Utils.packValues((Collection)Utils.toList((String)String.valueOf(0)), (int)0);
            return new ScheduleTime(0, 0, packedHours, 0, (long)packedMinutes);
        }
    }
}

