/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionHelpDeskPackage
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String command = this.getParameter("command", "activetopic");
        Element packageElement = this.createElement(this.rootNode, "packages");
        PackageManager packageManager = new PackageManager(this.con, this.plugin);
        if (command.equals("packageadd")) {
            int packageId = this.getIntParameter("packageId", -1);
            if (packageId < 0) {
                this.setError(packageElement, "packageIdNotFound");
            } else {
                Package pkg = packageManager.getPackage(packageId);
                if (pkg == null) {
                    this.setError(packageElement, "packageNotFound");
                } else if (!pkg.isStatus()) {
                    this.setError(packageElement, "packageStatusDisabled");
                } else {
                    BalanceUtils bu = new BalanceUtils(this.con);
                    BigDecimal balance = bu.getBalance(LocalDate.now(), this.cid);
                    if (balance.compareTo(pkg.getSumma()) == -1) {
                        this.setError(packageElement, "balanceNotValid");
                    } else {
                        Date now = new Date();
                        Charge charge = new Charge();
                        charge.setContractId(this.cid);
                        charge.setDate(now);
                        charge.setTypeId(pkg.getChargeId());
                        charge.setSum(pkg.getSumma());
                        charge.setComment(pkg.getTitle() + " [" + pkg.getCount() + "\u043e\u0431\u0440. \u0437\u0430 " + pkg.getPeriod() + "\u0434\u043d.]");
                        try (ChargeDao chargeDao = new ChargeDao(this.con);){
                            chargeDao.update((Object)charge);
                        }
                        PackageContract packageContract = new PackageContract();
                        packageContract.setId(-1);
                        packageContract.setChargeId(charge.getId());
                        packageContract.setContractId(this.cid);
                        packageContract.setPackageId(pkg.getId());
                        packageContract.setCount(pkg.getCount());
                        packageContract.setCountUse(0);
                        packageContract.setDateFrom(now);
                        packageContract.setDateTo(new Date(now.getTime() + 86400000L * (long)pkg.getPeriod()));
                        packageContract.setSumma(pkg.getSumma());
                        packageContract.setUserId(-1);
                        packageManager.updatePackageContract(packageContract);
                        ServerUtils.commitConnection((Connection)this.con);
                        bu.updateBalance(now, this.cid);
                    }
                    bu.close();
                }
            }
        }
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(this.getPage());
        packageManager.findPackageContractList((SearchResult<PackageContract>)searchResult, this.cid);
        Element tableElement = this.createElement(packageElement, "tablePackageContract");
        for (PackageContract pkg : searchResult.getList()) {
            Element row = this.createElement(tableElement, "row");
            row.setAttribute("id", String.valueOf(pkg.getId()));
            row.setAttribute("active", String.valueOf(this.isActivePackage(pkg)));
            row.setAttribute("period", TimeUtils.formatPeriod((Date)pkg.getDateFrom(), (Date)pkg.getDateTo()));
            row.setAttribute("summa", pkg.getSumma().toPlainString());
            row.setAttribute("count", String.valueOf(pkg.getCount()) + " [" + String.valueOf(pkg.getCountUse()) + "]");
            row.setAttribute("user", String.valueOf(pkg.getUserId() > 0));
        }
        SearchResult searchResult1 = new SearchResult();
        searchResult1.setPage(new Page(1, 0));
        packageManager.findPackageList((SearchResult<Package>)searchResult1, Boolean.TRUE);
        tableElement = this.createElement(packageElement, "tablePackage");
        for (Package pkg : searchResult1.getList()) {
            GregorianCalendar now = new GregorianCalendar();
            StringBuilder period = new StringBuilder();
            Element row = this.createElement(tableElement, "row");
            period.append(TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy"));
            period.append("-");
            ((Calendar)now).add(5, pkg.getPeriod());
            period.append(TimeUtils.format((Calendar)now, (String)"dd.MM.yyyy"));
            row.setAttribute("id", String.valueOf(pkg.getId()));
            row.setAttribute("title", String.valueOf(pkg.getTitle()));
            row.setAttribute("formatPeriod", period.toString());
            row.setAttribute("period", String.valueOf(pkg.getPeriod()));
            row.setAttribute("summa", pkg.getSumma().toPlainString());
            row.setAttribute("count", String.valueOf(pkg.getCount()));
        }
    }

    private boolean isActivePackage(PackageContract pkg) {
        boolean flag = false;
        if (pkg != null) {
            Date now = new Date();
            flag = pkg.getDateFrom() == null || now.after(pkg.getDateFrom());
            flag = flag && pkg.getDateTo() == null || now.before(pkg.getDateTo());
            flag = flag && pkg.getCountUse() < pkg.getCount();
        }
        return flag;
    }

    private void setError(Element packageElement, String errorId) {
        Element errorElement = this.createElement(packageElement, "error");
        errorElement.setAttribute("id", errorId);
    }
}

