/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.event.InetConnectionAliveEvent;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.util.FrequencyCounter;

public class ConnectionAliveEventWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Iterable<? extends InetConnectionRuntime> sessions;
    private Iterator<? extends InetConnectionRuntime> iterator;
    private final FrequencyCounter sentPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final long lockTimeout;
    private final PoolEventPublisher<InetConnectionAliveEvent> eventPublisher;

    public ConnectionAliveEventWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, Iterable<? extends InetConnectionRuntime> sessions) {
        super(scheduledExecutorService, name, params);
        logger.info("Add connection alive event worker: delay=" + this.getDelay() + ", batchSize=" + this.batchSize);
        this.accounting = accounting;
        this.sessions = sessions;
        this.lockTimeout = params.getLong("lockTimeout", 2000L);
        this.eventPublisher = EventProcessor.getInstance().newPoolEventPublisher(InetConnectionAliveEvent.class, accounting.moduleId, 50, 500L);
    }

    protected void runImpl() throws BGException {
        logger.trace("Run connection alive event worker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.sessions.iterator();
        }
        long millis = System.currentTimeMillis();
        int count = 0;
        int batchSize = this.batchSize;
        while (count < batchSize && this.iterator.hasNext()) {
            InetConnectionRuntime connectionRuntime = this.iterator.next();
            if (!this.process(this.accounting, connectionRuntime, this.lockTimeout)) continue;
            ++count;
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.sentPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug("Tracked " + count + " sessions for " + duration + " ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Accounting accounting, InetConnectionRuntime connectionRuntime, long lockTimeout) throws BGException {
        InetConnection connection;
        block18: {
            if (connectionRuntime.calculateType != 0) {
                return false;
            }
            connection = connectionRuntime.connection;
            if (connection == null) {
                return false;
            }
            if (connectionRuntime.isServiceSession()) {
                return false;
            }
            if (connection.getConnectionStatus() != 1) {
                return false;
            }
            if (accounting.getDisableServIds().contains(connectionRuntime.inetServId)) {
                if (!connectionRuntime.inetServRuntime.tryLock()) {
                    return false;
                }
            } else {
                if (lockTimeout > 0L) {
                    try {
                        if (!connectionRuntime.inetServRuntime.tryLock(lockTimeout, TimeUnit.MILLISECONDS)) {
                            return false;
                        }
                        break block18;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                connectionRuntime.inetServRuntime.lock();
            }
        }
        try {
            if (connection.getConnectionStatus() != 1) {
                boolean bl = false;
                return bl;
            }
            if (connectionRuntime.connection == null) {
                boolean bl = false;
                return bl;
            }
            this.eventPublisher.publish((Event)new InetConnectionAliveEvent(this.eventPublisher, connectionRuntime.contractId, connection));
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    @MBeanAttribute
    public long getSentPerMinute() {
        return this.sentPerMinute.get(System.currentTimeMillis());
    }
}

