/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.DhcpDisableMode;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.dhcp.DhcpNetOptions;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.ServSearchResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Idable;
import ru.bitel.common.util.Matcher;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceReserveManager;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

public class InetDhcpDevice
implements Idable {
    private static final Logger logger = LogManager.getLogger();
    public static final int DEVICE_SEARCH_MODE_REMOTE_ID_SUB_PREPROCESS = 0;
    public static final int DEVICE_SEARCH_MODE_REMOTE_ID_SUB = 1;
    public static final int DEVICE_SEARCH_MODE_GIADDR = 2;
    public final InetDeviceRuntime deviceRuntime;
    private final Access access;
    protected final DhcpOption serverIdentifier;
    protected final byte[] filterServerIdentifier;
    private final Set<Integer> ipResourceCategoryIds;
    private IpResourceReserveManager ipReserveManager;
    private final DhcpDisableMode dhcpDisableMode;
    private IpResourceReserveManager ipDisableReserveManager;
    private final Map<Integer, LinkedHashSet<Integer>> optionIpCategoriesMap = new HashMap<Integer, LinkedHashSet<Integer>>();
    private final Map<Integer, IpResourceReserveManager> optionReserveManagerMap = new HashMap<Integer, IpResourceReserveManager>();
    public final int deviceSearchMode;
    public final int[][] servSearchModes;
    @Deprecated
    public final int servSearchMode2;
    public final int[][] radiusServSearchModes;
    public final Set<Integer> radiusServSearchModeSet;
    public final boolean alwaysBroadcast;
    protected final int additionalUnauthorizedSessionCount;
    private final DhcpParams dhcpParams;
    private final DhcpParams dhcpRenewParams;
    private final Map<Integer, DhcpParams> inetOptionDhcpParamsMap = new HashMap<Integer, DhcpParams>();
    private DhcpNetOptions netParams;
    public final String dhcpKeyPattern;
    public final boolean dhcpConnectionCloseOnNew;
    private final int checkDuplicateSession;
    public final int dhcpOfferRandomDelay;
    public final long dhcpOfferTimeout;
    public final long dhcpBanCheckTimeout;
    public final long dhcpBanDiscoverCount;
    public final long dhcpBanTimeout;
    public final boolean dhcpInfoReq;
    private final List<Integer> disableServIds;
    private final boolean option82Required;
    private final int asyncAccountingStart;
    private final boolean saveLogin;
    private final boolean startFromRequest;

    public InetDhcpDevice(Access access, InetOptionRuntimeMap inetOptionRuntimeMap, InetDeviceRuntime device) {
        LinkedHashSet<Integer> categories;
        this.access = access;
        ParameterMap deviceConfig = device.config;
        this.deviceRuntime = device;
        this.serverIdentifier = DhcpOption.parseOption((int)54, (String)deviceConfig.get("dhcp.serverIdentifier", null));
        DhcpOption filterServerIdentifier = DhcpOption.parseOption((int)54, (String)deviceConfig.get("dhcp.filter.serverIdentifier", null));
        this.filterServerIdentifier = (byte[])(filterServerIdentifier != null ? filterServerIdentifier.value : null);
        LinkedHashSet<Object> ipResourceCategoryIds = new LinkedHashSet();
        IpResourceReserveManager ipReserveManager = null;
        String pool = deviceConfig.get("dhcp.ipPool", null);
        if (Utils.notBlankString((String)pool) && (categories = this.deviceRuntime.getIpPoolCategoryIds(pool)) != null && categories.size() > 0) {
            ipResourceCategoryIds = categories;
            ipReserveManager = this.deviceRuntime.getIpPool(pool);
        }
        if ((categories = new LinkedHashSet(Utils.toIntegerList((String)deviceConfig.get("dhcp.ipCategories", deviceConfig.get("pool", ""))))) != null && categories.size() > 0) {
            ipResourceCategoryIds = categories;
            ipReserveManager = access.ipResourceManager.getReserveManager(ipResourceCategoryIds, "dhcp.ipCategories");
        }
        this.ipResourceCategoryIds = ipResourceCategoryIds;
        this.ipReserveManager = ipReserveManager;
        ipResourceCategoryIds = new LinkedHashSet();
        ipReserveManager = null;
        this.dhcpDisableMode = DhcpDisableMode.valueOf((int)deviceConfig.getInt("dhcp.disable.mode", 0));
        pool = deviceConfig.get("dhcp.disable.ipPool", null);
        if (Utils.notBlankString((String)pool) && (categories = this.deviceRuntime.getIpPoolCategoryIds(pool)) != null && categories.size() > 0) {
            ipResourceCategoryIds = categories;
            ipReserveManager = this.deviceRuntime.getIpPool(pool);
        }
        if ((categories = new LinkedHashSet(Utils.toIntegerList((String)deviceConfig.get("dhcp.disable.ipCategories", deviceConfig.get("pool", ""))))) != null && categories.size() > 0) {
            ipResourceCategoryIds = categories;
            ipReserveManager = access.ipResourceManager.getReserveManager(ipResourceCategoryIds, "dhcp.disable.ipCategories");
        }
        this.ipDisableReserveManager = ipReserveManager;
        ipResourceCategoryIds = new LinkedHashSet();
        ipReserveManager = null;
        this.deviceSearchMode = deviceConfig.getInt("dhcp.deviceSearchMode", 1);
        this.servSearchModes = InetUtils.parseSearchModes(deviceConfig.get("dhcp.servSearchMode", deviceConfig.get("dhcp.serviceSearchMode", String.valueOf(1))));
        this.servSearchMode2 = deviceConfig.getInt("radius.servSearchMode", deviceConfig.getInt("radius.serviceSearchMode", 0));
        this.radiusServSearchModes = InetUtils.parseSearchModes(deviceConfig.get("radius.servSearchMode", deviceConfig.get("radius.serviceSearchMode", String.valueOf(0))));
        this.radiusServSearchModeSet = new HashSet<Integer>();
        for (int[] s : this.radiusServSearchModes) {
            this.radiusServSearchModeSet.add(s[0]);
        }
        this.additionalUnauthorizedSessionCount = deviceConfig.getInt("dhcp.additionalUnauthorizedSessionCount", 2);
        this.netParams = new DhcpNetOptions(deviceConfig, "dhcp.net.option.");
        this.dhcpKeyPattern = deviceConfig.get("dhcp.key.pattern", "$deviceId:$remoteId:$circuitId:$mac");
        this.dhcpConnectionCloseOnNew = deviceConfig.getInt("dhcp.connection.closeOnNew", 0) > 0;
        this.dhcpParams = this.loadOptionList("dhcp.", deviceConfig);
        this.dhcpRenewParams = this.loadOptionList("dhcp.renew.", deviceConfig);
        Object object = deviceConfig.subIndexed("dhcp.inetOption.").entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry e = (Map.Entry)object.next();
            Integer inetOptionId = (Integer)e.getKey();
            DhcpParams dhcpParams = this.loadOptionList("", (ParameterMap)e.getValue());
            this.inetOptionDhcpParamsMap.put(inetOptionId, dhcpParams);
        }
        this.loadOptionIpPools(inetOptionRuntimeMap, device, deviceConfig);
        this.alwaysBroadcast = deviceConfig.getInt("dhcp.alwaysBroadcast", 0) > 0;
        this.dhcpOfferRandomDelay = deviceConfig.getInt("dhcp.offer.randomDelay", 0) / 5;
        this.dhcpOfferTimeout = TimeUnit.SECONDS.toMillis(deviceConfig.getInt("dhcp.offer.timeout", 30));
        this.dhcpBanCheckTimeout = TimeUnit.SECONDS.toMillis(deviceConfig.getInt("dhcp.ban.checkTimeout", 120));
        this.dhcpBanDiscoverCount = deviceConfig.getInt("dhcp.ban.ipOfferCount", deviceConfig.getInt("dhcp.ban.discoverCount", 10));
        this.dhcpBanTimeout = TimeUnit.SECONDS.toMillis(deviceConfig.getInt("dhcp.ban.timeout", 1800));
        this.dhcpInfoReq = deviceConfig.getInt("dhcp.offer.infoDiscover", 1) > 0;
        List disableServIds = Utils.toIntegerList((String)deviceConfig.get("dhcp.disable.servId", ""));
        disableServIds.remove((Object)0);
        if (disableServIds.size() == 0) {
            this.disableServIds = Collections.emptyList();
        } else if (disableServIds.size() == 1) {
            this.disableServIds = Collections.singletonList((Integer)disableServIds.get(0));
        } else {
            this.disableServIds = disableServIds;
            Collections.sort(disableServIds);
        }
        this.checkDuplicateSession = deviceConfig.getInt("dhcp.connection.checkDuplicate", 0);
        this.option82Required = deviceConfig.getInt("dhcp.option82.required", 1) > 0;
        this.asyncAccountingStart = deviceConfig.getInt("dhcp.connection.asyncStart", 0);
        this.saveLogin = deviceConfig.getInt("dhcp.option82.login.save", 0) > 0;
        this.startFromRequest = deviceConfig.getInt("dhcp.connection.startFromRequest", 0) > 0;
    }

    public Set<Integer> getIpResourceCategoryIds() {
        return this.ipResourceCategoryIds;
    }

    private DhcpParams loadOptionList(String prefix, ParameterMap params) {
        byte[] siaddr;
        byte[] file;
        String fileString = params.get(prefix + "file", null);
        String siaddrString = params.get(prefix + "siaddr", null);
        if (Utils.isBlankString((String)fileString)) {
            file = null;
        } else {
            try {
                file = fileString.startsWith("0x") ? Utils.stringToBytes((String)fileString.substring(2), null) : fileString.getBytes("UTF-8");
            }
            catch (Exception ex) {
                file = null;
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (Utils.isBlankString((String)siaddrString)) {
            siaddr = null;
        } else {
            try {
                siaddr = siaddrString.startsWith("0x") ? Utils.stringToBytes((String)siaddrString.substring(2), null) : InetAddress.getByName(siaddrString).getAddress();
            }
            catch (Exception ex) {
                siaddr = null;
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        DhcpParams result = new DhcpParams(siaddr, file);
        for (Map.Entry e : params.sub(prefix + "option.").entrySet()) {
            DhcpOption option = DhcpOption.parseOption((String)((String)e.getKey()), (String)((String)e.getValue()));
            if (option == null) continue;
            result.optionList.add(option);
        }
        return result;
    }

    private void loadOptionIpPools(InetOptionRuntimeMap optionRuntimeMap, InetDeviceRuntime deviceRuntime, ParameterMap conf) {
        IpResourceReserveManager reserveManager;
        String pool;
        Object option;
        for (Map.Entry<Integer, InetOptionRuntime> entry : optionRuntimeMap.getMap().entrySet()) {
            option = entry.getValue();
            pool = ((InetOptionRuntime)option).inheritedConfig.get("dhcp.ipPool", null);
            if (Utils.isBlankString((String)pool)) continue;
            this.optionIpCategoriesMap.put(((InetOptionRuntime)option).id, deviceRuntime.getIpPoolCategoryIds(pool));
            reserveManager = deviceRuntime.getIpPool(pool);
            if (reserveManager == null) continue;
            this.optionReserveManagerMap.put(entry.getKey(), reserveManager);
        }
        for (Map.Entry<Integer, InetOptionRuntime> entry : conf.subIndexed("dhcp.inetOption.").entrySet()) {
            option = entry.getKey();
            pool = ((ParameterMap)entry.getValue()).get("ipPool", null);
            if (Utils.isBlankString((String)pool)) continue;
            this.optionIpCategoriesMap.put((Integer)option, deviceRuntime.getIpPoolCategoryIds(pool));
            reserveManager = deviceRuntime.getIpPool(pool);
            if (reserveManager == null) continue;
            this.optionReserveManagerMap.put((Integer)option, reserveManager);
        }
    }

    public ServSearchResult findServRuntime(final DhcpPacket request, DhcpListenerWorker<InetDhcpDevice> req) {
        try {
            Date date = new Date();
            for (int[] servSearchMode : this.servSearchModes) {
                InetServRuntime result;
                switch (servSearchMode[0]) {
                    case 1: {
                        int interfaceId = this.deviceRuntime.getOption82InterfaceId(request);
                        if (logger.isInfoEnabled()) {
                            logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + "; servSearchMode: " + servSearchMode[0] + "; interfaceId: " + interfaceId);
                        }
                        result = this.access.inetServRuntimeMap.getByDevicePort(this.deviceRuntime.inetDevice.getId(), interfaceId, date, null);
                        req.circuitId = String.valueOf(interfaceId);
                        break;
                    }
                    case 2: {
                        int vlanId = this.deviceRuntime.getOption82VlanId(request);
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + "; servSearchMode: " + servSearchMode[0] + "; vlanId: " + vlanId);
                        result = this.access.inetServRuntimeMap.getByDeviceVlan(this.deviceRuntime.inetDevice.getId(), vlanId, date, false);
                        req.circuitId = String.valueOf(vlanId);
                        break;
                    }
                    case 3: {
                        int interfaceId = this.deviceRuntime.getOption82InterfaceId(request);
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + "; servSearchMode: " + servSearchMode[0] + "; interfaceId: " + interfaceId + " with mac " + MACParser.macAddressToString((byte[])request.chaddr));
                        Matcher<InetServRuntime> matcher = new Matcher<InetServRuntime>(){

                            public boolean matched(InetServRuntime x) {
                                return !Boolean.FALSE.equals(InetUtils.checkMacAddress(x.getInetServ(), request.chaddr));
                            }
                        };
                        result = this.access.inetServRuntimeMap.getByDevicePort(this.deviceRuntime.inetDevice.getId(), interfaceId, date, matcher);
                        req.circuitId = String.valueOf(interfaceId);
                        break;
                    }
                    case 12: {
                        int interfaceId = this.deviceRuntime.getOption82InterfaceId(request);
                        final int vlanId = this.deviceRuntime.getOption82VlanId(request);
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + "; servSearchMode: " + servSearchMode[0] + "; interfaceId: " + interfaceId + " with vlan " + vlanId);
                        Matcher<InetServRuntime> matcher = new Matcher<InetServRuntime>(){

                            public boolean matched(InetServRuntime x) {
                                return x.getInetServ().getVlan() == vlanId;
                            }
                        };
                        result = this.access.inetServRuntimeMap.getByDevicePort(this.deviceRuntime.inetDevice.getId(), interfaceId, date, matcher);
                        req.circuitId = String.valueOf(vlanId) + "_" + String.valueOf(interfaceId);
                        break;
                    }
                    case 4: {
                        int vlanId = this.deviceRuntime.getOption82VlanId(request);
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + "; servSearchMode: " + servSearchMode[0] + "; vlanId: " + vlanId);
                        result = this.access.inetServRuntimeMap.getByDeviceVlan(this.deviceRuntime.inetDevice.getId(), vlanId, date, true);
                        req.circuitId = String.valueOf(vlanId);
                        break;
                    }
                    case 5: {
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + "; servSearchMode: " + servSearchMode[0] + "; by mac: " + MACParser.macAddressToString((byte[])request.chaddr));
                        result = this.access.inetServRuntimeMap.getByMacAddress(request.chaddr, date, this.deviceRuntime.inetDevice.getId(), Collections.emptySet());
                        req.circuitId = String.valueOf(request.chaddr);
                        break;
                    }
                    case 6: 
                    case 15: {
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + " and it's descendants; servSearchMode: " + servSearchMode[0] + "; by mac: " + MACParser.macAddressToString((byte[])request.chaddr));
                        result = this.access.inetServRuntimeMap.getByMacAddress(request.chaddr, date, this.deviceRuntime.inetDevice.getId(), this.deviceRuntime.descendantIds);
                        req.circuitId = String.valueOf(request.chaddr);
                        break;
                    }
                    case 10: {
                        logger.info("Search serv on root deviceId and it's descendants; servSearchMode: " + servSearchMode[0] + "; by mac: " + MACParser.macAddressToString((byte[])request.chaddr));
                        InetDeviceRuntime rootDevice = this.access.deviceMap.get(this.access.rootDeviceId);
                        result = this.access.getInetServRuntimeMap().getByMacAddress(request.chaddr, date, rootDevice.inetDeviceId, rootDevice.descendantIds);
                        req.circuitId = String.valueOf(request.chaddr);
                        break;
                    }
                    case 11: {
                        int vlanId = this.deviceRuntime.getOption82VlanId(request);
                        logger.info("Search serv on deviceId: " + this.deviceRuntime.inetDeviceId + " and it's ancestors and descendants; servSearchMode: " + servSearchMode[0] + "; by mac and vlanId: " + MACParser.macAddressToString((byte[])request.chaddr) + " " + vlanId);
                        result = this.access.getInetServRuntimeMap().getByMacAddressAndVlan(request.chaddr, date, this.deviceRuntime.inetDevice.getId(), this.deviceRuntime.descendantIds, this.deviceRuntime.ancestorIds, vlanId);
                        req.circuitId = String.valueOf(vlanId);
                        break;
                    }
                    case 0: {
                        logger.info("Search serv LOGIN; servSearchMode: " + servSearchMode[0]);
                        result = this.findServRuntimeByLogin(request, req, date, servSearchMode, false);
                        break;
                    }
                    case 20: {
                        logger.info("Search serv LOGIN_ON_PARENT_AND_CHILD_DEVICE; servSearchMode: " + servSearchMode[0]);
                        result = this.findServRuntimeByLogin(request, req, date, servSearchMode, true);
                        break;
                    }
                    default: {
                        result = null;
                    }
                }
                if (result == null) continue;
                return this.findSubServRuntime(result, servSearchMode[1], date, request);
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private InetServRuntime findServRuntimeByLogin(DhcpPacket request, DhcpListenerWorker<InetDhcpDevice> req, Date date, int[] servSearchMode, boolean checkDevice) throws BGException {
        InetServRuntime result;
        Object loginObject = this.deviceRuntime.getOption82Login(request);
        String login = loginObject != null ? loginObject.toString() : null;
        logger.info("Search serv on root deviceId and it's descendants; " + servSearchMode[0] + "; by login " + login);
        if (login != null) {
            InetServRuntime newResult = this.access.getInetServRuntimeMap().getByUsername(login, date, true);
            if (newResult != null) {
                if (!checkDevice || this.deviceRuntime.inetDeviceId.intValue() == newResult.getInetServ().getDeviceId() || this.deviceRuntime.ancestorIds.contains(newResult.getInetServ().getDeviceId())) {
                    result = newResult;
                } else {
                    logger.info("inetServ found, but deviceId not descendant for this device");
                    result = null;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        req.circuitId = login;
        return result;
    }

    private ServSearchResult findSubServRuntime(InetServRuntime parentServRuntime, int subServSearchMode, Date time, DhcpPacket request) {
        switch (subServSearchMode) {
            case 1: {
                InetServRuntime servRuntime = this.access.getInetServRuntimeMap().getByMacAddress(parentServRuntime, request.chaddr, time.getTime());
                return new ServSearchResult(subServSearchMode, parentServRuntime, servRuntime);
            }
            case 2: {
                InetServRuntime servRuntime = this.access.getInetServRuntimeMap().getByMacAddress(parentServRuntime, request.chaddr, time.getTime());
                return new ServSearchResult(subServSearchMode, parentServRuntime, servRuntime != null ? servRuntime : parentServRuntime);
            }
        }
        return new ServSearchResult(0, parentServRuntime, parentServRuntime);
    }

    @Deprecated
    public IpResourceReserve reserveAddress(int errorCode, InetDhcpDevice relayDevice) {
        return this.reserveIP(errorCode, relayDevice, null);
    }

    public IpResourceReserve reserveIP(int accessCode, InetDhcpDevice relayDevice, Set<Integer> inetOptionIds) {
        Object reserveManager;
        if (accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
            reserveManager = this.ipReserveManager;
            IpResourceReserveManager optionResult = this.getForInetOption(inetOptionIds);
            if (optionResult != null) {
                reserveManager = optionResult;
            }
        } else {
            reserveManager = this.ipDisableReserveManager != null ? this.ipDisableReserveManager : null;
        }
        if (reserveManager == null) {
            if (relayDevice != null && relayDevice != this) {
                return relayDevice.reserveIP(accessCode, null, inetOptionIds);
            }
            return null;
        }
        return reserveManager.reserve();
    }

    private IpResourceReserveManager getForInetOption(Set<Integer> optionSet) {
        if (this.optionReserveManagerMap.size() == 0 || optionSet == null || optionSet.size() == 0) {
            return null;
        }
        if (optionSet.size() < this.optionReserveManagerMap.size()) {
            for (Integer option : optionSet) {
                IpResourceReserveManager result = this.optionReserveManagerMap.get(option);
                if (result == null) continue;
                return result;
            }
        } else {
            for (Map.Entry<Integer, IpResourceReserveManager> e : this.optionReserveManagerMap.entrySet()) {
                if (!optionSet.contains(e.getKey())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public void setOptions(IpResourceRuntimeManager ipResourceManager, int ipResourceId, DhcpPacket response, long address, Set<Integer> inetOptionIds, boolean renew) throws BGException {
        DhcpNetOptions.NetOptions netOptions;
        List optionList;
        IpResourceRuntime ipResourceRuntime;
        int i;
        if (this.dhcpParams.siaddr != null) {
            System.arraycopy(this.dhcpParams.siaddr, 0, response.siaddr, 0, Math.min(response.siaddr.length, this.dhcpParams.siaddr.length));
        }
        if (this.dhcpParams.file != null) {
            if (response.file.length > this.dhcpParams.file.length) {
                System.arraycopy(this.dhcpParams.file, 0, response.file, 0, this.dhcpParams.file.length);
                Arrays.fill(response.file, this.dhcpParams.file.length, response.file.length, (byte)0);
            } else {
                System.arraycopy(this.dhcpParams.file, 0, response.file, 0, response.file.length);
            }
        }
        int size = this.dhcpParams.optionList.size();
        for (i = 0; i < size; ++i) {
            response.setOption(this.dhcpParams.optionList.get(i));
        }
        if (renew) {
            size = this.dhcpRenewParams.optionList.size();
            for (i = 0; i < size; ++i) {
                response.setOption(this.dhcpRenewParams.optionList.get(i));
            }
        }
        if (ipResourceId > 0 && (ipResourceRuntime = ipResourceManager.getResource(Integer.valueOf(ipResourceId))) != null && (optionList = ipResourceRuntime.getDhcpOptionList()) != null) {
            int size2 = optionList.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                response.setOption((DhcpOption)optionList.get(i2));
            }
        }
        if (inetOptionIds != null) {
            for (Integer inetOptionId : inetOptionIds) {
                DhcpParams dhcpParams = this.inetOptionDhcpParamsMap.get(inetOptionId);
                if (dhcpParams == null) continue;
                if (dhcpParams.siaddr != null) {
                    response.siaddr = dhcpParams.siaddr;
                }
                if (dhcpParams.file != null) {
                    response.file = dhcpParams.file;
                }
                int size3 = dhcpParams.optionList.size();
                for (int i3 = 0; i3 < size3; ++i3) {
                    response.setOption(dhcpParams.optionList.get(i3));
                }
            }
        }
        if ((netOptions = this.netParams.getNetParams(address)) != null) {
            response.setOption(DhcpOption.parseOption((int)1, (String)IPUtils.convertLongIpToString((long)netOptions.mask)));
            int size4 = netOptions.optionList.size();
            for (int i4 = 0; i4 < size4; ++i4) {
                response.setOption(netOptions.optionList.get(i4));
            }
        }
        if (this.serverIdentifier != null) {
            response.setOption(this.serverIdentifier);
        }
    }

    public int getId() {
        return this.deviceRuntime.inetDeviceId;
    }

    public int getDisableServId(DhcpPacket request) {
        switch (this.disableServIds.size()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.disableServIds.get(0);
            }
        }
        return this.disableServIds.get(Math.abs(Long.hashCode(InetUtils.macAddressToLong(request.chaddr))) % this.disableServIds.size());
    }

    public List<Integer> getDisableServIds() {
        return this.disableServIds;
    }

    public boolean getDhcpConnectionCloseOnNew(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.dhcpConnectionCloseOnNew != null) {
            return inetServTypeRuntime.dhcpConnectionCloseOnNew;
        }
        return this.dhcpConnectionCloseOnNew;
    }

    public int getCheckDuplicateSession(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.dhcpCheckDuplicateSession != null) {
            return inetServTypeRuntime.dhcpCheckDuplicateSession;
        }
        return this.checkDuplicateSession;
    }

    public boolean isOption82Required() {
        return this.option82Required;
    }

    public int getAsyncAccountingStart() {
        return this.asyncAccountingStart;
    }

    public boolean isSaveLogin() {
        return this.saveLogin;
    }

    public boolean isStartFromRequest() {
        return this.startFromRequest;
    }

    public DhcpDisableMode getDhcpDisableMode(InetServTypeRuntime servTypeRuntime) {
        if (servTypeRuntime.getDhcpDisableMode() != DhcpDisableMode.NONE) {
            return servTypeRuntime.getDhcpDisableMode();
        }
        return this.dhcpDisableMode;
    }

    static class DhcpParams {
        private final byte[] siaddr;
        private final byte[] file;
        private final List<DhcpOption> optionList = new ArrayList<DhcpOption>();

        public DhcpParams(byte[] siaddr, byte[] file) {
            this.siaddr = siaddr;
            this.file = file;
        }
    }
}

