/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionAddressContractInfo
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        boolean isNet;
        int cid = this.getIntParameter("cid", -1);
        boolean bl = isNet = !Utils.isEmptyString((String)this.getParameter("net"));
        if (cid < 0) {
            return;
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Calendar date = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date", null));
        int objectId = this.getIntParameter("object_id", 0);
        AddressRangeManager man = new AddressRangeManager(this.con, this.mid);
        List<AddressRange> addressList = null;
        addressList = isNet ? man.getContractNets(cid, date, objectId) : man.getContractRanges(cid, date, objectId);
        for (AddressRange ar : addressList) {
            StringBuilder ifaces = man.getSourceIface(ar);
            Element row = this.createElement(data, "row");
            row.setAttribute("f0", String.valueOf(ar.getId()));
            if (!isNet) {
                row.setAttribute("f1", IPUtils.convertLongIpToString((long)ar.getAddr1()) + " - " + IPUtils.convertLongIpToString((long)ar.getAddr2()));
                row.setAttribute("address_range", IPUtils.convertLongIpToString((long)ar.getAddr1()) + " - " + IPUtils.convertLongIpToString((long)ar.getAddr2()));
            } else {
                row.setAttribute("f1", IPUtils.convertLongIpToString((long)ar.getAddr1()) + "/" + ar.getMask());
                row.setAttribute("address_range", IPUtils.convertLongIpToString((long)ar.getAddr1()) + "/" + ar.getMask());
            }
            row.setAttribute("f2", ifaces.toString());
            row.setAttribute("f3", TimeUtils.formatPeriod((Calendar)ar.getDate1(), (Calendar)ar.getDate2()));
            row.setAttribute("f4", ar.getComment());
            row.setAttribute("id", String.valueOf(ar.getId()));
            row.setAttribute("ifaces", ifaces.toString());
            row.setAttribute("period", TimeUtils.formatPeriod((Calendar)ar.getDate1(), (Calendar)ar.getDate2()));
            row.setAttribute("comment", ar.getComment());
        }
    }
}

