/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionUpdateContractPattern
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String title = this.getParameter("title");
        String mode = this.getParameter("mode");
        String tariff = this.getParameter("tariff");
        int parameter = this.getIntParameter("parameter", -1);
        String modules = this.getParameter("modules", null);
        Document data = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(modules)));
        String dataPlugins = this.getParameter("plugins", null);
        Document pluginsDoc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(dataPlugins)));
        if (pluginsDoc != null) {
            Element plugins = XMLUtils.getElement((Document)pluginsDoc, (String)"plugins");
            data.getDocumentElement().appendChild(data.importNode(plugins, true));
        }
        if (data == null) {
            data = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?><data/>")));
        }
        if (title == null || mode == null || tariff == null || parameter < 0) {
            throw new BGIllegalArgumentException();
        }
        Element dataElement = data.getDocumentElement();
        dataElement.setAttribute("webMenuId", this.getParameter("web_menu_id"));
        Element contractLabels = XMLUtils.createElement((Element)dataElement, (String)"contractLabels");
        for (Integer contractLabelId : Utils.toIntegerList((String)this.getParameter("contractLabels"))) {
            Element item = XMLUtils.createElement((Element)contractLabels, (String)"item");
            item.setAttribute("id", contractLabelId.toString());
        }
        ContractPattern pattern = ContractPattern.builder().setClosesumma(this.getBigDecimalParameter("limit", BigDecimal.ZERO)).setLimitMode("on".equals(this.getParameter("limitMode")) ? "on" : "off").setMode(mode.equals("1") ? 1 : 0).setFc(this.getIntParameter("face", 0)).setTitle(title).setParamsGroupId(parameter).setDaysToLive(this.getIntParameter("dtl", 0)).setNamePattern(this.getParameter("name_pattern", "")).setData(data).setPatternId(this.getIntParameter("title_pattern_id", 0)).setStatus(this.getIntParameter("status", 0)).setObjectString(this.getParameter("objects")).setDomainId(this.getIntParameter("domainId", 0)).setTariffPlanList(Utils.toList((String)tariff)).setTariffGroupList(Utils.toIntegerList((String)this.getParameter("tgid"))).setScriptList(Utils.toIntegerList((String)this.getParameter("script"))).setPatternMode(this.getParameter("patternMode")).setMasterHandlerClass(this.getParameter("masterHandlerClass")).setMasterTariffMode(this.getParameter("masterTariffMode")).setMasterRequiredParameterIds(Utils.toIntegerSet((String)this.getParameter("masterRequiredParameterIds"))).setMasterOptionalParameterIds(Utils.toIntegerSet((String)this.getParameter("masterOptionalParameterIds"))).build();
        new ContractPatternDao(this.con).updateContractPattern(this.getIntParameter("pid", -1), pattern);
    }
}

