/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.object.common.dto.ContractObjectModuleDTO;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;

public class ObjectModuleEditor
extends BGPanel {
    private BGDialogToolBar propertyToolBar = new BGDialogToolBar();
    private BGDialogToolBar moduleToolBar = new BGDialogToolBar();
    private JTabbedPane tabPanel = new JTabbedPane();
    private ObjectModuleTableModel tableModel = new ObjectModuleTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
    private boolean ignoreStateChange = false;

    public ObjectModuleEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.tabPanel.addTab("\u0421\u0432\u043e\u0434\u043d\u0430\u044f", new JScrollPane((Component)this.table));
        this.propertyToolBar.setOrientation(1);
        this.propertyToolBar.setMargin(new Insets(5, 5, 0, 5));
        this.propertyToolBar.setBorderPainted(false);
        this.propertyToolBar.setFloatable(false);
        this.moduleToolBar.setOrientation(1);
        this.moduleToolBar.setMargin(new Insets(5, 5, 0, 5));
        this.moduleToolBar.setBorderPainted(false);
        this.moduleToolBar.setFloatable(false);
        this.tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ObjectModuleEditor.this.ignoreStateChange) {
                    return;
                }
                Component selectedComponent = ObjectModuleEditor.this.tabPanel.getSelectedComponent();
                if (selectedComponent instanceof JScrollPane) {
                    ObjectModuleEditor.this.setData();
                } else {
                    ((ServicePanel)selectedComponent).initModuleToollBar(ObjectModuleEditor.this.moduleToolBar);
                    ((ServicePanel)selectedComponent).setData();
                }
            }
        });
        this.buildPropertyToolBar();
        JPanel tollBarPanel = new JPanel(new GridBagLayout());
        tollBarPanel.add((Component)this.propertyToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        tollBarPanel.add((Component)this.moduleToolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(tollBarPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.tabPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void buildPropertyToolBar() {
        PropertyToolBarActionListener actionListener = new PropertyToolBarActionListener();
        this.propertyToolBar.setDefaultButtons((ActionListener)actionListener);
        this.propertyToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "separator", "refresh"});
        this.moduleToolBar.setActionListener((ActionListener)actionListener);
    }

    public void setId(String id) {
        super.setId(id);
        if (id == null) {
            this.hideEditors();
        }
    }

    public void hideEditors() {
        for (int i = this.tabPanel.getTabCount() - 1; i > 0; --i) {
            this.ignoreStateChange = true;
            this.tabPanel.removeTabAt(i);
            this.ignoreStateChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData() {
        if (this.id == null || this.id.equals("0")) {
            return;
        }
        this.hideEditors();
        ContractObjectService contractObjectService = (ContractObjectService)this.getContext().getWebService(ContractObjectService.class, 0);
        try {
            List<ContractObjectModuleDTO> objectModules = contractObjectService.contractObjectModuleList(this.getContractId(), Utils.parseInt((String)this.id));
            ArrayList list = new ArrayList();
            objectModules.forEach(a -> list.addAll(Optional.ofNullable(a.getModuleEntities()).orElse(Collections.emptyList()).stream().map(b -> new ModuleEntityItem(a.getTitle(), (ModuleEntity)b)).toList()));
            this.tableModel.setData(list);
            for (ContractObjectModuleDTO objectModule : objectModules) {
                try {
                    Class<?> clazz = Class.forName(objectModule.getClientPackage() + ".ServicePropertiesPanel");
                    String rb_name = clazz.getPackage().getName() + ".setup";
                    ClientContext context = new ClientContext(objectModule.getModule(), objectModule.getModuleId(), this.getContractId(), Utils.parseInt((String)this.id), rb_name);
                    ClientContext.push((ClientContext)context);
                    try {
                        ServicePanel servicePanel = (ServicePanel)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        servicePanel.setContext(context);
                        servicePanel.init(this.getContractId(), objectModule.getModuleId(), Utils.parseInt((String)this.id));
                        this.ignoreStateChange = true;
                        this.tabPanel.addTab(objectModule.getTitle(), (Component)servicePanel);
                        this.ignoreStateChange = false;
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                    finally {
                        ClientContext.pop();
                    }
                }
                catch (ClassNotFoundException e) {
                    ClientUtils.showErrorMessageDialog((String)("\u041a\u043b\u0430\u0441\u0441 " + objectModule.getClientPackage() + ".ServicePropertiesPanel \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                }
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.tabPanel.setSelectedIndex(0);
    }

    class ObjectModuleTableModel
    extends BGTableModel<ModuleEntityItem> {
        public ObjectModuleTableModel() {
            super(ObjectModuleTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 150, 150, 250, "module", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0443\u0449\u043d\u043e\u0441\u0442\u044c", 150, 200, -1, "data", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 150, 180, 200, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 150, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class PropertyToolBarActionListener
    implements ActionListener {
        PropertyToolBarActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component selectedComponent = ObjectModuleEditor.this.tabPanel.getSelectedComponent();
            if (selectedComponent instanceof ServicePanel) {
                ((ServicePanel)selectedComponent).actionPerformed(e);
            }
        }
    }

    public class ModuleEntityItem {
        private String module;
        private String data;
        private String comment;
        private String period;

        public ModuleEntityItem(String module, ModuleEntity entity) {
            this.module = module;
            this.data = entity.getName() + ": " + entity.getData();
            this.period = entity.getPeriod();
            this.comment = entity.getComment();
        }

        public String getModule() {
            return this.module;
        }

        public String getData() {
            return this.data;
        }

        public String getComment() {
            return this.comment;
        }

        public String getPeriod() {
            return this.period;
        }
    }
}

