/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusLogPanel;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ObjectStatusEditor
extends BGUPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private StatusControlPanel statusControlPanel = new StatusControlPanel();
    private StatusTableModel statusTableModel = new StatusTableModel();
    private StatusLogPanel statusLogPanel = new StatusLogPanel();
    private int objectId = -1;
    private List<Status> statusList = null;
    private ContractStatusService contractStatusService = null;

    protected void jbInit() throws Exception {
        this.tabbedPane.add((Component)this.getStatusPanel(), "\u0421\u0442\u0430\u0442\u0443\u0441");
        this.tabbedPane.add((Component)((Object)this.statusLogPanel), "\u041b\u043e\u0433 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f");
        this.tabbedPane.addChangeListener(e -> this.performAction("refresh"));
        this.setLayout(new GridBagLayout());
        this.add(this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatusPanel() {
        this.statusControlPanel.addActionListener(e -> this.changeStatus());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)this.statusControlPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)new BGUTable((TableModel)((Object)this.statusTableModel))), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void changeStatus() {
        if (this.statusControlPanel.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        int[] cids = new int[]{((ClientContext)this.getContext()).getContractId()};
        ClientStatusUtil.changeStatusOnServer((Component)((Object)this), (ClientContext)this.getContext(), cids, this.objectId, this.statusControlPanel.getStatusId(), this.statusControlPanel.getDateFrom(), this.statusControlPanel.getDateTo(), this.statusControlPanel.getComment());
        this.performAction("refresh");
        this.firePropertyChange("statusUpdate", -2, this.statusControlPanel.getStatusId());
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                Async.ofWithTry(() -> {
                    Status contractStatus = new Status();
                    contractStatus.setId(-1);
                    contractStatus.setTitle("\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    List<Status> manualStatusList = this.getContractStatusService().getStatusList(true);
                    manualStatusList.add(0, contractStatus);
                    this.statusControlPanel.setStatusList(manualStatusList);
                });
                Async.ofWithTry(() -> {
                    if (this.objectId > 0) {
                        this.statusTableModel.setData(this.getContractStatusService().contractStatusSearch(((ClientContext)this.getContext()).getContractId(), this.objectId, new Page(1, 20)).getList());
                    } else {
                        this.statusTableModel.setData(new ArrayList());
                    }
                });
            } else {
                this.statusLogPanel.setObjectId(this.objectId);
                this.statusLogPanel.performAction("refresh");
            }
        });
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
        this.performAction("refresh");
    }

    public void setStatusList(List<Status> statusList) {
        this.statusList = statusList;
        this.statusLogPanel.setStatusList(statusList);
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)((ClientContext)this.getContext()).getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    class StatusTableModel
    extends BGTableModel<ContractStatus> {
        public StatusTableModel() {
            super(StatusTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(ContractStatus val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return ObjectStatusEditor.this.statusList.stream().filter(a -> a.getId() == val.getStatus()).map(a -> a.getGuiTitle() + (val.getId() == 0 ? " [\u0434\u043e\u0433.]" : "")).findFirst().orElse("??? [#" + val.getStatus() + "]");
            }
            if ("period".equals(identifier)) {
                return new Period(val.getDateFrom(), val.getDateTo());
            }
            return super.getValueAt((Object)val, column);
        }
    }
}

