/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import jakarta.xml.bind.JAXBException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.event.EventProcessorException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.MessageAdapter;
import ru.bitel.bgbilling.kernel.event.common.Event;

public final class Producer
extends MessageAdapter
implements MessageListener {
    private static final Logger logger = LogManager.getLogger();
    private final MessageProducer producer;
    private final ConcurrentMap<String, Object> requestMap;
    protected final TemporaryQueue replyQueue;
    private final MessageConsumer replyMc;
    protected final int deliveryMode;
    protected final int priority;
    protected final long timeToLive;
    protected final boolean autoAcknowledge;
    private static final Callable<?> callable = new Callable<Object>(){

        @Override
        public Object call() throws Exception {
            throw new UnsupportedOperationException();
        }
    };

    public Producer(Session session, ConcurrentMap<String, Object> requestMap, ConcurrentMap<String, Message> responseMap, Class<? extends Event> clazz, String name, boolean topic) throws JMSException, JAXBException {
        super(session, clazz);
        EventType type = clazz.getAnnotation(EventType.class);
        if (type != null) {
            this.deliveryMode = type.deliveryMode();
            this.priority = type.priority();
            this.timeToLive = type.timeToLive();
            this.autoAcknowledge = type.autoAcknowledge();
        } else {
            this.deliveryMode = 2;
            this.priority = 4;
            this.timeToLive = 0L;
            this.autoAcknowledge = true;
        }
        this.producer = session.createProducer((Destination)(topic ? session.createTopic(name) : session.createQueue(name)));
        this.requestMap = requestMap;
        if (!topic) {
            this.replyQueue = session.createTemporaryQueue();
            this.replyMc = session.createConsumer((Destination)this.replyQueue);
            this.replyMc.setMessageListener((MessageListener)this);
        } else {
            this.replyQueue = null;
            this.replyMc = null;
        }
        this.producer.setDeliveryMode(this.deliveryMode);
        this.producer.setPriority(this.priority);
        this.producer.setTimeToLive(this.timeToLive);
    }

    public void onMessage(Message message) {
        try {
            String correlationId = message.getJMSCorrelationID();
            Object request = this.requestMap.remove(correlationId);
            if (request instanceof Answer) {
                ((Answer)request).set(message);
            } else if (request instanceof AsyncAnswer) {
                Object ex = message.getStringProperty("bg:ex");
                if (ex != null) {
                    ex = (String)ex + ": " + message.getStringProperty("bg:ex.message");
                    logger.error("Exception occured in event listener - " + (String)ex);
                    ((AsyncAnswer)request).setException((Throwable)((Object)new EventProcessorException((String)ex)));
                } else {
                    ((AsyncAnswer)request).set(this.parseMessage(message));
                }
            } else {
                logger.warn("Null request on queue event response!");
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void close() throws JMSException {
        this.producer.close();
        if (this.replyMc != null) {
            this.replyMc.close();
        }
        if (this.replyQueue != null) {
            this.replyQueue.delete();
        }
    }

    public void send(Message message) throws JMSException {
        this.producer.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, long timeToLive) throws JMSException {
        this.producer.send(message, this.deliveryMode, this.priority, timeToLive);
    }

    public void send(Message message, int priority, long timeToLive) throws JMSException {
        this.producer.send(message, this.deliveryMode, priority, timeToLive);
    }

    public Object request(String correlationId, Message message) throws JMSException, InterruptedException, JAXBException, EventProcessorException {
        Message response;
        Answer result = new Answer(correlationId);
        this.requestMap.put(correlationId, result);
        this.producer.send(message);
        try {
            response = (Message)result.get();
        }
        catch (ExecutionException e) {
            throw new EventProcessorException(e);
        }
        Object ex = response.getStringProperty("bg:ex");
        if (ex != null) {
            ex = (String)ex + ": " + response.getStringProperty("bg:ex.message");
            logger.error("Exception occured in event listener - " + (String)ex);
            throw new EventProcessorException((String)ex);
        }
        return this.parseMessage(response);
    }

    public Object request(String correlationId, Message message, long timeout) throws JMSException, JAXBException, InterruptedException, EventProcessorException {
        Message response;
        Answer result = new Answer(correlationId);
        this.requestMap.put(correlationId, result);
        this.producer.send(message, this.deliveryMode, this.priority, timeout / 2L);
        try {
            response = (Message)result.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new EventProcessorException(e);
        }
        catch (TimeoutException e) {
            response = null;
            this.requestMap.remove(correlationId, message);
        }
        if (response != null) {
            Object ex = response.getStringProperty("bg:ex");
            if (ex != null) {
                ex = (String)ex + ": " + response.getStringProperty("bg:ex.message") + " [message =  " + message.toString() + "]";
                logger.error("Exception occured in event listener - " + (String)ex);
                throw new EventProcessorException((String)ex);
            }
            return this.parseMessage(response);
        }
        return null;
    }

    public <Q extends Event> Future<Q> requestAsync(String correlationId, Message message, long timeout) throws JMSException, JAXBException, InterruptedException, EventProcessorException {
        AsyncAnswer result = new AsyncAnswer(correlationId);
        this.requestMap.put(correlationId, result);
        this.producer.send(message, this.deliveryMode, this.priority, timeout / 2L);
        return result;
    }

    final class Answer
    extends FutureTask<Message> {
        final String correlationId;

        public Answer(String correlationId) {
            super(callable);
            this.correlationId = correlationId;
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
        }

        @Override
        protected void set(Message v) {
            super.set(v);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Producer.this.requestMap.remove(this.correlationId);
            return super.cancel(mayInterruptIfRunning);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }

    final class AsyncAnswer<Q>
    extends FutureTask<Q> {
        final String correlationId;

        public AsyncAnswer(String correlationId) {
            super(callable);
            this.correlationId = correlationId;
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
        }

        @Override
        protected void set(Q v) {
            super.set(v);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            Producer.this.requestMap.remove(this.correlationId);
            return super.cancel(mayInterruptIfRunning);
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }
    }
}

