/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.publish.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.event.publish.client.DirectoryPanel;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQDestination;
import ru.bitel.bgbilling.kernel.event.publish.common.bean.MQEvent;
import ru.bitel.bgbilling.kernel.event.publish.common.service.MQEventService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class MQEventPanel
extends DirectoryPanel {
    private MQEvent mqEvent = null;
    private JPanel eventEditPanel = null;
    private MQEventService mqEventService = null;
    private Map<String, JTextField> fields = new HashMap<String, JTextField>();
    private DefaultListModel<MQEvent> eventListModel = new DefaultListModel();
    private JList<MQEvent> eventList = new JList<MQEvent>(this.eventListModel);
    private final String[][] eventFieldKey = new String[][]{{"title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"}, {"event", "\u0421\u043e\u0431\u044b\u0442\u0438\u0435"}, {"mqServer", "\u0421\u0435\u0440\u0432\u0435\u0440"}, {"destination", "\u0422\u043e\u0447\u043a\u0430 \u043e\u0431\u043c\u0435\u043d\u0430, \u043e\u0447\u0435\u0440\u0435\u0434\u044c"}, {"deliveryMode", "\u0420\u0435\u0436\u0438\u043c \u0434\u043e\u0441\u0442\u0430\u0432\u043a\u0438"}, {"priority", "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442"}, {"timeToLive", "TTL"}};

    protected void jbInit() throws Exception {
        this.eventList.setSelectionMode(0);
        this.eventList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MQEventPanel.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JLabel("\u0421\u043e\u0431\u044b\u0442\u0438\u044f"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 2, 5), 0, 0));
        this.add(new JScrollPane(this.eventList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getEventEditPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private MQEventService getMQEventService() {
        if (this.mqEventService == null) {
            this.mqEventService = (MQEventService)((ClientContext)this.getContext()).getPort(MQEventService.class);
        }
        return this.mqEventService;
    }

    private JPanel getEventEditPanel() {
        if (this.eventEditPanel == null) {
            BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();
            okCancelPanel.addActionListener(actionEvent -> {
                this.stopEditMQEvent(actionEvent.getActionCommand().equals("ok"));
                this.eventEditPanel.setVisible(false);
            });
            this.eventEditPanel = new JPanel(new GridBagLayout());
            this.eventEditPanel.setBorder(new TitledBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 MQ \u0441\u043e\u0431\u044b\u0442\u0438\u044f"));
            this.eventEditPanel.setVisible(false);
            int gridy = 0;
            this.fields.clear();
            for (String[] field : this.eventFieldKey) {
                this.fields.put(field[0], new JTextField());
                this.eventEditPanel.add((Component)new JLabel(field[1]), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
                this.eventEditPanel.add((Component)this.fields.get(field[0]), new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            }
            this.eventEditPanel.add((Component)okCancelPanel, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 10, 1, new Insets(10, 0, 5, 0), 0, 0));
        }
        return this.eventEditPanel;
    }

    private void editMQEvent() {
        this.eventList.setEnabled(false);
        this.eventEditPanel.setVisible(true);
        block18: for (String[] field : this.eventFieldKey) {
            JTextField textField = this.fields.get(field[0]);
            switch (field[0]) {
                case "title": {
                    textField.setText(this.mqEvent.getTitle());
                    continue block18;
                }
                case "event": {
                    textField.setText(this.mqEvent.getEvent());
                    continue block18;
                }
                case "mqServer": {
                    textField.setText(String.valueOf(this.mqEvent.getMqServer()));
                    continue block18;
                }
                case "destination": {
                    textField.setText(String.valueOf(this.mqEvent.getDestination()));
                    continue block18;
                }
                case "deliveryMode": {
                    textField.setText(String.valueOf(this.mqEvent.getDeliveryMode()));
                    continue block18;
                }
                case "priority": {
                    textField.setText(String.valueOf(this.mqEvent.getPriority()));
                    continue block18;
                }
                case "timeToLive": {
                    textField.setText(String.valueOf(this.mqEvent.getTimeToLive()));
                    continue block18;
                }
            }
        }
    }

    private void stopEditMQEvent(boolean save) {
        if (save) {
            block20: for (String[] field : this.eventFieldKey) {
                JTextField textField = this.fields.get(field[0]);
                switch (field[0]) {
                    case "title": {
                        this.mqEvent.setTitle(textField.getText());
                        continue block20;
                    }
                    case "event": {
                        this.mqEvent.setEvent(textField.getText());
                        continue block20;
                    }
                    case "mqServer": {
                        this.mqEvent.setMqServer(Utils.parseInt((String)textField.getText(), (int)0));
                        continue block20;
                    }
                    case "destination": {
                        this.mqEvent.setDestination(new MQDestination(textField.getText()));
                        continue block20;
                    }
                    case "deliveryMode": {
                        this.mqEvent.setDeliveryMode(Utils.parseInt((String)textField.getText(), (int)2));
                        continue block20;
                    }
                    case "priority": {
                        this.mqEvent.setPriority(Utils.parseInt((String)textField.getText(), (int)4));
                        continue block20;
                    }
                    case "timeToLive": {
                        this.mqEvent.setTimeToLive(Utils.parseLong((String)textField.getText(), (long)0L));
                        continue block20;
                    }
                }
            }
            try {
                this.getMQEventService().updateMQEvent(this.mqEvent);
                this.mqEvent = null;
                this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        }
        this.eventEditPanel.setVisible(false);
        this.eventList.setEnabled(true);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.eventListModel.clear();
            this.getMQEventService().searchMQEventList(null).getList().forEach(a -> this.eventListModel.addElement((MQEvent)((Object)((Object)a))));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.mqEvent = new MQEvent();
            this.editMQEvent();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            MQEvent mqEvent = this.eventList.getSelectedValue();
            if (mqEvent != null) {
                this.mqEvent = mqEvent;
                this.editMQEvent();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (!this.eventEditPanel.isVisible()) {
                MQEvent mqEvent = this.eventList.getSelectedValue();
                if (mqEvent != null && ClientUtils.confirmDelete((Object)mqEvent.getTitle())) {
                    this.getMQEventService().deleteMQEvent(mqEvent.getId());
                    this.performAction("refresh");
                }
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0437\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440.");
            }
        });
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public String getTitle() {
        return "\u0421\u043e\u0431\u044b\u0442\u0438\u044f";
    }

    @Override
    public String getCardName() {
        return "topics";
    }
}

