/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffVar;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.TariffCounterPanel;
import ru.bitel.bgbilling.kernel.tariff.client.TariffVariablePanel;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

public class ContractCommonTariff
extends BGUPanel {
    private int domainId = 0;
    private int tariffGroupId = 0;
    private JPopupMenu popupMenu = null;
    private JTextField tariffGroupTitle = new JTextField();
    private ContractCommonTariffTableModel tableModel = null;
    private TariffCounterPanel tariffCounterPanel = new TariffCounterPanel();
    private TariffVariablePanel tariffVariablePanel = new TariffVariablePanel();

    protected void jbInit() throws Exception {
        this.tableModel = new ContractCommonTariffTableModel();
        final BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ContractCommonTariff.this.getPopupMenu() != null && SwingUtilities.isRightMouseButton(e) && table.getSelectedRow() == table.rowAtPoint(e.getPoint())) {
                    ContractCommonTariff.this.getPopupMenu().show((Component)table, e.getX(), e.getY());
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ContractCommonTariff.this.tableModel.optSelectedRow().map(a -> a.getId()).filter(a -> a > 0).ifPresent(a -> {
                        ContractCommonTariff.this.tariffVariablePanel.showTariffVariables((int)a);
                        ContractCommonTariff.this.tariffCounterPanel.showTariffCounters((int)a);
                    });
                }
                if (e.getClickCount() == 2) {
                    ContractCommonTariff.this.performAction("edit");
                }
            }
        });
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, (Component)new JScrollPane((Component)table), (Component)this.getTariffExtraPanel(), 500L);
        this.setLayout(new GridBagLayout());
        this.add(this.getTariffGroupPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTariffExtraPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)((Object)this.tariffVariablePanel), "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435");
        tabbedPane.add((Component)((Object)this.tariffCounterPanel), "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0438");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getTariffGroupPanel() {
        Font font = this.tariffGroupTitle.getFont();
        Color bgColor = this.tariffGroupTitle.getBackground();
        this.tariffGroupTitle.setEnabled(false);
        this.tariffGroupTitle.setBackground(bgColor);
        this.tariffGroupTitle.setHorizontalAlignment(0);
        this.tariffGroupTitle.setFont(new Font(font.getFamily(), 1, font.getSize()));
        JButton button = new JButton(ClientUtils.getIcon((String)"edit"));
        button.addActionListener(e -> this.performAction("editTariffGroup"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.tariffGroupTitle, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)button, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getCopyMenuItem());
            this.popupMenu.add(this.getChangeMenuItem());
            this.popupMenu.add(this.getCloseMenuItem());
        }
        return this.popupMenu;
    }

    private JMenuItem getCopyMenuItem() {
        return new JMenuItem("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){
            {
                this.addActionListener(e -> {
                    ContractTariff oldContractTariff = (ContractTariff)ContractCommonTariff.this.tableModel.getSelectedRow();
                    if (oldContractTariff == null) {
                        return;
                    }
                    ContractTariff newContractTariff = ContractTariff.builder().setContractId(((ClientContext)ContractCommonTariff.this.getContext()).getContractId()).setTariffPlanId(oldContractTariff.getTariffPlanId()).setTariffGroupId(oldContractTariff.getTariffGroupId()).setPosition(oldContractTariff.getPosition()).setComment(oldContractTariff.getComment()).setPeriod(new Period(LocalDate.now(), null)).setTariffGroupId(oldContractTariff.getTariffGroupId()).build();
                    new ContractTariffDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", newContractTariff).open();
                    if (newContractTariff.getId() > 0) {
                        ContractTariffService contractTariffService = (ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class, 0);
                        Period newPeriod = newContractTariff.getPeriod();
                        if (newPeriod != null) {
                            LocalDate fromDate = newPeriod.getLocalDateFrom();
                            Period oldPeriod = oldContractTariff.getPeriod();
                            if (fromDate != null && (oldPeriod.getLocalDateFrom() == null || oldPeriod.getLocalDateFrom().isBefore(fromDate))) {
                                oldPeriod.setLocalDateTo(fromDate.minusDays(1L));
                                try {
                                    contractTariffService.contractTariffUpdate(oldContractTariff);
                                    ContractCommonTariff.this.performAction("refresh");
                                }
                                catch (BGException e1) {
                                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                                }
                            }
                        }
                        try {
                            for (ContractTariffVar contractTariffVar : contractTariffService.contractTariffVars(oldContractTariff.getId()).stream().filter(a -> a.getValue() != null).toList()) {
                                contractTariffVar.setContractTarifffId(newContractTariff.getId());
                                contractTariffService.contractTariffVarUpdate(contractTariffVar);
                            }
                        }
                        catch (BGException e1) {
                            ClientUtils.showErrorMessageDialog((Throwable)e1);
                        }
                    }
                });
            }
        };
    }

    private JMenuItem getChangeMenuItem() {
        return new JMenuItem("\u0421\u043c\u0435\u043d\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){
            {
                this.addActionListener(e -> {
                    ContractTariff oldContractTariff = (ContractTariff)ContractCommonTariff.this.tableModel.getSelectedRow();
                    if (oldContractTariff != null) {
                        Period newPeriod;
                        ContractTariff newContractTariff = ContractTariff.builder().setContractId(((ClientContext)ContractCommonTariff.this.getContext()).getContractId()).setPosition(oldContractTariff.getPosition()).setComment("").setPeriod(new Period(LocalDate.now(), null)).setReplacedFromContractTariffId(oldContractTariff.getId()).setTariffGroupId(oldContractTariff.getTariffGroupId()).build();
                        new ContractTariffDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", newContractTariff).open();
                        if (newContractTariff.getId() > 0 && (newPeriod = newContractTariff.getPeriod()) != null) {
                            LocalDate fromDate = newPeriod.getLocalDateFrom();
                            Period oldPeriod = oldContractTariff.getPeriod();
                            if (fromDate != null && (oldPeriod.getLocalDateFrom() == null || oldPeriod.getLocalDateFrom().isBefore(fromDate))) {
                                oldPeriod.setLocalDateTo(fromDate.minusDays(1L));
                                try {
                                    ((ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class)).contractTariffUpdate(oldContractTariff);
                                    ContractCommonTariff.this.performAction("refresh");
                                }
                                catch (BGException e1) {
                                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                                }
                            }
                        }
                    }
                });
            }
        };
    }

    private JMenuItem getCloseMenuItem() {
        return new JMenuItem("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0430\u0440\u0438\u0444 (\u0441\u0435\u0433\u043e\u0434\u043d\u044f)"){
            {
                this.addActionListener(e -> {
                    Period period;
                    ContractTariff contractTariff = (ContractTariff)ContractCommonTariff.this.tableModel.getSelectedRow();
                    if (contractTariff != null && (period = contractTariff.getPeriod()) != null) {
                        LocalDate now = LocalDate.now();
                        if (period.getLocalDateFrom() == null || period.getLocalDateFrom().compareTo(now) < 1) {
                            period.setLocalDateTo(now);
                            try {
                                ((ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class)).contractTariffUpdate(contractTariff);
                                ContractCommonTariff.this.performAction("refresh");
                            }
                            catch (BGException e1) {
                                ClientUtils.showErrorMessageDialog((Throwable)e1);
                            }
                        } else {
                            ClientUtils.showErrorMessageDialog((String)"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u0440\u0430\u043d\u044c\u0448\u0435 \u043d\u0430\u0447\u0430\u043b\u0430!");
                        }
                    }
                });
            }
        };
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            TariffGroup tariffGroup;
            int contractId = ((ClientContext)this.getContext()).getContractId();
            Contract contract = ((ContractService)((ClientContext)this.getContext()).getWebService(ContractService.class)).contractGet(contractId);
            this.domainId = contract != null ? contract.getDomainId() : 0;
            this.tariffGroupId = 0;
            String title = "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>";
            ContractTariffGroup contractTariffGroup = ((ContractTariffService)((ClientContext)this.getContext()).getWebService(ContractTariffService.class)).contractTariffGroupGet(contractId);
            if (contractTariffGroup != null && (tariffGroup = (TariffGroup)((ClientContext)this.getContext()).getDirectory(TariffGroup.class).get(contractTariffGroup.getTariffGroupId())) != null) {
                title = tariffGroup.getTitle();
                this.tariffGroupId = contractTariffGroup.getTariffGroupId();
            }
            this.tariffGroupTitle.setText(title);
            this.tableModel.setData(((ContractTariffService)((ClientContext)this.getContext()).getWebService(ContractTariffService.class)).contractTariffList(contractId, null, 0, 0));
        }).setIcon((Icon)ClientUtils.getIcon((String)"refresh"));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ContractTariffDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430", ContractTariff.builder().setContractId(((ClientContext)this.getContext()).getContractId()).setTariffGroupId(-1).setPeriod(new Period(LocalDate.now(), null)).build()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.tableModel, ContractTariffDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            ContractTariff contractTariff = (ContractTariff)this.tableModel.getSelectedRow();
            if (contractTariff != null) {
                if (ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
                    try {
                        ((ContractTariffService)((ClientContext)this.getContext()).getWebService(ContractTariffService.class)).contractTariffDelete(contractTariff.getId());
                        this.tariffVariablePanel.clearContractTariffVars();
                        this.tariffVariablePanel.doFilterTariffVariables();
                        EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("editTariffGroup", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 \u0442\u0430\u0440\u0438\u0444\u043e\u0432"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ContractCommonTariff.this.getContractTariffGroupDialog().setVisible(true);
            }
        };
    }

    private JDialog getContractTariffGroupDialog() {
        BGUList tariffGroups = new BGUList();
        tariffGroups.setSelectionMode(0);
        try {
            ArrayList<IdTitle> listData = new ArrayList<IdTitle>();
            listData.add(new IdTitle(0, "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>"));
            ((TariffService)((ClientContext)this.getContext()).getWebService(TariffService.class, 0)).tariffGroupList().stream().filter(t -> t.getDomainId() == 0 || t.getDomainId() == this.domainId).forEach(g -> listData.add(g.toIdTitle()));
            tariffGroups.setData(listData);
            for (IdTitle idTitle : listData) {
                if (idTitle.getId() != this.tariffGroupId) continue;
                tariffGroups.setSelectedValue((Object)idTitle, true);
                break;
            }
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
        JScrollPane scrollPane = new JScrollPane((Component)tariffGroups);
        scrollPane.setMinimumSize(new Dimension(500, 250));
        scrollPane.setPreferredSize(new Dimension(500, 250));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0412\u044b\u0431\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                IdTitle idTitle = (IdTitle)tariffGroups.getSelectedValue();
                if (idTitle == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \"\u0413\u0440\u0443\u043f\u043f\u0443 \u0442\u0430\u0440\u0438\u0444\u043e\u0432\"!");
                    return;
                }
                ((ContractTariffService)((ClientContext)this.getContext()).getWebService(ContractTariffService.class)).contractTariffGroupSet(((ClientContext)this.getContext()).getContractId(), idTitle.getId());
                this.tariffGroupId = idTitle.getId();
                this.tariffGroupTitle.setText(idTitle.getTitle());
                dialog.setVisible(false);
                dialog.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return dialog;
    }

    class ContractCommonTariffTableModel
    extends BGTableModel<ContractTariff> {
        private Directory<TariffGroup> tariffGroupDirectory;
        private Directory<TariffPlan> tariffPlanDirectory;

        public ContractCommonTariffTableModel() {
            super(ContractCommonTariff.class.getName());
            this.tariffGroupDirectory = null;
            this.tariffPlanDirectory = null;
            try {
                this.tariffPlanDirectory = ((ClientContext)ContractCommonTariff.this.getContext()).getDirectory(TariffPlan.class);
                this.tariffGroupDirectory = ((ClientContext)ContractCommonTariff.this.getContext()).getDirectory(TariffGroup.class);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0422\u041f#ID", 0, 50, 50, "tariffPlanId", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041f\u043e\u0437.", 50, 50, 50, "position", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 100, 250, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432", 100, 150, -1, "tariffGroupId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", 180, 180, 180, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(ContractTariff contractTariff, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("title".equals(identifier)) {
                TariffPlan tariffPlan = this.tariffPlanDirectory.get(contractTariff.getTariffPlanId());
                return tariffPlan != null ? tariffPlan.getTitle() : "<\u0422\u0410\u0420\u0418\u0424 \u041d\u0415 \u041d\u0410\u0419\u0414\u0415\u041d>";
            }
            if ("tariffGroupId".equals(identifier)) {
                int tariffGroupId = contractTariff.getTariffGroupId();
                switch (tariffGroupId) {
                    case -1: {
                        return "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e";
                    }
                    case 0: {
                        return "<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>";
                    }
                }
                TariffGroup tariffGroup = this.tariffGroupDirectory.get(tariffGroupId);
                return tariffGroup == null ? "#" + tariffGroupId : tariffGroup.getTitle();
            }
            return super.getValue((Object)contractTariff, column);
        }
    }

    public class ContractTariffDialog
    extends BGEditorDialog<ContractTariff> {
        private JTextArea tariffComment;
        private JTextField tariffPosition;
        private JCheckBox showUsed;
        private JCheckBox contractFilter;
        private BGUList<IdTitle> modules;
        private BGUList<IdTitle> tariffPlans;
        private BGUComboBox<IdTitle> tariffGroup;
        private BGControlPanelPeriodNoB periodPanel;

        public ContractTariffDialog(String title, ContractTariff data) {
            super(title, (Object)data);
            this.tariffComment = new JTextArea(7, 20);
            this.tariffPosition = new JTextField(10);
            this.showUsed = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435");
            this.contractFilter = new JCheckBox("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
            this.modules = new BGUList();
            this.tariffPlans = new BGUList();
            this.tariffGroup = new BGUComboBox();
            this.periodPanel = new BGControlPanelPeriodNoB();
        }

        public void doDialogPanel() {
            int gridy = 0;
            JPanel tariffParamPanel = new JPanel(new GridBagLayout());
            tariffParamPanel.add((Component)new JLabel("\u041f\u043e\u0437\u0438\u0446\u0438\u044f:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)this.tariffPosition, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)this.periodPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            tariffParamPanel.add((Component)new JScrollPane(this.tariffComment), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            int gridx = 0;
            JPanel tariffPanel = new JPanel(new GridBagLayout());
            tariffPanel.add((Component)this.getTariffFilterPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            tariffPanel.add((Component)this.getTariffListPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            tariffPanel.add((Component)tariffParamPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)tariffPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.tariffPosition.setHorizontalAlignment(0);
            this.tariffPosition.setText(String.valueOf(((ContractTariff)this.data).getPosition()));
            this.periodPanel.setPeriod(((ContractTariff)this.data).getPeriod());
            this.tariffComment.setWrapStyleWord(true);
            this.tariffComment.setLineWrap(true);
            this.tariffComment.setMargin(new Insets(3, 3, 3, 3));
            this.tariffComment.setText(((ContractTariff)this.data).getComment());
            for (int index = 0; index < this.tariffGroup.getItemCount(); ++index) {
                if (((IdTitle)this.tariffGroup.getItemAt(index)).getId() != ((ContractTariff)this.data).getTariffGroupId()) continue;
                this.tariffGroup.setSelectedIndex(index);
                break;
            }
            this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter);
        }

        private JPanel getTariffFilterPanel() {
            this.tariffPlans.setSelectionMode(0);
            ArrayList<IdTitle> listData = new ArrayList<IdTitle>();
            listData.add(new IdTitle(-1, "\u041b\u044e\u0431\u043e\u0439 \u043c\u043e\u0434\u0443\u043b\u044c"));
            try {
                ContractTariffService contractTariffService = (ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class, 0);
                listData.addAll(contractTariffService.contractTariffModuleList(((ContractTariff)this.data).getContractId()));
                this.modules.setData(listData);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.modules.setSelectionMode(0);
            this.modules.setSelectedIndex(0);
            this.contractFilter.setSelected(true);
            this.showUsed.setSelected(true);
            ChangeListener changeListener = e -> this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter);
            this.showUsed.addChangeListener(changeListener);
            this.contractFilter.addChangeListener(changeListener);
            this.modules.addListSelectionListener(e -> this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter));
            this.tariffGroup.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setTariffList(((ContractTariff)this.data).getTariffPlanId(), this.showUsed, this.contractFilter);
                }
            });
            Dimension dimension = new Dimension(200, 150);
            JScrollPane modulesScrollPane = new JScrollPane((Component)this.modules);
            modulesScrollPane.setMinimumSize(dimension);
            modulesScrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043f\u043e \u043c\u043e\u0434\u0443\u043b\u044e"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)modulesScrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.showUsed, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.contractFilter, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getTariffListPanel() {
            try {
                ArrayList tariffGroups = new ArrayList();
                ((ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class)).contractTariffGroupList(((ContractTariff)this.data).getContractId()).forEach(g -> tariffGroups.add(new IdTitle(g.getId(), g.getTitle())));
                this.tariffGroup.setData(tariffGroups);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            Dimension dimension = new Dimension(500, 300);
            JScrollPane tariffScrollPane = new JScrollPane((Component)this.tariffPlans);
            tariffScrollPane.setMinimumSize(dimension);
            tariffScrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)tariffScrollPane, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 13, 1, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.tariffGroup, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private void setTariffList(int tariffPlanId, JCheckBox showUsed, JCheckBox useFilter) {
            try {
                IdTitle idTitle = (IdTitle)this.modules.getSelectedValue();
                int moduleId = idTitle == null ? -1 : idTitle.getId();
                int tariffGroupId = this.tariffGroup.getSelectedItem() == null ? 0 : ((IdTitle)this.tariffGroup.getSelectedItem()).getId();
                List<IdTitle> items = ((ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class)).contractTariffListByParam(((ClientContext)ContractCommonTariff.this.getContext()).getContractId(), tariffPlanId, moduleId, showUsed.isSelected(), useFilter.isSelected(), tariffGroupId);
                this.tariffPlans.setData(items);
                for (IdTitle item : items) {
                    if (item.getId() != tariffPlanId) continue;
                    this.tariffPlans.setSelectedValue((Object)item, true);
                    break;
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            try {
                IdTitle idTitle = (IdTitle)this.tariffPlans.getSelectedValue();
                if (idTitle == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444!");
                    return false;
                }
                ((ContractTariff)this.data).setTariffPlanId(idTitle.getId());
                ((ContractTariff)this.data).setTariffGroupId(((IdTitle)this.tariffGroup.getSelectedItem()).getId());
                ((ContractTariff)this.data).setPosition(Utils.parseInt((String)this.tariffPosition.getText(), (int)0));
                ((ContractTariff)this.data).setPeriod(this.periodPanel.getPeriod());
                ((ContractTariff)this.data).setComment(this.tariffComment.getText());
                ((ContractTariff)this.data).setId(((ContractTariffService)((ClientContext)ContractCommonTariff.this.getContext()).getWebService(ContractTariffService.class)).contractTariffUpdate((ContractTariff)this.data));
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)ContractCommonTariff.this.getContext()).getContractId()));
                ContractCommonTariff.this.performAction("refresh");
                return true;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
        }
    }
}

