/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TariffLabelManager {
    protected static final String TABLE_TARIFF_LABEL = "tariff_label";
    protected static final String TABLE_TARIFF_LABEL_LINK = "tariff_label_link";
    private Connection con;

    public TariffLabelManager(Connection con) {
        this.con = con;
    }

    public List<TariffLabelItem> getTariffLabelItemList() throws BGException {
        ArrayList<TariffLabelItem> result = new ArrayList<TariffLabelItem>();
        try {
            TariffLabelItem tariffLabelItem;
            HashMap<Integer, TariffLabelItem> map = new HashMap<Integer, TariffLabelItem>();
            Statement st = this.con.createStatement();
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_TARIFF_LABEL).append(" ORDER BY title");
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                tariffLabelItem = this.getTariffLabelItemFromRS(rs);
                map.put(tariffLabelItem.getId(), tariffLabelItem);
                result.add(tariffLabelItem);
            }
            rs.close();
            query.setLength(0);
            query.append("SELECT label_id, count(*) FROM ").append(TABLE_TARIFF_LABEL_LINK).append(" GROUP BY label_id");
            rs = st.executeQuery(query.toString());
            while (rs.next()) {
                tariffLabelItem = (TariffLabelItem)((Object)map.get(rs.getInt(1)));
                if (tariffLabelItem == null) continue;
                tariffLabelItem.setTariffLinkCount(rs.getInt(2));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Set<Integer> getTariffLabelIds(int tariffPlanId) throws BGException {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            StringBuilder query = new StringBuilder("SELECT label_id FROM ").append(TABLE_TARIFF_LABEL_LINK).append(" WHERE tariff_id=").append(tariffPlanId);
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Set<Integer> getTariffIdsByLabelId(int labelId) throws BGException {
        HashSet<Integer> result = new HashSet<Integer>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT tariff_id FROM tariff_label_link WHERE label_id=?");){
            ps.setInt(1, labelId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt("tariff_id"));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void setTariffLabelIds(int tariffPlanId, Set<Integer> labelIds) throws BGException {
        try {
            StringBuilder query = new StringBuilder("DELETE FROM ").append(TABLE_TARIFF_LABEL_LINK).append(" WHERE tariff_id=").append(tariffPlanId);
            Statement st = this.con.createStatement();
            st.executeUpdate(query.toString());
            st.close();
            query.setLength(0);
            query.append("INSERT INTO ").append(TABLE_TARIFF_LABEL_LINK).append(" SET tariff_id=").append(tariffPlanId).append(", label_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            for (Integer id : labelIds) {
                ps.setInt(1, id);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateTariffLabelTreeItem(TariffLabelItem tariffLabelItem) throws BGException {
        try {
            if (tariffLabelItem == null) {
                throw new NullPointerException("tariffLabelItem is null!");
            }
            StringBuilder query = new StringBuilder();
            if (tariffLabelItem.getId() > 0) {
                query.append("UPDATE ");
                query.append(TABLE_TARIFF_LABEL);
                query.append(" SET parent_id=?, title=? WHERE id=?");
            } else {
                query.append("INSERT INTO ");
                query.append(TABLE_TARIFF_LABEL);
                query.append(" SET parent_id=?, title=?");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, tariffLabelItem.getParentId());
            ps.setString(2, tariffLabelItem.getTitle());
            if (tariffLabelItem.getId() > 0) {
                ps.setInt(3, tariffLabelItem.getId());
            }
            ps.executeUpdate();
            if (tariffLabelItem.getId() < 0) {
                tariffLabelItem.setId(ServerUtils.lastInsertId(this.con));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void removeTariffLabelItem(int tariffLabelItemId) throws BGException {
        try {
            Statement st = this.con.createStatement();
            StringBuilder query = new StringBuilder("DELETE FROM ").append(TABLE_TARIFF_LABEL_LINK).append(" WHERE label_id=").append(tariffLabelItemId);
            st.executeUpdate(query.toString());
            query.setLength(0);
            query.append("DELETE FROM ").append(TABLE_TARIFF_LABEL).append(" WHERE id=").append(tariffLabelItemId);
            st.executeUpdate(query.toString());
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private TariffLabelItem getTariffLabelItemFromRS(ResultSet rs) throws SQLException {
        TariffLabelItem tariffLabelItem = new TariffLabelItem();
        tariffLabelItem.setId(rs.getInt("id"));
        tariffLabelItem.setParentId(rs.getInt("parent_id"));
        tariffLabelItem.setTitle(rs.getString("title"));
        return tariffLabelItem;
    }
}

