/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;

public abstract class DeviceDao<D extends Device<D, T>, T extends DeviceType>
extends AbstractEntityDao<D> {
    private static final Logger log = LogManager.getLogger();
    private final Directory<T> deviceTypeDir;
    protected final String TABLE_INV_DEVICE_GROUP_LINK;
    private boolean loadDeviceGroupLink = true;
    private PreparedStatement getGroupsPS = null;
    private T folderType = this.newDeviceType(0, "\u041f\u0430\u043f\u043a\u0430");

    public DeviceDao(Connection con, int moduleId, int userId, String tableName, EntityAttrDaoSupport entityAttrDaoSupport) throws BGException {
        super(con, moduleId, userId, tableName, tableName, entityAttrDaoSupport);
        this.deviceTypeDir = this.getTypeDir();
        this.TABLE_INV_DEVICE_GROUP_LINK = "inv_device_group_link_" + moduleId;
    }

    protected abstract D newDevice();

    protected abstract T newDeviceType(int var1, String var2);

    protected abstract Directory<T> getTypeDir() throws BGException;

    @Override
    protected D getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        D result = this.newDevice();
        if (this.loadDeviceGroupLink && this.getGroupsPS == null) {
            this.getGroupsPS = this.con.prepareStatement("SELECT deviceGroupId FROM " + this.TABLE_INV_DEVICE_GROUP_LINK + " WHERE deviceId=?");
        }
        DeviceDao.getFromRS(rs, this.deviceTypeDir, this.folderType, this.loadDeviceGroupLink ? this.getGroupsPS : null, result);
        return result;
    }

    public static <T extends DeviceType, D extends Device<D, T>> void getFromRS(ResultSet rs, Directory<T> deviceTypeDir, T folderType, PreparedStatement getGroupsPS, D result) throws SQLException, BGException {
        result.setId(rs.getInt("id"));
        result.setSort(rs.getInt("sort"));
        result.setEntityId(rs.getInt("entityId"));
        result.setParentId(rs.getInt("parentId"));
        result.setDeviceTypeId(rs.getInt("deviceTypeId"));
        result.setTitle(rs.getString("title"));
        result.setHost(rs.getString("host"));
        result.setIdentifier(rs.getString("identifier"));
        result.setDateFrom(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dateFrom")));
        result.setDateTo(TimeUtils.convertSqlDateToDate((Date)rs.getDate("dateTo")));
        result.setUsername(rs.getString("username"));
        result.setPassword(rs.getString("password"));
        result.setSecret(rs.getString("secret"));
        result.setConfig(rs.getString("config"));
        result.setComment(rs.getString("comment"));
        result.setUptime(rs.getString("uptime"));
        result.setUptimeTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("uptimeTime")));
        result.setOrderManagerDisabled(rs.getBoolean("orderManagerDisabled"));
        if (getGroupsPS != null) {
            HashSet<Integer> deviceGroupIds = new HashSet<Integer>();
            getGroupsPS.setInt(1, result.getId());
            ResultSet getGroupsRS = getGroupsPS.executeQuery();
            while (getGroupsRS.next()) {
                deviceGroupIds.add(getGroupsRS.getInt(1));
            }
            getGroupsRS.close();
            result.setDeviceGroupIds(deviceGroupIds);
        }
        DeviceType deviceType = null;
        deviceType = result.getDeviceTypeId() == 0 ? (DeviceType)folderType : (DeviceType)deviceTypeDir.get(result.getDeviceTypeId());
        if (deviceType != null) {
            result.setDeviceType(deviceType);
            result.setEntitySpecId(result.getDeviceType().getDeviceEntitySpecId());
        } else {
            log.error("Can't find device type=" + result.getDeviceTypeId());
        }
    }

    @Override
    public void update(D b) throws BGException {
        super.update(b);
    }

    protected void updateImpl(D b) throws BGException, SQLException {
        PreparedStatement ps;
        block22: {
            List<String> values = this.getValues();
            boolean update = b.getId() > 0;
            String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET " + values.stream().map(v -> v + "=?").collect(Collectors.joining(",")) + (update ? " WHERE id=?" : "");
            ps = this.con.prepareStatement(query, 1);
            try {
                int idx = 1;
                ps.setInt(idx++, b.getSort());
                ps.setInt(idx++, b.getParentId());
                ps.setInt(idx++, b.getDeviceTypeId());
                ps.setString(idx++, b.getIdentifier());
                ps.setString(idx++, b.getHost());
                ps.setString(idx++, b.getTitle());
                ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)b.getDateFrom()));
                ps.setDate(idx++, TimeUtils.convertDateToSqlDate((java.util.Date)b.getDateTo()));
                ps.setString(idx++, b.getUsername());
                ps.setString(idx++, b.getPassword());
                ps.setString(idx++, b.getSecret());
                ps.setString(idx++, b.getConfig());
                ps.setString(idx++, b.getComment());
                ps.setBoolean(idx++, b.isOrderManagerDisabled());
                ps.setInt(idx++, b.getEntityId());
                idx = this.setExtraParams(b, ps, idx);
                if (update) {
                    ps.setInt(idx++, b.getId());
                }
                ps.executeUpdate();
                if (!update) {
                    b.setId(ServerUtils.lastInsertId(ps));
                    break block22;
                }
                try (PreparedStatement deleteGroupLinkPS = this.con.prepareStatement("DELETE FROM " + this.TABLE_INV_DEVICE_GROUP_LINK + " WHERE deviceId=?");){
                    deleteGroupLinkPS.setInt(1, b.getId());
                    deleteGroupLinkPS.executeUpdate();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        ps = this.con.prepareStatement("INSERT INTO " + this.TABLE_INV_DEVICE_GROUP_LINK + " SET deviceId=?, deviceGroupId=?");
        try {
            ps.setInt(1, b.getId());
            if (b.getDeviceGroupIds() != null) {
                for (Integer i : b.getDeviceGroupIds()) {
                    ps.setInt(2, i);
                    ps.executeUpdate();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    protected int setExtraParams(D device, PreparedStatement ps, int idx) throws SQLException {
        return idx;
    }

    protected List<String> getValues() {
        return Utils.toList((String)"sort, parentId, deviceTypeId, identifier, host, title, dateFrom, dateTo, username, password, secret, config, comment, orderManagerDisabled, entityId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<D> list(List<FilterEntityAttr> entityFilter, boolean loadDeviceGroupLink) throws BGException {
        this.loadDeviceGroupLink = loadDeviceGroupLink;
        try {
            List list = super.list(true, null, null, null, entityFilter, null, null, null, new Object[0]);
            return list;
        }
        finally {
            this.loadDeviceGroupLink = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<D> list(int deviceTypeId, boolean loadDeviceGroupLink) throws BGException {
        this.loadDeviceGroupLink = loadDeviceGroupLink;
        try {
            List list = super.list("deviceTypeId = ?", null, new Object[]{deviceTypeId});
            return list;
        }
        finally {
            this.loadDeviceGroupLink = true;
        }
    }

    @Deprecated
    public D root(String identifier, String host, int deviceType, Set<Integer> deviceGroupIds, List<FilterEntityAttr> entityFilter) throws BGException {
        return this.root(DeviceTreeFilter.builder().setIdentifier(identifier).setHost(host).setDeviceTypeIds(deviceType < 0 ? null : Collections.singleton(deviceType)).setDeviceGroupIds(deviceGroupIds).setEntityFilter(entityFilter).setLoadDeviceGroupLink(false).build());
    }

    public D root(DeviceTreeFilter deviceTreeFilter) throws BGException {
        this.loadDeviceGroupLink = deviceTreeFilter.isLoadDeviceGroupLink();
        List deviceList = super.list(true, null, null, "LEFT JOIN " + this.TABLE_INV_DEVICE_GROUP_LINK + " as deviceGroups ON deviceGroups.deviceId=" + this.tableName + ".id", deviceTreeFilter.getEntityFilter(), "(? OR identifier LIKE ?) AND (? OR host LIKE ?)" + (String)(deviceTreeFilter.getDeviceTypeIds() == null || deviceTreeFilter.getDeviceTypeIds().size() == 0 || deviceTreeFilter.getDeviceTypeIds().size() == 1 && deviceTreeFilter.getDeviceTypeIds().contains(-1) ? "" : " AND deviceTypeId IN (" + Utils.toString((Iterable)deviceTreeFilter.getDeviceTypeIds()) + ")") + " AND ((? OR (dateFrom IS NOT NULL AND dateFrom>=?)) AND (? OR (dateTo IS NOT NULL AND dateTo<=?))) AND ((? OR dateFrom IS NULL OR dateFrom<=?) AND (? OR dateTo IS NULL OR dateTo>=?))" + (String)(deviceTreeFilter.getDeviceGroupIds() == null || deviceTreeFilter.getDeviceGroupIds().size() == 0 ? "" : " AND deviceGroups.deviceGroupId IN (" + Utils.toString((Iterable)deviceTreeFilter.getDeviceGroupIds()) + ")"), this.tableName + ".id", null, Utils.isBlankString((String)deviceTreeFilter.getIdentifier()), deviceTreeFilter.getIdentifier() + "%", Utils.isBlankString((String)deviceTreeFilter.getHost()), deviceTreeFilter.getHost() + "%", deviceTreeFilter.getDateFrom() == null, TimeUtils.convertDateToSqlDate((java.util.Date)deviceTreeFilter.getDateFrom()), deviceTreeFilter.getDateTo() == null, TimeUtils.convertDateToSqlDate((java.util.Date)deviceTreeFilter.getDateTo()), deviceTreeFilter.getIntersectDateTo() == null, TimeUtils.convertDateToSqlDate((java.util.Date)deviceTreeFilter.getIntersectDateTo()), deviceTreeFilter.getIntersectDateFrom() == null, TimeUtils.convertDateToSqlDate((java.util.Date)deviceTreeFilter.getIntersectDateFrom()));
        Object root = this.getTreeFromList(deviceList, -1);
        this.loadDeviceGroupLink = true;
        return (D)root;
    }

    public D node(List<FilterEntityAttr> entityFilter, int deviceId, boolean loadDeviceGroupLink) throws BGException {
        return this.node(entityFilter, deviceId, null, loadDeviceGroupLink);
    }

    public D node(List<FilterEntityAttr> entityFilter, int deviceId, String filter, boolean loadDeviceGroupLink) throws BGException {
        this.loadDeviceGroupLink = loadDeviceGroupLink;
        List deviceList = super.list(true, null, null, null, entityFilter, filter, null, null, new Object[0]);
        Object root = this.getTreeFromList(deviceList, deviceId);
        this.loadDeviceGroupLink = true;
        return (D)root;
    }

    protected D getTreeFromList(List<D> deviceList, int deviceId) {
        Device root;
        LinkedHashMap<Integer, Device> deviceMap = new LinkedHashMap<Integer, Device>();
        if (deviceId > 0) {
            root = null;
        } else {
            root = (Device)this.newDevice();
            root.setId(0);
            root.setChildren(new ArrayList());
            deviceMap.put(root.getId(), root);
        }
        for (Device d : deviceList) {
            deviceMap.put(d.getId(), d);
            d.setChildren(new ArrayList());
        }
        if (deviceId > 0) {
            for (Device d : deviceList) {
                Device parent;
                if (d.getId() == deviceId) {
                    root = d;
                }
                if ((parent = (Device)deviceMap.get(d.getParentId())) == null) continue;
                parent.getChildren().add(d);
            }
        } else {
            for (Device d : deviceList) {
                Device parent = (Device)deviceMap.get(d.getParentId());
                if (parent != null) {
                    parent.getChildren().add(d);
                    continue;
                }
                root.getChildren().add(d);
            }
        }
        return (D)root;
    }

    public void move(int newParentId, Set<Integer> children) throws BGException {
        if (newParentId < 0 || children == null || children.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        for (Integer id : children) {
            D child = this.node(null, id, false);
            if (this.find(child, newParentId) == null) continue;
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u0432 \u0434\u043e\u0447\u0435\u0440\u043d\u0435\u0435.");
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET parentId=? WHERE id IN (" + Utils.toString(children) + ")");
            ps.setInt(1, newParentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private D find(D device, int id) {
        if (device.getId() == id) {
            return device;
        }
        if (device.getChildren() != null) {
            for (Device child : device.getChildren()) {
                Device result = this.find(child, id);
                if (result == null) continue;
                return (D)result;
            }
        }
        return null;
    }

    public void updateUptime(int id, String uptime, java.util.Date uptimeTime) throws BGException {
        if (id < 0) {
            throw new BGIllegalArgumentException();
        }
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET uptime=?, uptimeTime=? WHERE id=?");){
            ps.setString(1, uptime);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((java.util.Date)uptimeTime));
            ps.setInt(3, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<D> listByUptimeTime(java.util.Date uptimeTime, String orderBy, Page page) throws BGException {
        this.loadDeviceGroupLink = false;
        try {
            Result result = this.list(page, "uptimeTime IS NULL OR uptimeTime<?", orderBy, TimeUtils.convertDateToTimestamp((java.util.Date)uptimeTime));
            List list = result.getList();
            return list;
        }
        finally {
            this.loadDeviceGroupLink = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<D> listByType(int deviceTypeId, boolean loadDeviceGroupLink) throws BGException {
        this.loadDeviceGroupLink = false;
        try {
            List list = this.list("deviceTypeId=?", "", new Object[]{deviceTypeId});
            return list;
        }
        finally {
            this.loadDeviceGroupLink = true;
        }
    }

    protected int deleteImpl(int id) throws BGException {
        int result = 0;
        String query = "DELETE FROM " + this.TABLE_INV_DEVICE_GROUP_LINK + " WHERE deviceId=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            result = super.deleteImpl(id);
            psDelete.setInt(1, id);
            psDelete.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

