/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import ru.bitel.common.XMLUtils;

class XMLEventIterator
implements Iterator<XMLEvent>,
Iterable<XMLEvent> {
    protected final String[] path;
    protected final XMLUtils.BGXMLEventReader reader;
    protected int pathDepth = 1;
    protected int currentDepth = -1;
    protected int currentGlobalDepth = -1;
    protected XMLEvent event = null;

    public XMLEventIterator(XMLUtils.BGXMLEventReader reader, String path) {
        this.reader = reader;
        this.path = XMLUtils.slashPattern.split(path);
    }

    @Override
    public Iterator<XMLEvent> iterator() {
        this.pathDepth = 0;
        this.currentDepth = -1;
        this.currentGlobalDepth = this.reader.getCurrentDepth();
        return this;
    }

    private final boolean isInPath(int currentDepth) {
        return this.path[currentDepth].equals(this.event.asStartElement().getName().getLocalPart()) || "*".equals(this.path[currentDepth]);
    }

    private final boolean isInPathEndElement(int currentDepth) {
        return this.path[currentDepth].equals(this.event.asEndElement().getName().getLocalPart()) || "*".equals(this.path[currentDepth]);
    }

    @Override
    public boolean hasNext() {
        try {
            this.event = this.reader.peek();
            while (!this.event.isEndDocument()) {
                switch (this.event.getEventType()) {
                    case 1: {
                        ++this.currentDepth;
                        if (this.pathDepth >= this.path.length || this.currentDepth == this.pathDepth && this.isInPath(this.currentDepth)) {
                            ++this.pathDepth;
                        }
                        if (this.pathDepth != this.path.length) break;
                        this.currentGlobalDepth = this.reader.getCurrentDepth();
                        this.reader.next();
                        return true;
                    }
                    case 2: {
                        if (this.pathDepth >= this.path.length || this.currentDepth == this.pathDepth && this.isInPathEndElement(this.currentDepth)) {
                            --this.pathDepth;
                        }
                        if (this.currentDepth-- != -1) break;
                        return false;
                    }
                    case 4: {
                        break;
                    }
                    case 7: {
                        if ("".equals(this.path[0])) {
                            ++this.pathDepth;
                        }
                        ++this.currentDepth;
                        break;
                    }
                }
                this.reader.next();
                this.event = this.reader.peek();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public XMLEvent next() {
        return this.event.asStartElement();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

