/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.api;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiMethod;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiToken;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonKassaApiClient;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MegafonApiClient {
    private static final Logger log = LogManager.getLogger();
    public static final String MEGAFON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private final HttpClient httpClient;
    private final ModuleSetup moduleSetup;
    private final int moduleId;
    private final boolean isTestWorkMode;

    public MegafonApiClient(int moduleId) {
        this.moduleId = moduleId;
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
        this.isTestWorkMode = this.moduleSetup.getInt("megafon.work.mode", 2) == 2;
    }

    public JSONObject getToken(String body) {
        String url = this.isTestWorkMode ? this.moduleSetup.get("megafon.token.url.test") : this.moduleSetup.get("megafon.token.url");
        URI uri = URI.create(url + MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_TOKEN, this.moduleSetup, "megafon.realm"));
        return new JSONObject(this.sendRequest(this.requestBuilder(uri, "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).build()));
    }

    public JSONArray getTariffInfo(String msisdn) {
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_TARIFF, pathParameters))).optJSONArray("items");
    }

    public JSONObject getAvailableProducts(String msisdn) {
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_AVAILABLE_PRODUCTS, pathParameters)));
    }

    public boolean checkActivateProduct(String msisdn, String productOfferingId, LocalDateTime dateFrom) throws BGException {
        JSONObject parameter = new JSONObject();
        parameter.put("productOfferingId", (Object)productOfferingId);
        JSONObject activationPeriod = new JSONObject();
        activationPeriod.put("dateFrom", (Object)TimeUtils.format((LocalDateTime)dateFrom, (String)MEGAFON_DATE_FORMAT));
        parameter.put("activationPeriod", (Object)activationPeriod);
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.CHECK_ACTIVATE, pathParameters));
        JSONObject response = this.sendPostRequest(uri, this.getRequestBody(parameter));
        JSONArray conflicts = response.optJSONArray("conflicts");
        if (conflicts.isEmpty()) {
            return true;
        }
        StringBuilder error = new StringBuilder("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b:\n");
        for (int i = 0; i < conflicts.length(); ++i) {
            JSONObject conflict = conflicts.getJSONObject(i);
            error.append("[\u041f\u0440\u043e\u0434\u0443\u043a\u0442: ").append(conflict.optString("productOfferingName")).append(", \u041e\u0448\u0438\u0431\u043a\u0430: ").append(conflict.optString("message")).append("]\n");
        }
        throw new BGException(error.toString());
    }

    public long productActivate(MegafonContractProduct contractProduct, String productOfferingId) {
        String msisdn = Utils.notBlankString((String)contractProduct.getMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn();
        return this.sendActivateRequest(msisdn, contractProduct.getStartTime(), contractProduct.getEndTime() != null ? contractProduct.getEndTime() : null, productOfferingId);
    }

    public long optionActivate(String msisdn, LocalDateTime startDate, LocalDateTime endDate, String offeringId) {
        return this.sendActivateRequest(msisdn, startDate, endDate, offeringId);
    }

    private long sendActivateRequest(String msisdn, LocalDateTime startDate, LocalDateTime dateTo, String productOfferingId) {
        JSONObject parameter = new JSONObject();
        parameter.put("productOfferingId", (Object)productOfferingId);
        if (startDate != null) {
            JSONObject activationPeriod = new JSONObject();
            activationPeriod.put("dateFrom", (Object)TimeUtils.format((LocalDateTime)startDate, (String)MEGAFON_DATE_FORMAT));
            if (dateTo != null) {
                activationPeriod.put("dateTo", (Object)TimeUtils.format((LocalDateTime)dateTo, (String)MEGAFON_DATE_FORMAT));
            }
            parameter.put("activationPeriod", (Object)activationPeriod);
        }
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.PRODUCT_ACTIVATE, pathParameters));
        JSONObject response = this.sendPostRequest(uri, this.getRequestBody(parameter));
        long orderId = response.optLong("orderId", 0L);
        if (orderId == 0L) {
            throw new RuntimeException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
        }
        return orderId;
    }

    public long productDeactivate(MegafonContractProduct contractProduct, String productOfferingId) {
        String msisdn = Utils.notBlankString((String)contractProduct.getMsisdn()) ? contractProduct.getMsisdn() : contractProduct.getAdditionalMsisdn();
        JSONObject pathParameters = new JSONObject();
        pathParameters.put("msisdn", (Object)msisdn);
        JSONObject parameter = new JSONObject();
        parameter.put("productId", this.getProductId(msisdn, productOfferingId));
        parameter.put("deactivationDateTime", (Object)TimeUtils.format((LocalDateTime)contractProduct.getEndTime(), (String)MEGAFON_DATE_FORMAT));
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.PRODUCT_DEACTIVATE, pathParameters));
        JSONObject response = this.sendPostRequest(uri, this.getRequestBody(parameter));
        long orderId = response.optLong("orderId");
        if (orderId == 0L) {
            throw new RuntimeException("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0443\u0436\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d!");
        }
        return orderId;
    }

    public JSONObject getOrderInfo(long orderId) {
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_ORDER_ID, new JSONObject()) + "/" + orderId));
    }

    public JSONObject getNextProductCharges(String msisdn) {
        JSONObject pathParameter = new JSONObject();
        pathParameter.put("msisdn", (Object)msisdn);
        return this.sendGetRequest(this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_NEXT_PRODUCT_CHARGES, pathParameter)), null);
    }

    public JSONObject activateSim(int contractId, String msisdn) {
        log.debug("Activate sim request. MSISDN=" + msisdn);
        JSONObject queryParameter = new JSONObject();
        queryParameter.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.ACTIVATE_SIM, new JSONObject()) + this.requestParametersToString(queryParameter));
        JSONObject response = this.sendPostRequest(uri, new JSONObject());
        if (response.optInt("activ_status", -1) != 2) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0438\u043c. MSISDN=" + msisdn + ", \u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438: " + response);
        }
        log.debug("Activate sim. MSISDN=" + msisdn);
        MegafonKassaApiClient kassaApiClient = new MegafonKassaApiClient(this.moduleSetup);
        log.debug("AddPayment amount=150, msisdn=" + msisdn);
        kassaApiClient.addPayment(contractId, msisdn, new BigDecimal(150), "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0441\u0438\u043c-\u043a\u0430\u0440\u0442\u044b msisdn=" + msisdn);
        return response;
    }

    public JSONObject getCustomersInfo(String msisdn) {
        JSONObject pathParameter = new JSONObject();
        pathParameter.put("msisdn", (Object)msisdn);
        URI uri = this.createURI(MegafonApiMethod.getPath(MegafonApiMethod.Method.GET_CUSTOMERS_INFO, pathParameter));
        return this.sendGetRequest(uri);
    }

    private JSONObject getRequestBody(JSONObject parameter) {
        JSONObject body = new JSONObject();
        JSONArray arr = new JSONArray();
        arr.put((Object)parameter);
        body.put("parameters", (Object)arr);
        return body;
    }

    private long getProductId(String msisdn, String productOfferingId) {
        long productId = 0L;
        JSONArray tariffs = this.getTariffInfo(msisdn);
        for (int i = 0; i < tariffs.length(); ++i) {
            JSONObject tariff = tariffs.optJSONObject(i);
            long productOfferingIdFromMegafon = tariff.optLong("productOfferingId");
            if (productOfferingIdFromMegafon != Utils.parseLong((String)productOfferingId)) continue;
            productId = tariff.optLong("productId");
            break;
        }
        if (productId <= 0L) {
            throw new RuntimeException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c productId \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u0430 \u043d\u0430 \u043d\u043e\u043c\u0435\u0440\u0435 = " + msisdn);
        }
        return productId;
    }

    public JSONObject sendPostRequest(URI uri, JSONObject body) {
        String body0 = body != null && body.length() > 0 ? body.toString() : "";
        return new JSONObject(this.sendRequest(this.requestBuilder(uri, "application/json").header("Authorization", "Bearer " + MegafonApiToken.getToken(this.moduleId)).POST(HttpRequest.BodyPublishers.ofString(body0)).build()));
    }

    public JSONObject sendGetRequest(URI uri) {
        return this.sendGetRequest(uri, null);
    }

    public JSONObject sendGetRequest(URI uri, JSONObject requestParameters) {
        if (requestParameters != null) {
            uri = URI.create(uri.toString() + this.requestParametersToString(requestParameters));
        }
        return new JSONObject(this.sendRequest(this.requestBuilder(uri, "application/x-www-form-urlencoded").header("Authorization", "Bearer " + MegafonApiToken.getToken(this.moduleId)).GET().build()));
    }

    public HttpRequest.Builder requestBuilder(URI uri, String contentType) {
        return HttpRequest.newBuilder(uri).header("Accept", "application/json").header("Content-Type", Utils.isBlankString((String)contentType) ? "application/json" : contentType);
    }

    public String sendRequest(HttpRequest request) {
        log.debug(String.format("Request to Megafon => method=%s, URI=%s, body=%s", request.method(), request.uri().toString(), request.bodyPublisher().isPresent() ? request.bodyPublisher().get().toString() : ""));
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            String responseData = response.body();
            log.debug(String.format("Response => statusCode=%s, method=%s, body=%s, headers=%s", statusCode, request.method(), responseData, response.headers().toString()));
            if (statusCode != 200) {
                throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435. \u041a\u043e\u0434:" + response.statusCode() + ", message:" + response.body());
            }
            return responseData;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private URI createURI(String path) {
        String url;
        String string = url = this.isTestWorkMode ? this.moduleSetup.get("megafon.url.test") : this.moduleSetup.get("megafon.api.url");
        if (Utils.isBlankString((String)url)) {
            throw new RuntimeException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0430\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432");
        }
        return URI.create(url + path);
    }

    private String requestParametersToString(JSONObject parameters) {
        String params = "";
        if (parameters != null && !parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder("?");
            for (String key : parameters.keySet()) {
                String value = parameters.optString(key);
                if (!Utils.notBlankString((String)value)) continue;
                sb.append(key).append("=").append(value).append("&");
            }
            params = sb.toString();
            if (params.length() > 1) {
                params = params.substring(0, params.length() - 1);
            }
        }
        return params;
    }
}

