/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.servlet;

import bitel.billing.server.util.Config;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.tv.server.handler.HttpHandler;
import ru.bitel.bgbilling.modules.tv.server.handler.TvWsHandler;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.Utils;

@WebServlet(name="TvExecutor", urlPatterns={"/tv-ws/*", "/tv/*"})
public class TvExecutor
extends CommonExecutor {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(TvExecutor.class);
    private TvWsHandler wsHandler = null;
    protected static final Pattern patternSlash = Pattern.compile("/");

    public void init() throws ServletException {
        try {
            this.wsHandler = new TvWsHandler(this.getServletContext());
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (httpServletRequest.getPathInfo() != null) {
            if (httpServletRequest.getPathInfo().startsWith("/rest/")) {
                String[] params = patternSlash.split(httpServletRequest.getPathInfo());
                if (params.length >= 3) {
                    int moduleId = Utils.parseInt((String)params[2]);
                    String handler = params[3];
                    Conf conf = (Conf)Setup.getSetup().getConfig(moduleId, Conf.class);
                    HttpHandler handlerImpl = conf.handlerMap.get(handler);
                    if (handlerImpl != null) {
                        handlerImpl.handle(moduleId, httpServletRequest, httpServletResponse);
                    } else {
                        httpServletResponse.sendError(404);
                    }
                }
            } else {
                this.wsHandler.handle(httpServletRequest, httpServletResponse);
                return;
            }
        }
    }

    public static class Conf
    extends Config {
        private Map<String, HttpHandler> handlerMap = new HashMap<String, HttpHandler>();

        public Conf(int moduleId, ParameterMap moduleSetup, Setup serverSetup) {
            super(moduleId, moduleSetup, serverSetup);
            for (Map.Entry e : moduleSetup.subKeyed("tv.rest.handler.").entrySet()) {
                try {
                    this.handlerMap.put((String)e.getKey(), (HttpHandler)DynamicClassManager.getInstance().newProxyInstance(HttpHandler.class, ((ParameterMap)e.getValue()).get("class", "")));
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        }
    }
}

