/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.operator.sovintel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Operator;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SovintelAbonentData {
    private static Logger log = LogManager.getLogger();
    public int contractId;
    public String contractTitle;
    public String fullName;
    public String jurStatus;
    public Date date1;
    public Date date2;
    public String jurAddress;
    public String inn;
    public String kpp;
    public String countryCode;
    public String contractType;
    public String locationCode;
    public boolean info;
    public boolean notResident;
    public boolean diplomat;
    static final AtomicInteger i = new AtomicInteger();

    public static List<SovintelAbonentData> extractData(Connection con, Operator oper, Date month, Set<Integer> changedCodes) {
        ArrayList<SovintelAbonentData> result = new ArrayList<SovintelAbonentData>();
        Preferences operSetup = oper.getOperatorSetup();
        List fullNameParams = Utils.toIntegerList((String)operSetup.get("param.name", "0"));
        List jurAdressParams = Utils.toIntegerList((String)operSetup.get("param.address", "0"));
        int innParam = operSetup.getInt("param.inn", 0);
        int kppParam = operSetup.getInt("param.kpp", 0);
        int diplomatParam = operSetup.getInt("param.diplomat", 0);
        int notResidentParam = operSetup.getInt("param.notResident", 0);
        int infoParam = operSetup.getInt("param.info", 0);
        String countryCode = operSetup.get("country.code", "0");
        String locationCode = operSetup.get("location.code", "0");
        try (ContractParameterPrefDao prefDao = new ContractParameterPrefDao(con);){
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add(new TextParamField(Utils.toString((Iterable)fullNameParams), "name", "contract.comment"));
            if (jurAdressParams.size() > 0 && ((ContractParameterPref)prefDao.get(((Integer)jurAdressParams.get(0)).intValue())).getType() == ContractParameterPrefType.TYPE_ADDRESS) {
                fields.add(new AddressParamField(Utils.toString((Iterable)jurAdressParams), "address"));
            } else {
                fields.add(new TextParamField(Utils.toString((Iterable)jurAdressParams), "address", null));
            }
            fields.add(new TextParamField(innParam, "inn"));
            fields.add(new TextParamField(kppParam, "kpp"));
            fields.add(new FlagParamField(diplomatParam, "diplomat"));
            fields.add(new FlagParamField(notResidentParam, "notResident"));
            fields.add(new FlagParamField(infoParam, "info"));
            boolean sub = operSetup.getInt("subContract", 0) > 0;
            StringBuilder sb = new StringBuilder(200);
            sb.append("SELECT ");
            if (sub) {
                sb.append("sub_contract.id, sub_contract.title, sub_contract.fc + 1, sub_contract.date1, sub_contract.date2, ");
            } else {
                sb.append("contract.id, contract.title, contract.fc + 1, contract.date1, contract.date2, ");
            }
            for (Field f : fields) {
                if (f.other == null) {
                    sb.append(f.alias).append(".").append(f.field).append(" as ").append(f.name).append(", ");
                    continue;
                }
                sb.append("IF(").append(f.alias).append(".").append(f.field).append(", ");
                sb.append(f.alias).append(".").append(f.field).append(", ");
                sb.append(f.other).append(") as ").append(f.name).append(", ");
            }
            sb.setLength(sb.length() - 2);
            if (sub) {
                sb.append(" FROM contract AS sub_contract ");
                sb.append(" INNER JOIN contract ON contract.id=sub_contract.scid ");
            } else {
                sb.append(" FROM contract ");
            }
            sb.append(" INNER JOIN contract_tariff AS ct ON sub_contract.id=ct.cid AND ct.tpid IN (" + Utils.toString(oper.getTariffList()) + ") ");
            for (Field f : fields) {
                sb.append(" LEFT JOIN ").append(f.table).append(" as ").append(f.alias).append(" ON ").append(f.on.replaceAll(Pattern.quote(f.table), f.alias));
            }
            if (changedCodes != null) {
                sb.append(" WHERE sub_contract.id IN (" + Utils.toString(changedCodes) + ") ");
            }
            if (sub) {
                sb.append(" GROUP BY sub_contract.id");
            } else {
                sb.append(" GROUP BY contract.id");
            }
            log.info(sb.toString());
            PreparedStatement ps = con.prepareStatement(sb.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SovintelAbonentData data = new SovintelAbonentData();
                data.contractId = rs.getInt(1);
                data.contractTitle = rs.getString(2);
                int fc = rs.getInt(3);
                data.contractType = fc == 1 ? "8" : "1";
                data.jurStatus = String.valueOf(fc);
                data.date1 = rs.getDate(4);
                data.date2 = rs.getDate(5);
                data.fullName = rs.getString(6);
                data.jurAddress = rs.getString(7);
                data.inn = rs.getString(8);
                data.kpp = rs.getString(9);
                data.diplomat = rs.getInt(10) == 1;
                data.notResident = rs.getInt(11) == 1;
                data.info = rs.getInt(12) == 1;
                data.countryCode = countryCode;
                data.locationCode = locationCode;
                result.add(data);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static List<SovintelAbonentData> extractData2(Connection con, Operator oper, Date month, Set<Integer> changedCodes) {
        ArrayList<SovintelAbonentData> result = new ArrayList<SovintelAbonentData>();
        try {
            Preferences operSetup = oper.getOperatorSetup();
            String fullNameParams = operSetup.get("full.name.params", "0");
            String jurAdressParams = operSetup.get("jur.address.params", "0");
            String innPram = operSetup.get("inn.param", "0");
            String kppParam = operSetup.get("kpp.param", "0");
            String countryCode = operSetup.get("country.code", "0");
            String locationCode = operSetup.get("location.code", "0");
            String query = "SELECT sub_contract.id, sub_contract.title, IF(full_name.val, full_name.val, contract.comment), contract.fc + 1, sub_contract.date1, sub_contract.date2, IF(jur_addr.val, jur_addr.val, jur_addr_addr.address), inn.val, kpp.val  FROM contract AS sub_contract  INNER JOIN contract ON contract.id=sub_contract.scid  INNER JOIN contract_tariff AS ct ON sub_contract.id=ct.cid AND ct.tpid IN (" + Utils.toString(oper.getTariffList()) + ")  LEFT JOIN contract_parameter_type_1 AS full_name ON contract.id=full_name.cid AND full_name.pid IN ( " + fullNameParams + ")  LEFT JOIN contract_parameter_type_1 AS jur_addr ON contract.id=jur_addr.cid AND jur_addr.pid IN (" + jurAdressParams + ")  LEFT JOIN contract_parameter_type_2 AS jur_addr_addr ON contract.id=jur_addr_addr.cid AND jur_addr_addr.pid IN (" + jurAdressParams + ")  LEFT JOIN contract_parameter_type_1 AS inn ON contract.id=inn.cid AND inn.pid=" + innPram + " LEFT JOIN contract_parameter_type_1 AS kpp ON contract.id=kpp.cid AND kpp.pid=" + kppParam;
            if (changedCodes != null) {
                query = query + " WHERE sub_contract.id IN (" + Utils.toString(changedCodes) + ") ";
            }
            query = query + " GROUP BY sub_contract.id";
            PreparedStatement ps = con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SovintelAbonentData data = new SovintelAbonentData();
                data.contractId = rs.getInt(1);
                data.contractTitle = rs.getString(2);
                data.fullName = rs.getString(3);
                int fc = rs.getInt(4);
                data.jurStatus = String.valueOf(fc);
                data.date1 = rs.getDate(5);
                data.date2 = rs.getDate(6);
                data.jurAddress = rs.getString(7);
                data.contractType = fc == 1 ? "8" : "1";
                data.inn = rs.getString(8);
                data.kpp = rs.getString(9);
                data.countryCode = countryCode;
                data.locationCode = locationCode;
                result.add(data);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    static class TextParamField
    extends Field {
        public TextParamField(int pid, String name) {
            super("contract_parameter_type_1", "val", name, "contract_parameter_type_1.cid=contract.id AND contract_parameter_type_1.pid=" + pid, null);
        }

        public TextParamField(String pids, String name, String other) {
            super("contract_parameter_type_1", "val", name, "contract_parameter_type_1.cid=contract.id AND contract_parameter_type_1.pid IN(" + pids + ")", other);
        }
    }

    static class AddressParamField
    extends Field {
        public AddressParamField(int pid, String name) {
            super("contract_parameter_type_2", "address", name, "contract_parameter_type_2.cid=contract.id AND contract_parameter_type_2.pid=" + pid, null);
        }

        public AddressParamField(String pids, String name) {
            super("contract_parameter_type_2", "address", name, "contract_parameter_type_2.cid=contract.id AND contract_parameter_type_2.pid IN (" + pids + ")", null);
        }
    }

    static class FlagParamField
    extends Field {
        public FlagParamField(int pid, String name) {
            super("contract_parameter_type_5", "val", name, "contract_parameter_type_5.cid=contract.id AND contract_parameter_type_5.pid=" + pid, null);
        }
    }

    static class Field {
        final int id = i.incrementAndGet();
        final String table;
        final String alias;
        final String field;
        final String name;
        final String on;
        final String other;

        public Field(String table, String field, String name, String on, String other) {
            this.table = table;
            this.alias = table + this.id;
            this.field = field;
            this.name = name;
            this.on = on;
            this.other = other;
        }
    }

    static class ListParamValueField
    extends Field {
        public ListParamValueField(ListParamField field) {
            super("contract_parameter_type_7_values", "title", field.name.substring(0, field.name.length() - 3), "contract_parameter_type_7_values.id=" + field.alias + ".val", null);
        }
    }

    static class ListParamField
    extends Field {
        public ListParamField(int pid, String name) {
            super("contract_parameter_type_7", "val", name + "_id", "contract_parameter_type_7.cid=contract.id AND contract_parameter_type_7.pid=" + pid, null);
        }
    }
}

