/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.WebActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ActionAddPackage
extends WebActionBase {
    private String error = null;

    public void doAction() throws SQLException, BGException {
        PackageManager packageManager = new PackageManager(this.con, this.plugin);
        int packageId = this.getIntParameter("packageId", -1);
        if (packageId < 0) {
            this.error = "packageIdNotFound";
        } else {
            Package pkg = packageManager.getPackage(packageId);
            if (pkg == null) {
                this.error = "packageNotFound";
            } else if (!pkg.isStatus()) {
                this.error = "packageStatusDisabled";
            } else {
                BalanceUtils bu = new BalanceUtils(this.con);
                BigDecimal balance = bu.getBalance(LocalDate.now(), this.cid);
                if (balance.compareTo(pkg.getSumma()) == -1) {
                    this.error = "balanceNotValid";
                } else {
                    Date now = new Date();
                    Charge charge = new Charge();
                    charge.setContractId(this.cid);
                    charge.setDate(now);
                    charge.setTypeId(pkg.getChargeId());
                    charge.setSum(pkg.getSumma());
                    charge.setComment(pkg.getTitle() + " [" + pkg.getCount() + "\u043e\u0431\u0440. \u0437\u0430 " + pkg.getPeriod() + "\u0434\u043d.]");
                    try (ChargeDao chargeDao = new ChargeDao(this.con);){
                        chargeDao.update((Object)charge);
                    }
                    PackageContract packageContract = new PackageContract();
                    packageContract.setId(-1);
                    packageContract.setChargeId(charge.getId());
                    packageContract.setContractId(this.cid);
                    packageContract.setPackageId(pkg.getId());
                    packageContract.setCount(pkg.getCount());
                    packageContract.setCountUse(0);
                    packageContract.setDateFrom(now);
                    packageContract.setDateTo(new Date(now.getTime() + 86400000L * (long)pkg.getPeriod()));
                    packageContract.setSumma(pkg.getSumma());
                    packageContract.setUserId(-1);
                    packageManager.updatePackageContract(packageContract);
                    ServerUtils.commitConnection((Connection)this.con);
                    bu.updateBalance(now, this.cid);
                }
                bu.close();
            }
        }
        this.setData();
    }

    protected void setDataToRequest() throws BGException {
        if (this.error == null) {
            this.dataMap.put("result", true);
        } else {
            this.dataMap.put("result", false);
            this.dataMap.put("error", this.error);
        }
    }
}

