/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.admin;

import bitel.billing.module.common.BGControlPanelButtonGroup;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.helpdesk.client.admin.ActionConfig;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.ContractPanel_Helpdesk;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class HelpDeskMessageTab
extends BGUPanel {
    private JPanel filterPanel = null;
    private JToggleButton filterButton = null;
    private JToggleButton buttonOnlyNew = null;
    private JLabel recordCountLabel = new JLabel();
    private BGTextField title = new BGTextField();
    private IntTextField id_topic = new IntTextField();
    private BGTextField message = new BGTextField();
    private BGUComboBox<IdTitle> statusBox = new BGUComboBox();
    private BGUComboBox<UserInfo> userCmb = new BGUComboBox();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGControlPanelButtonGroup cpButtonGroupActiveArchive = new BGControlPanelButtonGroup();
    private BGControlPanelButtonGroup cpButtonGroupUserSelect = new BGControlPanelButtonGroup();
    private TableModelTopicMessages tableModel = new TableModelTopicMessages();
    private List<IdTitle> statusList = new ArrayList<IdTitle>();
    private List<IdTitle> categoryList = new ArrayList<IdTitle>();
    private List<IdTitle> subcategoryList = new ArrayList<IdTitle>();

    public HelpDeskMessageTab() {
        super(new ClientContext("ru.bitel.bgbilling.plugins.helpdesk", -1, -1, ActionConfig.class.getPackage().getName() + ".setup"));
    }

    protected void jbInit() throws Exception {
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        this.setLayout(new GridBagLayout());
        this.add(this.getInfoPanel(plugin), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getTablePanel(plugin), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getInfoPanel(BGPluginClient plugin) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(plugin.getResourceString("helpdeskAdminInfoPanelBorderTitle")));
        panel.add((Component)this.getInfoPanel2(plugin), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.getFilterPanel(plugin), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInfoPanel2(BGPluginClient plugin) {
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    HelpDeskMessageTab.this.performAction("refresh");
                }
            }
        });
        ActionListener actionListener = actionEvent -> {
            this.pagePanel.init();
            this.performAction("refresh");
        };
        this.cpButtonGroupActiveArchive.addButton(plugin.getResourceString("helpdeskAdminInfoPanelActiveButtonTitle"), "0");
        this.cpButtonGroupActiveArchive.addButton(plugin.getResourceString("helpdeskAdminInfoPanelArchiveButtonTitle"), "1");
        this.cpButtonGroupActiveArchive.setSelectedCommand("0");
        this.cpButtonGroupActiveArchive.addActionListener(actionListener);
        this.buttonOnlyNew = new JToggleButton();
        this.buttonOnlyNew.setText(plugin.getResourceString("helpdeskAdminInfoPanelOnlyNewButtonTitle"));
        this.buttonOnlyNew.addActionListener(actionListener);
        this.cpButtonGroupUserSelect.addButton(plugin.getResourceString("helpdeskAdminInfoPanelAllUserButtonTitle"), "all");
        this.cpButtonGroupUserSelect.addButton(plugin.getResourceString("helpdeskAdminInfoPanelNoneUserButtonTitle"), "none");
        this.cpButtonGroupUserSelect.addButton(plugin.getResourceString("helpdeskAdminInfoPanelMyUserButtonTitle"), "my");
        this.cpButtonGroupUserSelect.setSelectedCommand("all");
        this.cpButtonGroupUserSelect.addActionListener(actionListener);
        this.filterButton = new JToggleButton(plugin.getResourceString("helpdeskAdminInfoPanelFilterButtonTitle"));
        this.filterButton.setSelected(false);
        this.filterButton.addActionListener(a -> this.showFilter());
        JLabel label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelSubjectTitle"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.cpButtonGroupActiveArchive, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 25), 0, 0));
        panel.add((Component)this.buttonOnlyNew, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 25), 0, 0));
        panel.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.cpButtonGroupUserSelect, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 25), 0, 0));
        panel.add((Component)this.filterButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 35), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 15), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel(BGPluginClient plugin) {
        if (this.filterPanel == null) {
            this.id_topic.setMinimumSize(new Dimension(50, 30));
            this.filterPanel = new JPanel(new GridBagLayout());
            this.filterPanel.setVisible(false);
            JLabel label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelIDTitle"));
            this.filterPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)this.id_topic, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelTitleTitle"));
            this.filterPanel.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)this.title, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelStatusTitle"));
            this.filterPanel.add((Component)label, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)this.statusBox, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelPeriodTitle"));
            this.filterPanel.add((Component)label, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
            this.filterPanel.add((Component)this.periodPanel, new GridBagConstraints(7, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
            label = new JLabel("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440");
            this.filterPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)this.userCmb, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            label = new JLabel(plugin.getResourceString("helpdeskAdminInfoPanelMessageTitle"));
            this.filterPanel.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)this.message, new GridBagConstraints(3, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            BGButton buttonSearch = new BGButton(plugin.getResourceString("helpdeskAdminInfoPanelSearchButtonTitle"));
            buttonSearch.addActionListener(actionEvent -> {
                this.pagePanel.init();
                this.performAction("refresh");
            });
            BGButton buttonReset = new BGButton(plugin.getResourceString("helpdeskAdminInfoPanelResetButtonTitle"));
            buttonReset.addActionListener(actionEvent -> {
                this.pagePanel.init();
                this.resetFilter();
                this.performAction("refresh");
            });
            this.filterPanel.add((Component)buttonSearch, new GridBagConstraints(7, 1, 1, 1, 0.005, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.filterPanel.add((Component)buttonReset, new GridBagConstraints(8, 1, 1, 1, 0.005, 0.0, 10, 2, new Insets(0, 5, 5, 8), 0, 0));
        }
        return this.filterPanel;
    }

    private JPanel getTablePanel(BGPluginClient plugin) {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    HelpDeskMessageTab.this.gotoContract();
                }
            }
        });
        table.enableSearchField();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(plugin.getResourceString("helpdeskAdminTableBorderTitle")));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void showFilter() {
        this.filterPanel.setVisible(this.filterButton.isSelected());
        if (!this.filterButton.isSelected()) {
            this.resetFilter();
        }
    }

    private void resetFilter() {
        this.message.setText("");
        this.id_topic.setText("");
        this.title.setText("");
        this.periodPanel.setDateCalendar1(null);
        this.periodPanel.setDateCalendar2(null);
        if (this.statusBox.getModel().getSize() > 0) {
            this.statusBox.setSelectedIndex(0);
        }
        this.userCmb.setSelectedIndex(0);
    }

    private void gotoContract() {
        Topic topic = (Topic)this.tableModel.getSelectedRow();
        if (topic == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            int contractId = topic.getContractId();
            if (contractId > 0) {
                this.openContract(contractId, ContractPanel_Helpdesk.class.getName(), topic.getId());
            }
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            try {
                UserInfo tempUser = new UserInfo();
                tempUser.setName("---");
                tempUser.setId(-1);
                List users = ((UserService)((ClientContext)this.getContext()).getWebService(UserService.class)).userInfoList();
                users.add(0, tempUser);
                int index = this.userCmb.getSelectedIndex();
                this.userCmb.setData(users);
                if (index >= 0) {
                    this.userCmb.setSelectedIndex(index);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            if (this.statusBox.getData() == null) {
                this.statusList = ((HelpdeskService)((ClientContext)this.getContext()).getWebService(HelpdeskService.class)).topicStatusList();
                ArrayList<IdTitle> list = new ArrayList<IdTitle>(this.statusList);
                list.add(0, new IdTitle(-1, "---------"));
                this.statusBox.setData(list);
                this.categoryList.addAll(((HelpdeskService)((ClientContext)this.getContext()).getWebService(HelpdeskService.class)).categoryList());
                this.subcategoryList.addAll(((HelpdeskService)((ClientContext)this.getContext()).getWebService(HelpdeskService.class)).subcategoryList());
            }
            UserInfo user = (UserInfo)this.userCmb.getSelectedItem();
            SearchResult searchResult = ((HelpdeskService)((ClientContext)this.getContext()).getWebService(HelpdeskService.class)).topicSearch(Utils.parseInt((String)this.id_topic.getText().trim()), this.title.getText(), this.message.getText().trim(), ((IdTitle)this.statusBox.getSelectedItem()).getId(), user != null && user.getId() > 0 ? String.valueOf(user.getId()) : this.cpButtonGroupUserSelect.getSelectedCommand(), this.buttonOnlyNew.isSelected(), "1".equals(this.cpButtonGroupActiveArchive.getSelectedCommand()), this.periodPanel.getPeriod(), this.pagePanel.getPage());
            this.tableModel.setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
        });
    }

    class TableModelTopicMessages
    extends BGTableModel<Topic> {
        public TableModelTopicMessages() {
            super(TableModelTopicMessages.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 (\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439)", 100, 300, -1, "contractComment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0435\u043c\u0430", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f (\u041f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f)", 50, 150, 300, "category_subcategory", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u043e\u0431\u0449. [\u043d\u043e\u0432\u044b\u0445]", 50, 70, 120, "messages", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440", 100, 120, 200, "userName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 50, 150, 170, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412\u0441\u041f\u0421", 0, 80, 90, "timeFromLastMessage", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041f\u043e\u0441\u043b. \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 150, 150, 150, "lastMessageDate", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043d\u0430", 150, 150, 150, "date", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
        }

        public Object getValue(Topic topic, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("status".equals(identifier)) {
                return HelpDeskMessageTab.this.statusList.stream().filter(a -> a.getId() == topic.getStatus()).findFirst().map(a -> a.getTitle()).orElse("??? [" + topic.getStatus() + "]");
            }
            if ("contractComment".equals(identifier)) {
                String contractCommentString = "<html><nobr>" + topic.getContract() + " ( <b>" + topic.getContractComment() + "</b> )</nobr></html>";
                if (topic.getContractComment() == null || topic.getContractComment().equals("")) {
                    return topic.getContract();
                }
                if (topic.getContract() == null) {
                    return "<html><nobr> ( <b>" + topic.getContractComment() + "</b> )</nobr></html>";
                }
                return contractCommentString;
            }
            if ("messages".equals(identifier)) {
                return topic.getMessageCount() + " [" + topic.getMessageNewUserCount() + "]";
            }
            if ("timeFromLastMessage".equals(identifier)) {
                long seconds = topic.getSecondsFromLastMessage();
                if (seconds > 86400L) {
                    return seconds / 60L / 60L / 24L + "\u0414";
                }
                if (seconds > 3600L) {
                    return seconds / 3600L + "\u0427";
                }
                return seconds / 60L + "M";
            }
            if ("category_subcategory".equals(identifier)) {
                int id1 = topic.getCategoryId();
                String categoryTitle = id1 == 0 ? "\u043d\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d" : HelpDeskMessageTab.this.categoryList.stream().filter(a -> a.getId() == id1).map(a -> a.getTitle()).findFirst().orElse("??? [" + id1 + "]");
                int id2 = topic.getSubcategoryId();
                String subcategoryTitle = id2 == 0 ? "\u043d\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d" : HelpDeskMessageTab.this.subcategoryList.stream().filter(a -> a.getId() == id2).map(a -> a.getTitle()).findFirst().orElse("??? [" + id2 + "]");
                return categoryTitle + " ( " + subcategoryTitle + " )";
            }
            return super.getValue((Object)topic, column);
        }
    }
}

