/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.contract;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskMessagePaneRTF;
import ru.bitel.bgbilling.plugins.helpdesk.client.contract.HelpdeskMessageTab;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.FileInfo;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;

public class HelpdeskMessageEditor
extends BGPanel {
    public static final int MODE_SHOW_EDIT = 1;
    public static final int MODE_REPLY = 2;
    public static final int MODE_ANSWER = 3;
    private HelpdeskMessageTab panel = null;
    private int mode;
    private int topicId = 0;
    private int topicUserId = 0;
    private String myUserName = "";
    private String replyId = null;
    private String uuid = "";
    private JTextField from = new JTextField();
    private JTextField to = new JTextField();
    private JTextField comment = new JTextField();
    private HelpdeskMessagePaneRTF messageText = new HelpdeskMessagePaneRTF();
    private BGButton buttonReset = new BGButton("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
    private BGButton buttonSave = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    private BGButton buttonIReadThis = new BGButton("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e");
    private BGButton buttonPrev = new BGButton("<<<");
    private BGButton buttonNext = new BGButton(">>>");
    private BGButton buttonReply = new BGButton("\u041e\u0442\u0432\u0435\u0442\u0438\u0442\u044c");
    private BGSelectFilePanel selectFilePanel = new BGSelectFilePanel();
    private BGButton spellChecker = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u043e\u0440\u0444\u043e\u0433\u0440\u0430\u0444\u0438\u044e");
    private LineWrappingBorderLayout lineWrappingBorderLayout = new LineWrappingBorderLayout();
    private JButton buttonDownload = new JButton(ClientUtils.getIcon((String)"item_down.png"));
    private JButton buttonUpload = new JButton(ClientUtils.getIcon((String)"item_up.png"));
    private JButton buttonDelete = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private JButton buttonOpen = new JButton(ClientUtils.getIcon((String)"open.png"));
    private JButton buttonUploadClipboard = new JButton(ClientUtils.getIcon((String)"paste.png"));
    private JCheckBox checkBox = new JCheckBox("\u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u0441\u0442\u0440\u043e\u043a");
    private FilesTableModel filesTableModel = new FilesTableModel(FilesTableModel.class.getName());
    private BGUTable tableFiles = new BGUTable((TableModel)((Object)this.filesTableModel));
    private HelpdeskService helpdeskService = null;

    public HelpdeskMessageEditor(HelpdeskMessageTab contractPanel) {
        this.panel = contractPanel;
        this.jbInit();
    }

    private void jbInit() {
        this.buttonDownload.setToolTipText("\u0421\u043a\u0430\u0447\u0430\u0442\u044c");
        this.buttonDownload.addActionListener(e -> this.onFileDownloadButton());
        this.buttonOpen.setToolTipText("\u041e\u0442\u043a\u0440\u044b\u0442\u044c");
        this.buttonOpen.addActionListener(e -> this.onFileOpenButton());
        this.buttonUpload.setToolTipText("\u0417\u0430\u043a\u0430\u0447\u0430\u0442\u044c");
        this.buttonUpload.addActionListener(e -> this.onFileUploadButton());
        this.buttonDelete.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        this.buttonDelete.addActionListener(e -> this.onFileDeleteButton());
        this.buttonUploadClipboard.setToolTipText("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430");
        this.buttonUploadClipboard.addActionListener(e -> this.onUploadClipboardButton());
        this.spellChecker.addActionListener(e -> this.messageText.checkSpell());
        this.from.setEditable(false);
        this.to.setEditable(false);
        this.setLayout(new GridBagLayout());
        this.add(this.getMessagePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.getFromToPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getFilesPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.getCommentPanel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.getBottomPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getMessagePanel() {
        this.checkBox.addActionListener(e -> this.lineWrappingBorderLayout.setLineWrapping(this.checkBox.isSelected()));
        this.checkBox.setSelected(true);
        JPanel messageP = new JPanel(this.lineWrappingBorderLayout);
        messageP.add(this.messageText);
        JScrollPane messageScroll = new JScrollPane(messageP);
        messageScroll.getVerticalScrollBar().setUnitIncrement(16);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0422\u0435\u043a\u0441\u0442: "));
        panel.add((Component)messageScroll, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.checkBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.spellChecker, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getBottomPanel() {
        this.buttonPrev.addActionListener(e -> this.panel.onPrevButton());
        this.buttonNext.addActionListener(e -> this.panel.onNextButton());
        this.buttonIReadThis.addActionListener(e -> this.onReadThisMessage());
        this.buttonReply.addActionListener(e -> this.onReplyButton());
        this.buttonReset.addActionListener(e -> this.startEdit(this.replyId, this.topicId, this.topicUserId, this.mode));
        this.buttonSave.addActionListener(e -> this.stopEdit(true));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.buttonPrev, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.buttonNext, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.buttonIReadThis, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 25, 0, 0), 0, 0));
        panel.add((Component)this.buttonReply, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 25, 0, 0), 0, 0));
        panel.add((Component)this.buttonReset, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 25, 0, 0), 0, 0));
        panel.add((Component)this.buttonSave, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        Color bgColor = this.comment.getBackground();
        this.comment.setEditable(false);
        this.comment.setBackground(bgColor);
        BGButton buttonEditComment = new BGButton();
        buttonEditComment.setIcon((Icon)ClientUtils.getIcon((String)"edit"));
        buttonEditComment.addActionListener(e -> this.getCommentEditorDialog().setVisible(true));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.comment, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)buttonEditComment, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JDialog getCommentEditorDialog() {
        JTextArea commentEditor = new JTextArea(4, 50);
        commentEditor.setLineWrap(true);
        commentEditor.setWrapStyleWord(true);
        commentEditor.setMargin(new Insets(3, 3, 3, 3));
        commentEditor.setText(this.comment.getText());
        BGOptionPane optionPane = new BGOptionPane((Object)new JScrollPane(commentEditor), "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                this.getHelpdeskService().messageCommentUpdate(Utils.parseInt((String)this.id), commentEditor.getText().trim());
                this.panel.performAction("refresh");
                this.comment.setText(commentEditor.getText());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
            dialog.setVisible(false);
            dialog.dispose();
        });
        return dialog;
    }

    private JPanel getFromToPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u0442 [\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e]:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.from, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u0443 [\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e]:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.to, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getFilesPanel() {
        final JPanel panel = new JPanel(new GridBagLayout());
        final JScrollPane scrollPane = new JScrollPane((Component)this.tableFiles);
        this.tableFiles.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    HelpdeskMessageEditor.this.onFileOpenButton();
                }
                super.mouseClicked(e);
            }
        });
        panel.setDropTarget(new DropTarget(){
            Color defColor = UIManager.getColor("Panel.background");

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void drop(DropTargetDropEvent event) {
                try {
                    if (!HelpdeskMessageEditor.this.buttonUpload.isEnabled()) {
                        return;
                    }
                    this.changeToNormal();
                    Transferable transfer = event.getTransferable();
                    if (transfer.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        event.acceptDrop(3);
                        List objects = (List)transfer.getTransferData(DataFlavor.javaFileListFlavor);
                        for (Object object : objects) {
                            if (!(object instanceof File)) continue;
                            File file = (File)object;
                            if (file.isDirectory()) {
                                throw new BGMessageException("\u041c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u0439\u043b\u044b!");
                            }
                            HelpdeskMessageEditor.this.selectFilePanel.setSelectFile(file);
                            HelpdeskMessageEditor.this.onFileUploadButton();
                        }
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                finally {
                    event.dropComplete(true);
                }
            }

            @Override
            public synchronized void dragEnter(DropTargetDragEvent dtde) {
                if (HelpdeskMessageEditor.this.buttonUpload.isEnabled()) {
                    HelpdeskMessageEditor.this.setCursor(new Cursor(12));
                    panel.setBackground(Color.WHITE);
                    scrollPane.getViewport().setBackground(Color.WHITE);
                }
            }

            @Override
            public synchronized void dragExit(DropTargetEvent dtde) {
                this.changeToNormal();
            }

            private void changeToNormal() {
                HelpdeskMessageEditor.this.setCursor(new Cursor(0));
                panel.setBackground(this.defColor);
                scrollPane.getViewport().setBackground(this.defColor);
            }
        });
        panel.setBorder((Border)new BGTitleBorder(" \u0412\u043b\u043e\u0436\u0435\u043d\u0438\u044f: "));
        panel.setMinimumSize(new Dimension(350, 150));
        panel.setPreferredSize(new Dimension(350, 150));
        panel.add((Component)this.buttonOpen, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.buttonDownload, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.buttonUpload, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.buttonDelete, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.buttonUploadClipboard, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.selectFilePanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 1, 6, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setButtonStates(boolean prevEnabled, boolean nextEnabled) {
        this.buttonPrev.setEnabled(prevEnabled);
        this.buttonNext.setEnabled(nextEnabled);
    }

    public void startEdit(String id, int topicId, int topicUserId, int mode) {
        this.id = id;
        this.topicId = topicId;
        this.topicUserId = topicUserId;
        try {
            UserInfo userInfo = (UserInfo)this.getContext().getDirectory(UserInfo.class, 0).get(topicUserId);
            this.myUserName = userInfo == null ? "??? [#ID=" + topicUserId + "]" : userInfo.getName();
        }
        catch (BGException e1) {
            e1.printStackTrace();
        }
        if (mode == 2) {
            this.replyId = id;
            this.id = "new";
            this.uuid = UUID.randomUUID().toString();
        }
        this.mode = mode;
        this.filesTableModel.setData(new ArrayList());
        Message message = null;
        switch (mode) {
            case 3: {
                this.uuid = UUID.randomUUID().toString();
                this.from.setText("");
                this.to.setText("");
                this.messageText.setText("");
                this.messageText.setEditable(true);
                this.buttonReset.setEnabled(true);
                this.buttonSave.setEnabled(true);
                this.selectFilePanel.setEnabled(true);
                this.tableFiles.setEnabled(true);
                this.buttonDownload.setEnabled(true);
                this.buttonUpload.setEnabled(true);
                this.buttonDelete.setEnabled(true);
                this.buttonUploadClipboard.setEnabled(true);
                this.buttonIReadThis.setEnabled(false);
                this.buttonPrev.setEnabled(false);
                this.buttonNext.setEnabled(false);
                this.buttonReply.setEnabled(false);
                break;
            }
            case 1: {
                try {
                    message = ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).messageGet(this.getContext().getContractId(), topicId, Utils.parseInt((String)id));
                    this.messageText.setText(message.getBody());
                    StringBuffer buf = new StringBuffer();
                    buf.append(message.getUserNameFrom());
                    buf.append(" [");
                    buf.append(TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm:ss"));
                    buf.append("]");
                    this.from.setText(buf.toString());
                    buf = new StringBuffer();
                    String val = message.getUserNameTo();
                    if (!val.isEmpty()) {
                        buf.append(val);
                    }
                    if (!(val = TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm:ss")).isEmpty()) {
                        buf.append(" [");
                        buf.append(val);
                        buf.append("]");
                    }
                    this.to.setText(buf.toString());
                    this.comment.setText(message.getComment());
                    this.uuid = message.getUuid();
                    int userIdTo = message.getUserIdTo();
                    int userIdFrom = message.getUserIdFrom();
                    if (userIdFrom == 0) {
                        this.messageText.setEditable(false);
                        this.selectFilePanel.setEnabled(true);
                        this.tableFiles.setEnabled(true);
                        this.buttonDownload.setEnabled(true);
                        this.buttonUpload.setEnabled(false);
                        this.buttonDelete.setEnabled(false);
                        this.buttonUploadClipboard.setEnabled(false);
                        this.buttonPrev.setEnabled(true);
                        this.buttonNext.setEnabled(true);
                        this.buttonReply.setEnabled(true);
                        this.buttonIReadThis.setEnabled(userIdTo == -1);
                        this.buttonReset.setEnabled(false);
                        this.buttonSave.setEnabled(false);
                    } else if (topicUserId == userIdFrom && userIdTo == -1) {
                        this.messageText.setEditable(true);
                        this.selectFilePanel.setEnabled(true);
                        this.tableFiles.setEnabled(true);
                        this.buttonDownload.setEnabled(true);
                        this.buttonUpload.setEnabled(true);
                        this.buttonDelete.setEnabled(true);
                        this.buttonUploadClipboard.setEnabled(true);
                        this.buttonPrev.setEnabled(true);
                        this.buttonNext.setEnabled(true);
                        this.buttonReply.setEnabled(false);
                        this.buttonIReadThis.setEnabled(false);
                        this.buttonReset.setEnabled(true);
                        this.buttonSave.setEnabled(true);
                    } else {
                        this.messageText.setEditable(false);
                        this.selectFilePanel.setEnabled(true);
                        this.tableFiles.setEnabled(true);
                        this.buttonDownload.setEnabled(true);
                        this.buttonUpload.setEnabled(false);
                        this.buttonDelete.setEnabled(false);
                        this.buttonPrev.setEnabled(true);
                        this.buttonNext.setEnabled(true);
                        this.buttonReply.setEnabled(false);
                        this.buttonIReadThis.setEnabled(false);
                        this.buttonReset.setEnabled(false);
                        this.buttonSave.setEnabled(false);
                    }
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
                try {
                    this.filesTableModel.setData(((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).getMessageFileList(Utils.parseInt((String)id)));
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
                break;
            }
            case 2: {
                try {
                    message = ((HelpdeskService)this.getContext().getWebService(HelpdeskService.class)).messageGet(this.getContext().getContractId(), topicId, Utils.parseInt((String)this.replyId));
                    String replyDate = TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm:ss");
                    this.messageText.setText(this.makeReplydText(this.replyId, message.getBody(), message.getUserNameFrom(), replyDate));
                    this.from.setText(this.myUserName);
                    this.to.setText("\u041a\u043b\u0438\u0435\u043d\u0442");
                    this.comment.setText("");
                    this.messageText.setEditable(true);
                    this.buttonReset.setEnabled(true);
                    this.buttonSave.setEnabled(true);
                    this.selectFilePanel.setEnabled(true);
                    this.tableFiles.setEnabled(true);
                    this.buttonDownload.setEnabled(true);
                    this.buttonUpload.setEnabled(true);
                    this.buttonDelete.setEnabled(true);
                    this.buttonUploadClipboard.setEnabled(true);
                    this.buttonIReadThis.setEnabled(false);
                    this.buttonPrev.setEnabled(false);
                    this.buttonNext.setEnabled(false);
                    this.buttonReply.setEnabled(false);
                    break;
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        }
        this.setBorder((Border)new BGTitleBorder((String)("new".equals(this.id) ? "\u041d\u043e\u0432\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435" : " \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 #" + this.id + " ")));
        this.spellChecker.setEnabled(!this.buttonReply.isEnabled());
        this.messageText.requestFocus();
    }

    private String makeReplydText(String replyId, String replyText, String replyUser, String replyDate) {
        StringBuffer buf = new StringBuffer(1024);
        buf.append(replyUser);
        buf.append(" \u043f\u0438\u0441\u0430\u043b (\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 #");
        buf.append(replyId);
        buf.append(" \u043e\u0442 ");
        buf.append(replyDate);
        buf.append("):\n");
        StringTokenizer st = new StringTokenizer(replyText.replaceAll("\n\n", "\n \n"), "\n");
        while (st.hasMoreTokens()) {
            buf.append(">>");
            buf.append(st.nextToken());
            buf.append("\n");
        }
        return buf.toString();
    }

    private void stopEdit(boolean save) {
        if (save) {
            String userMy;
            Request request = new Request();
            request.setModule(this.getContext().getModule());
            request.setAction("UpdateMessage");
            request.setAttribute("id", this.id);
            request.setAttribute("topicId", this.topicId);
            request.setAttribute("body", this.messageText.getText());
            request.setAttribute("fileIds", Utils.toString((Iterable)this.filesTableModel.getRows().stream().map(e -> e.getId()).collect(Collectors.toList())));
            Document doc = this.getDocument(request);
            if (!ClientUtils.checkStatus((Document)doc)) {
                return;
            }
            if (this.mode == 2 && !"0".equals(this.replyId)) {
                try {
                    this.getHelpdeskService().messageAdminReadSet(Utils.parseInt((String)this.replyId));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            if ("none".equals(userMy = XMLUtils.selectText((Node)doc, (String)"/data/message/@userMy", (String)"")) || "notmy".equals(userMy)) {
                String mess;
                String string = mess = "none".equals(userMy) ? "\u0422\u043e\u043f\u0438\u043a \u043d\u0435 \u0437\u0430\u043d\u044f\u0442 \u043d\u0438\u043a\u0435\u043c, " : "\u0422\u043e\u043f\u0438\u043a \u043a\u0443\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0434\u0440\u0443\u0433\u0438\u043c \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u043e\u043c, ";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e. " + mess + "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0412\u0430\u0441 \u043a\u0443\u0440\u0430\u0442\u043e\u0440\u043e\u043c?", "\u0412\u043e\u043f\u0440\u043e\u0441", 0) == 0) {
                    String topicIdThis = XMLUtils.selectText((Node)doc, (String)"/data/message/@topicId", (String)"");
                    try {
                        this.getHelpdeskService().topicBindSet(Utils.parseInt((String)topicIdThis), "me");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
            this.panel.performAction("refresh");
            this.panel.performAction("edit");
        }
    }

    private void onReadThisMessage() {
        try {
            this.getHelpdeskService().messageAdminReadSet(Utils.parseInt((String)this.id));
            this.panel.performAction("refresh");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void onReplyButton() {
        this.panel.editItem(this.id, 2);
    }

    private void onFileDownloadButton() {
        FileInfo fileInfo = (FileInfo)this.filesTableModel.getSelectedRow();
        if (fileInfo != null) {
            try {
                File tmpfile = File.createTempFile("helpdesk-open-file-", String.valueOf(fileInfo.getId()));
                DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                BGServerFile bgServerFile = transferData.downloadFile("ru.bitel.bgbilling.plugins.helpdesk/downloadHelpdeskFile", fileInfo.getId(), this.getContext().getContractId(), tmpfile);
                String title = bgServerFile.getTitle();
                BGFileChooser chooser = new BGFileChooser((Component)JOptionPane.getRootFrame());
                File dir = chooser.getCurrentDirectory();
                File selfile = new File(dir.getAbsoluteFile() + File.separator + title);
                chooser.setSelectedFile(selfile);
                if (chooser.showSaveDialog() == 0) {
                    Files.move(tmpfile.toPath(), chooser.getSelectedFile().toPath(), new CopyOption[0]);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void onFileOpenButton() {
        FileInfo fileInfo = (FileInfo)this.filesTableModel.getSelectedRow();
        if (fileInfo != null) {
            try {
                File destFile;
                File tmpfile = File.createTempFile("helpdesk-open-file-", String.valueOf(fileInfo.getId()));
                DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                BGServerFile bgServerFile = transferData.downloadFile("ru.bitel.bgbilling.plugins.helpdesk/downloadHelpdeskFile", fileInfo.getId(), this.getContext().getContractId(), tmpfile);
                int counter = 0;
                String file = bgServerFile.getTitle();
                String fileName = "";
                String fileExt = "";
                if (!file.isEmpty() && !file.equals(".")) {
                    int dotPos = file.lastIndexOf(".");
                    if (dotPos == -1) {
                        fileName = file;
                    } else if (dotPos == file.length() - 1) {
                        fileName = file.substring(0, dotPos);
                    } else if (dotPos == 0) {
                        fileExt = file.substring(1);
                    } else {
                        fileName = file.substring(0, dotPos);
                        fileExt = file.substring(dotPos + 1);
                    }
                }
                if (fileName.isBlank() && fileExt.isBlank()) {
                    fileName = "noname";
                }
                do {
                    destFile = new File(tmpfile.getParent(), (String)(counter > 0 ? fileName + "-(" + counter + ")" + (String)(fileExt.isEmpty() ? "" : "." + fileExt) : file));
                    ++counter;
                } while (Files.exists(destFile.toPath(), new LinkOption[0]));
                Files.move(tmpfile.toPath(), destFile.toPath(), new CopyOption[0]);
                ClientUtils.openFile((File)destFile);
                destFile.deleteOnExit();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043f\u043e\u0442\u043e\u043a\u0430, \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0437\u0430\u043f\u0438\u0441\u0438: " + e.getMessage()));
            }
        }
    }

    private void onFileUploadButton() {
        File file = this.selectFilePanel.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
            return;
        }
        String errfiles = null;
        errfiles = Utils.checkCanReadFiles((File[])new File[]{file});
        if (errfiles != null) {
            ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430(\u043e\u0432):\n" + errfiles));
            return;
        }
        if (ClientUtils.confirm((String)("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b(\u044b):\n" + Utils.getNamesFiles((File[])new File[]{file})), (String)"\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c")) {
            try {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setId(-1);
                fileInfo.setTitle(file.getName());
                fileInfo.setSize(new BigDecimal(file.length()));
                DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                BGServerFile bgServerFile = new BGServerFile();
                bgServerFile.setContractId(this.getContractId());
                bgServerFile.setDate(new Date());
                bgServerFile.setTitle(file.getName());
                bgServerFile.setComment("");
                bgServerFile.setSize(file.length());
                bgServerFile.setOwnerId("new".equals(this.id) ? -1 : Utils.parseInt((String)this.id));
                bgServerFile.setUuid(this.uuid);
                fileInfo.setId(transferData.uploadFile("ru.bitel.bgbilling.plugins.helpdesk/uploadHelpdeskFile", bgServerFile, file));
                this.selectFilePanel.reset();
                this.filesTableModel.addRow(fileInfo);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    private void onFileDeleteButton() {
        FileInfo fileInfo = (FileInfo)this.filesTableModel.getSelectedRow();
        if (fileInfo != null && ClientUtils.confirmDelete((Object)fileInfo.getTitle())) {
            try {
                this.getHelpdeskService().fileDelete(fileInfo.getId());
                Optional.ofNullable((FileInfo)this.filesTableModel.getSelectedRow()).ifPresent(selectedFile -> this.filesTableModel.deleteRow(selectedFile));
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUploadClipboardButton() {
        DataFlavor[] dataFlavors;
        File file = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        for (DataFlavor dataFlavor : dataFlavors = clipboard.getAvailableDataFlavors()) {
            Class<?> clazz = dataFlavor.getRepresentationClass();
            if (!clazz.equals(InputStream.class)) continue;
            try {
                file = File.createTempFile(dataFlavor.getPrimaryType() + "_", "." + dataFlavor.getSubType());
                Files.copy((InputStream)clipboard.getData(dataFlavor), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            break;
        }
        if (file != null) {
            try {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setId(-1);
                fileInfo.setTitle(file.getName());
                fileInfo.setSize(new BigDecimal(file.length()));
                DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                BGServerFile bgServerFile = new BGServerFile();
                bgServerFile.setContractId(this.getContractId());
                bgServerFile.setDate(new Date());
                bgServerFile.setTitle(file.getName());
                bgServerFile.setComment("");
                bgServerFile.setSize(file.length());
                bgServerFile.setOwnerId("new".equals(this.id) ? -1 : Utils.parseInt((String)this.id));
                bgServerFile.setUuid(this.uuid);
                fileInfo.setId(transferData.uploadFile("ru.bitel.bgbilling.plugins.helpdesk/uploadHelpdeskFile", bgServerFile, file));
                this.selectFilePanel.reset();
                this.filesTableModel.addRow(fileInfo);
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            finally {
                file.delete();
            }
        }
    }

    private HelpdeskService getHelpdeskService() {
        if (this.helpdeskService == null) {
            this.helpdeskService = (HelpdeskService)this.getContext().getPort(HelpdeskService.class);
        }
        return this.helpdeskService;
    }

    private class LineWrappingBorderLayout
    extends BorderLayout {
        Dimension dimension = new Dimension();
        boolean lineWrapping = true;

        private LineWrappingBorderLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            if (this.lineWrapping) {
                this.dimension.setSize(HelpdeskMessageEditor.this.messageText.getVisibleRect().width, HelpdeskMessageEditor.this.messageText.getPreferredSize().height);
                return this.dimension;
            }
            return super.preferredLayoutSize(target);
        }

        public void setLineWrapping(boolean lineWrapping) {
            this.lineWrapping = lineWrapping;
            HelpdeskMessageEditor.this.messageText.updateUI();
        }
    }

    class FilesTableModel
    extends BGTableModel<FileInfo> {
        public FilesTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0437\u043c\u0435\u0440", 80, 90, 100, "size", true).setTableCellRenderer((TableCellRenderer)DecimalTableCellRenderer.INTEGER());
        }
    }
}

