/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess.create;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionMapAuto;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionAutoRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.create.InetConnectionAutoRuntimeCreateSessions;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.sql.ConnectionSet;

public class ConnectionMapAutoCreateSessions
extends ConnectionMapAuto {
    private static final Logger logger = LogManager.getLogger();
    private final Date day;
    private final Integer deviceId;

    public ConnectionMapAutoCreateSessions(Accounting accounting, Date day, Integer deviceId) throws BGException {
        super(accounting);
        this.day = day;
        this.deviceId = deviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ConnectionSet connectionSet) throws BGException {
        Connection con = connectionSet.getConnection();
        InetServDao inetServDao = new InetServDao(con, this.accounting.moduleId);
        try {
            Date dateFrom = this.day;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(this.day);
            ((Calendar)cal).add(5, 1);
            Date dateTo = cal.getTime();
            ((Calendar)cal).add(14, -1);
            Date sessionStop = cal.getTime();
            Set<Integer> deviceIds = this.accounting.getFlowDevices(this.deviceId);
            List<InetServ> inetServList = inetServDao.list(deviceIds, dateFrom, dateTo, null);
            for (InetServ serv : inetServList) {
                InetSessionLog inetSession = new InetSessionLog();
                inetSession.setDeviceId(serv.getDeviceId());
                inetSession.setContractId(serv.getContractId());
                inetSession.setServId(serv.getId());
                inetSession.setSessionStart(dateFrom);
                inetSession.setSessionStop(sessionStop);
                InetConnection inetConnection = new InetConnection(inetSession);
                InetServRuntime inetServRuntime = this.accounting.inetServRuntimeMap.get(serv.getId());
                if (inetServRuntime == null) {
                    logger.error("InetServ not found with id=" + serv.getId());
                    continue;
                }
                inetServRuntime.lock();
                try {
                    InetConnectionAutoRuntimeCreateSessions newConnectionRuntime = new InetConnectionAutoRuntimeCreateSessions(this.accounting, inetServRuntime, inetConnection, (InetSession)inetSession);
                    if (inetSession != null) {
                        this.accounting.registerAutoInetAddress(newConnectionRuntime.connection.getDeviceId(), newConnectionRuntime);
                    }
                    newConnectionRuntime.setInetOptions(inetServRuntime.getInetServ().getDeviceOptions());
                    ConcurrentMap<Integer, InetConnectionAutoRuntime> sessionMap = this.getSessionMap(serv.getDeviceId(), null);
                    sessionMap.put(serv.getId(), newConnectionRuntime);
                }
                finally {
                    inetServRuntime.unlock();
                }
            }
        }
        finally {
            inetServDao.recycle();
        }
    }
}

